/*
 * Copyright 2017, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tenqube.visual_scraper.db.dao;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;

import com.tenqube.visual_scraper.db.entity.OrderEntity;

import java.util.Date;
import java.util.List;


@Dao
public interface OrderDao {

    @Insert(onConflict = OnConflictStrategy.IGNORE)
    long insert(OrderEntity product);

    @Insert(onConflict = OnConflictStrategy.IGNORE)
    List<Long> insertList(List<OrderEntity> product);

    @Query( "SELECT * " +
            "FROM orders " +
            "WHERE is_delete = 0 " +
            "ORDER BY order_date DESC, _id DESC " +
            "LIMIT :limit")
    List<OrderEntity> getOrderList(int limit);

    /**
     * 더보기시 마지막 아이디 보다 작고,
     * @param lastOrderId
     * @return
     */
    @Query( "SELECT * " +
            "FROM orders " +
            "WHERE is_delete = 0 AND _id <= :lastOrderId " +
            "AND (order_date < :bottomOrderDate OR (order_date = :bottomOrderDate AND _id < :bottomOrderId)) "+
            "ORDER BY order_date DESC, _id DESC " +
            "LIMIT :limit")
    List<OrderEntity> getOrdersForViewMore(int limit, int lastOrderId, Date bottomOrderDate, int bottomOrderId);

    @Query("SELECT _id " +
            "FROM orders " +
            "ORDER BY _id DESC " +
            "LIMIT 1")
    Integer getLastOrderId();

    @Query( "SELECT * " +
            "FROM orders WHERE _id IN (:ids) AND is_delete = 0 " +
            "ORDER BY order_date DESC")
    List<OrderEntity> getOrderList(List<Long> ids);

    @Query( "SELECT * " +
            "FROM orders WHERE mall_id IN (:mIds) AND is_delete = 0 " +
            "ORDER BY order_date DESC")
    List<OrderEntity> getOrders(int...mIds);

    @Query("SELECT * " +
            "FROM orders WHERE mall_id = :mId AND is_delete = 0 " +
            "ORDER BY order_date DESC ")
    List<OrderEntity> getOrders(int mId);

    @Query( "SELECT * " +
            "FROM orders " +
            "WHERE is_send_server = 0 AND is_delete = 0 " +
            "ORDER BY order_date DESC")
    List<OrderEntity> getOrdersForServer();

    @Query("UPDATE orders SET is_delete = 1 WHERE _id = :orderId")
    void hideOrder(int orderId);

    @Query("DELETE FROM orders WHERE _id = :orderId")
    void deleteOrder(int orderId);

    @Query("DELETE FROM orders WHERE _id IN (:orderId)")
    void deleteOrders(int... orderId);

    @Query("DELETE FROM orders WHERE mall_id = :mallId")
    void deleteOrdersForMallId(int mallId);

    @Query("DELETE FROM orders WHERE _id IN (:mallIds)")
    void deleteOrderForMallIds(int... mallIds);

    @Query("DELETE FROM orders")
    void deleteAll();

    @Query("UPDATE orders SET is_send_server = 1 WHERE _id IN(:ids)")
    void updateIsSendServer(List<Integer> ids);

//    @Query("SELECT * " +
//            "FROM orders WHERE mall_name IN (:malls)")
//    List<OrderEntity> getOrders(List<String> malls);

}
