/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.webkit.WebView;
import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.MallViewService;
import com.tenqube.visual_scraper.ParameterException;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.query.MallWithUser;
import com.tenqube.visual_scraper.model.query.Password;
import com.tenqube.visual_scraper.model.view.MallInfo;
import com.tenqube.visual_scraper.model.view.OrderInfo;
import com.tenqube.visual_scraper.model.view.ViewMoreInfo;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.FactoryMall;
import com.tenqube.visual_scraper.scrap.mall.Mall;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.List;
import java.util.Locale;
import timber.log.Timber;

public class ScrapServiceImpl
implements ScrapService {
    public Context context;
    private final String apiKey;
    private final String qualifier;
    ScrapRepository repository;
    private SharedPreferences preferences;
    private WebViewManager mWebViewManager;
    private String uuid;
    private String serviceAppName;
    private MallViewService mallViewService;
    public static Locale locale;
    public SparseBooleanArray progressStateArray = new SparseBooleanArray();

    public ScrapServiceImpl(@NonNull Context context, @NonNull MallViewService mallViewService, @NonNull String apiKey, @NonNull String qualifier, @NonNull String uuid, @NonNull String serviceAppName) throws ParameterException {
        this.context = context;
        this.apiKey = apiKey;
        this.qualifier = qualifier;
        this.initLocale();
        this.preferences = Injection.provideSharedPreference(context);
        this.repository = Injection.provideScrapRepository(context.getApplicationContext(), this.preferences);
        this.repository.saveKey(apiKey);
        this.repository.saveLayer(qualifier);
        this.mallViewService = mallViewService;
        this.uuid = uuid;
        this.serviceAppName = serviceAppName;
    }

    private void initLocale() {
        locale = Build.VERSION.SDK_INT >= 24 ? this.context.getResources().getConfiguration().getLocales().get(0) : this.context.getResources().getConfiguration().locale;
    }

    @Override
    public WebView getWebView() {
        return this.mWebViewManager.getWebView();
    }

    @Override
    public void startLoginAndParsing(String userId, String userPwd, int mId, ScrapService.OnResultCallback<List<OrderEntity>> onResult) throws ParameterException {
        Log.i((String)"startLoginAndParsing", (String)(userId + "/" + mId + "/" + userPwd));
        if (TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)userPwd) || mId == 0) {
            throw new ParameterException("empty parameter");
        }
        if (!this.preferences.getString("uuid", "").equals(this.uuid)) {
            this.repository.signUpUser(this.serviceAppName, this.uuid, Void2 -> this.logInAndParsing(userId, userPwd, mId, onResult));
        } else {
            this.logInAndParsing(userId, userPwd, mId, onResult);
        }
    }

    private void logInAndParsing(String userId, String userPwd, int mId, final ScrapService.OnResultCallback<List<OrderEntity>> onResult) {
        if (this.isEnabledSDK()) {
            return;
        }
        this.repository.syncRule(callback -> {
            Log.i((String)"logInAndParsing", (String)"syncRule success");
            new Thread(() -> {
                this.progressStateArray.put(mId, true);
                this.start(userId, userPwd, mId, new ScrapService.OnResult<List<OrderEntity>>(){

                    @Override
                    public void onSuccess(int mId, List<OrderEntity> itemList, String msg) {
                        ScrapServiceImpl.this.progressStateArray.put(mId, false);
                        ScrapServiceImpl.this.repository.getOrderList(items -> onResult.onDataLoaded(itemList), mId);
                    }

                    @Override
                    public void onFail(int mId, Constants.ERROR error, String msg) {
                        ScrapServiceImpl.this.progressStateArray.put(mId, false);
                        Log.i((String)"logInAndParsing", (String)("error" + error.name() + "onFail" + msg));
                        onResult.onFail(mId, error, msg);
                    }
                });
            }).start();
        });
    }

    public void start(final String userId, final String userPwd, final int mId, final ScrapService.OnResult callback) {
        this.repository.checkIsActiveMall(mId, mall -> {
            if (mall == null) {
                return;
            }
            this.repository.getMallWithUser(mId, userId, new ScrapService.onResultInterface<MallWithUser>(){

                @Override
                public void onDataLoaded(MallWithUser item) {
                    Timber.i((String)"item : %s", (Object[])new Object[]{item});
                    ScrapServiceImpl.this.login(new MallWithUser(item.mall, new UserEntity(mId, userId, new Password(userPwd))), 2, callback);
                }

                @Override
                public void onFail() {
                    Timber.i((String)"mId : %s", (Object[])new Object[]{mId});
                    ScrapServiceImpl.this.login(new MallWithUser(mall, new UserEntity(mId, userId, new Password(userPwd))), 1, callback);
                }
            });
        });
    }

    private void login(MallWithUser mallWithUser, int crud, ScrapService.OnResult onResult) {
        Timber.i((String)("loginMallWithUser : " + mallWithUser), (Object[])new Object[0]);
        this.repository.getLoginRule(mallWithUser.mall.getId(), loginRule -> {
            WebViewManager webViewManager;
            Log.i((String)"login", (String)("loginRule : " + loginRule));
            this.mWebViewManager = webViewManager = new WebViewManager(this.context, this.mallViewService);
            Mall m = FactoryMall.create(mallWithUser.mall.getName(), this.repository, webViewManager);
            Log.i((String)"login", (String)("Mall : " + m));
            if (m == null) {
                return;
            }
            webViewManager.setMall(m);
            if (loginRule != null && loginRule.loginWebRule != null) {
                Log.i((String)"login", (String)"\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc874\uc7ac, startWebViewLogin");
                m.startWebViewLogin(loginRule.loginWebRule, mallWithUser.user, crud, onResult);
            } else {
                Log.i((String)"login", (String)"\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc5c6\uc74c ");
                onResult.onFail(mallWithUser.mall.getId(), Constants.ERROR.NOT_FOUND_LOGIN_RULE, mallWithUser.mall.getDisplayName() + " login rule does not exist");
            }
        });
    }

    @Override
    public void startParsingMalls(ScrapService.OnResultCallback<List<OrderEntity>> onResult) {
        if (!this.preferences.getString("uuid", "").equals(this.uuid)) {
            this.repository.signUpUser(this.serviceAppName, this.uuid, Void2 -> this.repository.syncRule(callback -> this.getMallsAndParsing(onResult)));
        } else {
            this.repository.syncRule(callback -> this.getMallsAndParsing(onResult));
        }
    }

    private void getMallsAndParsing(final ScrapService.OnResultCallback<List<OrderEntity>> onResult) {
        if (DateUtils.checkDiffTime(this.preferences.getLong("CHECK_PARSING_TIME", 0L), this.preferences.getInt("PARSING_FREQUENCY", 10))) {
            Log.i((String)"parsing", (String)"checkDiffTime true");
            this.preferences.edit().putLong("CHECK_PARSING_TIME", System.currentTimeMillis()).apply();
            this.repository.getMallWithActiveUsers(items -> {
                Log.i((String)"getMallsAndParsing", (String)("item : " + items));
                for (MallWithUser mallWithUser : items) {
                    Log.i((String)"getMallsAndParsing", (String)("mallWithUser : " + mallWithUser));
                    new Thread(() -> this.login(mallWithUser, 0, new ScrapService.OnResult<List<OrderEntity>>(){

                        @Override
                        public void onSuccess(int mId, List<OrderEntity> itemList, String msg) {
                            Log.i((String)"onSuccess", (String)("mId : " + mId + "Update size : " + itemList));
                            onResult.onDataLoaded(itemList);
                        }

                        @Override
                        public void onFail(int mId, Constants.ERROR error, String msg) {
                            Log.i((String)"onFail", (String)("mId : " + mId + "update error : " + (Object)((Object)error) + msg));
                        }
                    })).start();
                }
            });
        } else {
            Log.i((String)"getMallsAndParsing", (String)"request later");
            onResult.onFail(-1, Constants.ERROR.REQUEST_FREQUENT, "request later");
        }
    }

    @Override
    public void startParsingMall(int mallId, ScrapService.OnResultCallback<List<OrderEntity>> onResult) {
        if (!this.preferences.getString("uuid", "").equals(this.uuid)) {
            this.repository.signUpUser(this.serviceAppName, this.uuid, Void2 -> this.getInfoAndMallParsing(mallId, onResult));
        } else {
            this.getInfoAndMallParsing(mallId, onResult);
        }
    }

    private void getInfoAndMallParsing(int mallId, final ScrapService.OnResultCallback<List<OrderEntity>> onResult) {
        this.repository.getMallWithActiveUser(mallId, mallWithUser -> this.login((MallWithUser)mallWithUser, 0, new ScrapService.OnResult<List<OrderEntity>>(){

            @Override
            public void onSuccess(int mId, List<OrderEntity> itemList, String msg) {
                Log.i((String)"onSuccess", (String)("mId : " + mId + "Update size : " + itemList));
                onResult.onDataLoaded(itemList);
            }

            @Override
            public void onFail(int mId, Constants.ERROR error, String msg) {
                Log.i((String)"onFail", (String)("mId : " + mId + "update error : " + (Object)((Object)error) + msg));
            }
        }));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.preferences.edit().putBoolean("SDK_IS_ENABLE", enabled).apply();
    }

    private boolean isEnabledSDK() {
        return this.preferences.getBoolean("SDK_IS_ENABLE", false);
    }

    @Override
    public void getOrderList(int limit, ViewMoreInfo viewMoreInfo, ScrapService.OnResultCallback<List<OrderInfo>> callback) {
        this.repository.getOrderList(limit, viewMoreInfo, callback::onDataLoaded);
    }

    @Override
    public void getMallWithUsers(ScrapService.Callback<List<MallWithUser>> callback) {
        if (!this.preferences.getString("uuid", "").equals(this.uuid)) {
            this.repository.signUpUser(this.serviceAppName, this.uuid, Void2 -> this.getMalls(callback));
        } else {
            this.getMalls(callback);
        }
    }

    private void getMalls(ScrapService.Callback<List<MallWithUser>> callback) {
        this.repository.syncRule(mCallback -> this.repository.getMallWithUser(items -> {
            for (MallWithUser mallWithUser : items) {
                mallWithUser.setProgress(this.progressStateArray.get(mallWithUser.mall.getId()));
            }
            callback.onDataLoaded((List<MallWithUser>)items);
        }));
    }

    @Override
    public void signOut(int mId, ScrapService.OnResultCallback<Void> callback) {
        this.repository.updateUserForSignOut(mId, callback);
    }

    @Override
    public void hideOrder(int orderId) {
        this.repository.hideOrder(orderId);
    }

    @Override
    public void deleteOrder(int orderId) {
        this.repository.deleteOrder(orderId);
    }

    @Override
    public void deleteOrders(int ... orderIds) {
        this.repository.deleteOrder(orderIds);
    }

    @Override
    public void deleteAll(int ... mIds) {
        if (mIds != null) {
            this.repository.deleteForMallIds(new int[0]);
        } else {
            this.repository.deleteAll();
        }
    }

    @Override
    public void deleteForMallId(int mid) {
        this.repository.deleteForMallId(mid);
    }

    @Override
    public void insertUserEntity(UserEntity userEntity) {
        this.repository.insertUsers(userEntity);
    }

    @Override
    public void getMallList(ScrapService.Callback<List<MallInfo>> callback) {
        this.repository.getMallList(callback);
    }

    @Override
    public void setParsingFrequency(int frequency) {
        this.preferences.edit().putInt("PARSING_FREQUENCY", frequency).apply();
    }

    @Override
    public void setMallViewService(MallViewService mallViewService) {
        if (this.mWebViewManager != null) {
            this.mWebViewManager.setViewService(mallViewService);
        }
    }

    @Override
    public void getLastOrderId(ScrapService.Callback<Integer> callback) {
        this.repository.getLastOrderId(callback);
    }
}

