/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scrap.mall;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.LoginWebRule;
import com.tenqube.visual_scraper.db.entity.OrderApiRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderDetailWebRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.OrderWebRule;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.model.query.LoginRule;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.login.ApiLogin;
import com.tenqube.visual_scraper.scrap.login.LoginService;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.utils.DateUtils;
import com.tenqube.visual_scraper.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Mall {
    private AppExecutors appExecutors;
    LoginWebRule loginWebRule;
    OrderWebRule orderWebRule;
    OrderDetailWebRuleJson orderDetailWebRuleJson;
    OrderApiRuleJson orderApiRuleJson;
    final ScrapRepository repository;
    public final String mName;
    private WebViewManager webViewManager;

    public Mall(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        this.mName = mName;
        this.repository = repository;
        this.appExecutors = new AppExecutors();
        this.webViewManager = webViewManager;
    }

    public void startWebViewLogin(@NonNull LoginWebRule loginWebRule, final @NonNull UserEntity user, final int crud, final @NonNull ScrapService.OnResult<List<OrderEntity>> onResult) {
        Utils.getFinalLoginWebRule(loginWebRule, user.getUserId(), user.getUserPwd().getValue());
        this.loginWebRule = loginWebRule;
        this.webViewManager.setWebUrl(loginWebRule.getUrl().finalQuery).setScripts(loginWebRule.getLoginScripts().finalQuery).setAction(1).build(new WebViewManager.WebViewCallback(){

            @Override
            public void onResult(String cookie, WebView webView) {
                Log.i((String)"startWebViewLogin", (String)("login Success : cookie " + cookie + "/" + webView));
                if (crud != 0) {
                    user.setLogin(true);
                    Log.i((String)"insertUser", (String)("user : " + user));
                    Mall.this.repository.insertUsers(user);
                }
                Mall.this.repository.getOrderWebRule(user.getMallId(), webRule -> {
                    Log.i((String)"getOrderWebRule", (String)("info : " + webRule));
                    if (webRule != null) {
                        Mall.this.orderWebRule = webRule;
                        if (Mall.this.orderWebRule.getUrl() != null) {
                            Mall.this.orderWebRule.getUrl().finalQuery = Utils.getOrderValue(Mall.this.orderWebRule.getUrl(), user.getLastScrapAt());
                        }
                        if (Mall.this.orderWebRule.getPeriodScripts() != null) {
                            Mall.this.orderWebRule.getPeriodScripts().finalQuery = Utils.getOrderValue(Mall.this.orderWebRule.getPeriodScripts(), user.getLastScrapAt());
                        }
                        Log.i((String)"getOrderWebRule", (String)("final_info : " + Mall.this.orderWebRule));
                        Mall.this.repository.getDetailHtmlRule(user.getMallId(), detailWebRule -> {
                            Mall.this.orderDetailWebRuleJson = detailWebRule;
                            Mall.this.parseWeb(user, cookie, onResult, items -> {
                                Log.i((String)"parseWeb", (String)("items : " + items));
                                if (items != null && items.size() != 0) {
                                    Mall.this.repository.insertOrders((List<OrderEntity>)items, insertedList -> {
                                        Log.i((String)"success", (String)("item :" + items.size() + "/" + insertedList.size()));
                                        onResult.onSuccess(user.getMallId(), insertedList, Mall.this.mName + " \uac2f\uc218 : " + insertedList.size());
                                        if (insertedList.size() > 0) {
                                            Mall.this.repository.callInsertOrderList();
                                        }
                                    });
                                } else {
                                    onResult.onSuccess(user.getMallId(), null, Mall.this.mName + "/\uad6c\ub9e4\ub0b4\uc5ed\uc5c6\uc74c");
                                }
                            });
                        });
                    } else {
                        onResult.onFail(user.getMallId(), Constants.ERROR.NOT_FOUND_RULE, Mall.this.mName + " login_web");
                    }
                });
            }

            @Override
            public void onFail(int statusCode, String statusMessage) {
                Log.i((String)"login_web", (String)("onFail : " + statusCode + "/" + statusMessage));
                onResult.onFail(user.getMallId(), Constants.ERROR.LOGIN_FAIL, statusMessage);
            }
        });
    }

    public void startApiLogin(final LoginRule loginRule, final UserEntity user, final int crud, final @NonNull ScrapService.OnResult onResult) {
        ApiLogin loginService = new ApiLogin(loginRule.loginApiRule);
        this.appExecutors.networkIO().execute(() -> loginService.login(new LoginService.OnLoginCallback(){

            @Override
            public void onLoginSuccess(String cookie) {
                Mall.this.repository.getOrderApiRule(user.getMallId(), apiRule -> {});
            }

            @Override
            public void onLoginFail(int statusCode, String statusMessage) {
                Mall.this.startWebViewLogin(loginRule.loginWebRule, user, crud, onResult);
            }
        }));
    }

    private void parseWeb(final UserEntity user, String cookie, final ScrapService.OnResult onResult, final ScrapService.Callback<List<OrderEntity>> callback) {
        Runnable runnable = () -> {
            final ArrayList orders = new ArrayList();
            try {
                this.getOrderPageDocument(cookie, this.orderWebRule, new OrderCallback<Document>(){

                    @Override
                    public void onResult(Document document) {
                        Log.i((String)"parseWeb", (String)("onResult " + document));
                        List orderHtmls = Mall.this.convertToOrderHtmlList(document);
                        Log.i((String)"parseWeb", (String)("orderHtmls size : " + orderHtmls.size() + " orderHtmls : " + orderHtmls));
                        orders.addAll(Mall.this.convertToOrderEntity(orderHtmls, Mall.this.orderDetailWebRuleJson.getUrl()));
                        long lastScrapAt = Utils.getLastScrapAt();
                        Mall.this.repository.updateUserLastScrapAt(lastScrapAt, user.getMallId(), user.getUserId());
                        Mall.this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(orders));
                    }

                    @Override
                    public void onFail(int statusCode, String statusMessage) {
                        Mall.this.appExecutors.mainThread().execute(() -> onResult.onFail(user.getMallId(), Constants.ERROR.PARSING_FAIL, Mall.this.mName + statusMessage));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        this.appExecutors.networkIO().execute(runnable);
    }

    private List<OrderHtml> convertToOrderHtmlList(Document document) {
        Elements elements = this.getElements(document, this.orderWebRule);
        ArrayList<OrderHtml> orderHtmls = new ArrayList<OrderHtml>(this.getOrderHtmls(elements, this.orderWebRule));
        if (orderHtmls.size() == 0 && !TextUtils.isEmpty((CharSequence)this.orderWebRule.getContainer().equation)) {
            elements = document.select(String.format(this.orderWebRule.getContainer().selector, "n"));
            orderHtmls.addAll(this.getOrderHtmls(elements, this.orderWebRule));
        }
        return orderHtmls;
    }

    protected List<OrderHtml> getOrderHtmls(Elements elements, OrderWebRule orderWebRule) {
        ArrayList<OrderHtml> orderHtmls = new ArrayList<OrderHtml>();
        Log.i((String)"parseWeb", (String)("element_size : " + elements.size()));
        for (Element element : elements) {
            try {
                OrderHtml orderHtml = this.parseHtml(elements, element);
                if (orderHtml == null) continue;
                orderHtmls.add(orderHtml);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return orderHtmls;
    }

    private Elements getElements(Document document, OrderWebRule orderWebRule) {
        Elements elements = TextUtils.isEmpty((CharSequence)orderWebRule.getContainer().equation) ? document.select(orderWebRule.getContainer().selector) : document.select(String.format(orderWebRule.getContainer().selector, orderWebRule.getContainer().equation));
        return elements;
    }

    private List<OrderEntity> convertToOrderEntity(List<OrderHtml> orderHtmls, QueryRuleBody queryRuleBody) {
        ArrayList<OrderEntity> orders = new ArrayList<OrderEntity>();
        for (OrderHtml orderHtml : orderHtmls) {
            try {
                OrderEntity order = new OrderEntity();
                order.mId = this.orderWebRule.getMallId();
                order.title = this.titleFilter(orderHtml.title);
                order.orderDate = this.orderDateFilter(orderHtml.orderDate);
                order.orderHms = this.orderHmsFilter(orderHtml.orderHms);
                order.orderOption = this.orderOptionFilter(orderHtml.orderOption);
                order.quantity = this.quantityFilter(orderHtml.quantity);
                order.price = this.priceFilter(orderHtml.price);
                order.orderNum = this.orderNumFilter(orderHtml.orderNum);
                order.orderState = this.orderStateFilter(orderHtml.orderState);
                order.imgUrl = this.imgUrlFilter(orderHtml.imgUrl);
                order.currency = this.currencyFilter(orderHtml.price);
                order.detailOrderLink = orderHtml.detailOrderLink;
                order.detailProductLink = orderHtml.detailProdLink;
                Log.i((String)"filter", (String)("info : " + order));
                if (TextUtils.isEmpty((CharSequence)order.title) || order.orderDate == null || TextUtils.isEmpty((CharSequence)order.orderNum)) continue;
                if (TextUtils.isEmpty((CharSequence)order.detailOrderLink) && queryRuleBody != null) {
                    Log.i((String)"detailUrl", (String)("" + queryRuleBody + "//" + order.orderNum));
                    order.detailOrderLink = Utils.getFinalDetailUrl(queryRuleBody, order.orderNum);
                }
                orders.add(order);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return orders;
    }

    private void getOrderPageDocument(String cookie, final OrderWebRule orderWebRule, final OrderCallback<Document> orderCallback) throws IOException {
        try {
            this.webViewManager.setWebUrl(orderWebRule.getUrl().finalQuery).setScripts(orderWebRule.getPeriodScripts() == null ? null : orderWebRule.getPeriodScripts().finalQuery).setAction(2).build(new WebViewManager.WebViewCallback(){

                @Override
                public void onResult(String html, WebView webView) {
                    Document document = Jsoup.parse((String)html, (String)orderWebRule.getUrl().finalQuery);
                    if (document != null) {
                        orderCallback.onResult(document);
                    }
                }

                @Override
                public void onFail(int statusCode, String statusMessage) {
                    Log.i((String)"login_web", (String)("onFail : " + statusCode + "/" + statusMessage));
                    orderCallback.onFail(statusCode, statusMessage);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            orderCallback.onFail(403, "getOrderPageDocument crash");
        }
    }

    protected Document makeDocument(Document document) {
        return document;
    }

    protected OrderHtml parseHtml(Elements elements, @NonNull Element element) {
        OrderHtml order = new OrderHtml();
        order.title = this.parseValue(element, this.orderWebRule.getTitle());
        order.orderDate = this.parseValue(element, this.orderWebRule.getOrderDate());
        order.orderHms = this.parseValue(element, this.orderWebRule.getOrderHms());
        order.orderOption = this.parseValue(element, this.orderWebRule.getOrderOption());
        order.quantity = this.parseValue(element, this.orderWebRule.getQuantity());
        order.price = this.parseValue(element, this.orderWebRule.getPrice());
        order.orderNum = this.parseValue(element, this.orderWebRule.getOrderNum());
        order.orderState = this.parseValue(element, this.orderWebRule.getOrderState());
        order.imgUrl = this.parseValue(element, this.orderWebRule.getImgUrl());
        order.detailOrderLink = this.parseValue(element, this.orderWebRule.getDetailOrderLink());
        order.detailProdLink = this.parseValue(element, this.orderWebRule.getDetailProductLink());
        Log.i((String)"parseHtml", (String)("order : " + order));
        if (TextUtils.isEmpty((CharSequence)order.title) || TextUtils.isEmpty((CharSequence)order.orderNum)) {
            return null;
        }
        return order;
    }

    protected String titleFilter(@NonNull String title) {
        return title;
    }

    protected Date orderDateFilter(@NonNull String orderDate) {
        return TextUtils.isEmpty((CharSequence)orderDate) ? null : DateUtils.transformDate(orderDate, Constants.DateFormatType.DASH);
    }

    protected Date orderHmsFilter(@NonNull String orderHms) {
        return TextUtils.isEmpty((CharSequence)orderHms) ? null : DateUtils.transformHms(orderHms);
    }

    protected String orderOptionFilter(@NonNull String orderOption) {
        return orderOption;
    }

    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        return TextUtils.isEmpty((CharSequence)quantity) ? 1 : Integer.parseInt(quantity);
    }

    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return TextUtils.isEmpty((CharSequence)price) ? 0.0 : Double.parseDouble(price.replace(",", "").replace("\uc6d0", ""));
    }

    protected String orderNumFilter(@NonNull String orderNum) {
        return orderNum;
    }

    protected String orderStateFilter(@NonNull String orderState) {
        return orderState;
    }

    protected String imgUrlFilter(@NonNull String imgUrl) {
        return imgUrl;
    }

    protected String currencyFilter(@NonNull String price) {
        return price.contains(".") ? "USD" : "KRW";
    }

    String parseValue(Element element, ParsingOrderRules parsingOrderRules) {
        boolean pos = false;
        if (parsingOrderRules == null) {
            return "";
        }
        String key = parsingOrderRules.selector;
        String attr = parsingOrderRules.attribute;
        String result = "";
        Log.i((String)"parseValue", (String)("key : " + key + "/attr : " + attr));
        try {
            if (!TextUtils.isEmpty((CharSequence)key)) {
                if (key.contains("br")) {
                    key = key.replace("br", "b");
                    int classPos = key.indexOf(".");
                    int classPosEnd = key.indexOf(" ", classPos);
                    String classKey = key.substring(classPos, classPosEnd);
                    Element tempValue = (Element)element.select(classKey).get(0);
                    Document replace = Jsoup.parse((String)tempValue.toString().replace("br", "b"));
                    Log.i((String)"parseValue", (String)("replace : " + replace));
                    element = replace;
                }
                Element value = element.select(key).first();
                Log.i((String)"parseValue", (String)("value : " + value));
                if (value != null) {
                    result = TextUtils.isEmpty((CharSequence)attr) ? value.text() : (attr.contains("href") ? value.absUrl("href") : value.attr(attr));
                }
                Log.i((String)"parseValue", (String)("result : " + result));
            }
        }
        catch (Exception e) {
            result = "";
            e.printStackTrace();
        }
        return result;
    }

    public boolean doCheckLoginError() {
        return this.loginWebRule.getFailMessage() != null && !TextUtils.isEmpty((CharSequence)this.loginWebRule.getFailMessage().selector);
    }

    public boolean doCheckLoginCaptcha() {
        return this.loginWebRule.getCaptchaContainer() != null && !TextUtils.isEmpty((CharSequence)this.loginWebRule.getCaptchaContainer().selector);
    }

    public String checkLoginError(Document document) {
        return this.doCheckLoginError() ? this.checkLoginErrorClass(document) : "";
    }

    protected String checkLoginErrorClass(Document document) {
        Log.i((String)"checkLoginErrorClass", (String)("failMessage : " + this.loginWebRule.getFailMessage()));
        Elements elements = document.select(this.loginWebRule.getFailMessage().selector);
        Log.i((String)"checkLogin", (String)("elements_size : " + elements.size()));
        if (elements.size() > 0) {
            return elements.first().text();
        }
        return "";
    }

    public boolean checkCaptchaImage(Document document) {
        return this.doCheckLoginCaptcha() && this.checkCaptchaClass(document);
    }

    protected boolean checkCaptchaClass(Document document) {
        Elements elements = document.select(this.loginWebRule.getCaptchaContainer().selector);
        return elements.size() != 0;
    }

    public boolean identifyLoginPageOrNot(String url) {
        return this.checkLoginPageOrNot(url);
    }

    protected boolean checkLoginPageOrNot(String url) {
        return url.contains("Login") || url.contains("login");
    }

    public boolean doParsingMall() {
        return this.mName.equalsIgnoreCase("Interpark");
    }

    public void setWebviewSettings(int action, WebView webView) {
        this.setUserAgentString(action, webView);
    }

    protected void setUserAgentString(int action, WebView webView) {
    }

    static interface OrderCallback<T> {
        public void onResult(T var1);

        public void onFail(int var1, String var2);
    }
}

