package com.tenqube.visual_scraper.scrap.mall;

import android.support.annotation.NonNull;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;


public class FactoryMall {

    public static Mall create(@NonNull String name, ScrapRepository repository, WebViewManager webViewManager) {

        switch (name) {

            case Constants.DEFAULT_MALL.Auction:
                return new Auction(Constants.DEFAULT_MALL.Auction, repository, webViewManager);

            case Constants.DEFAULT_MALL.Coupang:
                return new Coupang(Constants.DEFAULT_MALL.Coupang, repository, webViewManager);

            case Constants.DEFAULT_MALL.ElevenStreet:
                return new ElevenStreet(Constants.DEFAULT_MALL.ElevenStreet, repository, webViewManager);

            case Constants.DEFAULT_MALL.Gmarket:
                return new Gmarket(Constants.DEFAULT_MALL.Gmarket, repository, webViewManager);

            case Constants.DEFAULT_MALL.Gshome:
                return new Gshome(Constants.DEFAULT_MALL.Gshome, repository, webViewManager);

            case Constants.DEFAULT_MALL.Hmall:
                return new Hmall(Constants.DEFAULT_MALL.Hmall, repository, webViewManager);

            case Constants.DEFAULT_MALL.Interpark:
                return new Interpark(Constants.DEFAULT_MALL.Interpark, repository, webViewManager);

            case Constants.DEFAULT_MALL.LotteHome:
                return new LotteHome(Constants.DEFAULT_MALL.LotteHome, repository, webViewManager);

            case Constants.DEFAULT_MALL.NaverPay:
                return new Naver(Constants.DEFAULT_MALL.NaverPay, repository, webViewManager);

            case Constants.DEFAULT_MALL.Tmon:
                return new Tmon(Constants.DEFAULT_MALL.Tmon, repository, webViewManager);

            case Constants.DEFAULT_MALL.Wemake:
                return new Wemake(Constants.DEFAULT_MALL.Wemake, repository, webViewManager);

//
        }


        return null;

    }


}
