package com.tenqube.visual_scraper.repository;

import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;

import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.api.ScrapApiService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.ScraperDatabase;
import com.tenqube.visual_scraper.db.dao.LoginApiRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginWebRuleDao;
import com.tenqube.visual_scraper.db.dao.MallDao;
import com.tenqube.visual_scraper.db.dao.MallWithUserDao;
import com.tenqube.visual_scraper.db.dao.OrderApiRuleDao;
import com.tenqube.visual_scraper.db.dao.OrderDao;
import com.tenqube.visual_scraper.db.dao.OrderWebRuleDao;
import com.tenqube.visual_scraper.db.dao.RuleDao;
import com.tenqube.visual_scraper.db.dao.ScrapDao;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.dao.UserWithOrdersDao;
import com.tenqube.visual_scraper.db.entity.LoginRule;
import com.tenqube.visual_scraper.db.entity.MallWithUser;
import com.tenqube.visual_scraper.db.entity.newEntity.MallEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderApiRuleJson;
import com.tenqube.visual_scraper.db.entity.RuleEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderWebRuleJson;
import com.tenqube.visual_scraper.db.entity.newEntity.UserEntity;
import com.tenqube.visual_scraper.model.jsonParsing.MallScrapInfo;
import com.tenqube.visual_scraper.model.newApi.request.OrderBody;
import com.tenqube.visual_scraper.model.newApi.request.SaveOrdersBody;
import com.tenqube.visual_scraper.model.newApi.request.SignUpBody;
import com.tenqube.visual_scraper.model.newApi.response.ResultBody;
import com.tenqube.visual_scraper.model.newApi.response.ResultSignUp;
import com.tenqube.visual_scraper.model.view.OrderWebRule;
import com.tenqube.visual_scraper.utils.AppExecutors;


import java.util.ArrayList;
import java.util.List;

import retrofit2.Response;

public class ScrapRepository {

    private static ScrapRepository sInstance;

    private AppExecutors appExecutors;
    private final ScraperDatabase mDatabase;
    private final UserDao userDao;
    private final ScrapDao scrapDao;
    private final OrderDao orderDao;
    private final RuleDao ruleDao;
    private final UserWithOrdersDao userWithOrdersDao;
    private final MallWithUserDao mallWithUserDao;
    private final MallDao mallDao;
    private final LoginRuleDao loginRuleDao;

    private final LoginApiRuleDao loginApiRuleDao;
    private final LoginWebRuleDao loginWebRuleDao;
    private final OrderApiRuleDao orderApiRuleDao;
    private final OrderWebRuleDao orderWebRuleDao;

    private final ScrapApiService mApi;
    private SharedPreferences preferences;

    private ScrapRepository(final ScraperDatabase database,
                            final ScrapApiService scrapApi,
                            final AppExecutors appExecutors,
                            final SharedPreferences preferences) {

        // local
        mDatabase = database;
        userDao = database.userDao();
        scrapDao = database.scrapDao();
        orderDao = database.orderDao();
        ruleDao = database.ruleDao();
        userWithOrdersDao = database.userWithOrdersDao();
        mallWithUserDao = database.mallWithUserDao();
        mallDao = database.mallDao();
        loginRuleDao = database.loginRuleDao();
        loginApiRuleDao = database.loginApiRuleDao();
        loginWebRuleDao = database.loginWebRuleDao();
        orderApiRuleDao = database.orderApiRuleDao();
        orderWebRuleDao = database.orderWebRuleDao();
        this.preferences = preferences;

        // remote
        mApi = scrapApi;
        this.appExecutors = appExecutors;
    }

    public static ScrapRepository getInstance(final ScraperDatabase database, final ScrapApiService scrapApi, final AppExecutors appExecutors, final SharedPreferences preferences) {
        if (sInstance == null) {
            synchronized (ScrapRepository.class) {
                if (sInstance == null) {
                    sInstance = new ScrapRepository(database, scrapApi, appExecutors, preferences);
                }
            }
        }
        return sInstance;
    }

    public void saveKey(String apiKey) {
        if (TextUtils.isEmpty(apiKey)) apiKey = "sVPnrNW0Fg4fujRSLJrYn8FJWyO5BtS21hAbOYXc"; //TEST ***
        preferences.edit().putString(Constants.PREF_KEY.X_API_KEY, apiKey).apply();
    }

    public void saveLayer(String layer) {
        preferences.edit().putString(Constants.PREF_KEY.LAYER, layer).apply();
    }

    public void signUpUser(String appName, String uuid, ScrapService.Callback<Void> callback) {
        appExecutors.networkIO().execute(() -> {

            Response<ResultBody<ResultSignUp>> response;
            try {
                response = mApi.callSignUpUser(new SignUpBody(appName, uuid)).execute();

                if (response.isSuccessful()) {
                    Log.i("signUpUser","success : "+response.body());
                    preferences.edit().putString(Constants.PREF_KEY.UUID, uuid).apply();
                    ResultBody<ResultSignUp> result = response.body();
                    if (result != null) {
                        preferences.edit().putString(Constants.PREF_KEY.TOKEN, result.result.authorization.mall).apply();
                        appExecutors.mainThread().execute(() -> callback.onDataLoaded(null));
                    }

                } else {
                    Log.i("signUpUser","error :"+response.message());
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void syncRule(ScrapService.Callback<Void> callback) {

        appExecutors.networkIO().execute(() -> {

            try {
                Response<ResultBody<MallScrapInfo>> response = mApi.callGetRules().execute();

                if (response.isSuccessful()) {
                    Log.i("syncRule","success : "+response.body());

                    // json 파싱 후 저장
                    ResultBody<MallScrapInfo> results = response.body();

                    if (results != null) {
                        if (preferences.getInt(Constants.PREF_KEY.RULE_VERSION, -1) == results.result.getVersion()) callback.onDataLoaded(null);
                        ;

                        // Save new version data
                        preferences.edit().putInt(Constants.PREF_KEY.RULE_VERSION, results.result.getVersion()).apply();

                        mallDao.insertList(results.result.getMalls());
                        if (results.result.getLoginJsonRules() != null) loginApiRuleDao.insert(results.result.getLoginJsonRules());
                        loginWebRuleDao.insertList(results.result.getLoginHtmlRules());
                        orderApiRuleDao.insert(results.result.getOrderJsonRules());
                        orderWebRuleDao.insertList(results.result.getOrderHtmlRules());

                        Log.i("getJsonMallScraps", "getMalls : "+results.result.getMalls());
                        Log.i("getJsonMallScraps", "getLoginJsonRules : "+results.result.getLoginJsonRules());
                        Log.i("getJsonMallScraps", "getLoginHtmlRules : "+results.result.getLoginHtmlRules());
                        Log.i("getJsonMallScraps", "getOrderJsonRules : "+results.result.getOrderJsonRules());
                        Log.i("getJsonMallScraps", "getOrderHtmlRules : "+results.result.getOrderHtmlRules());
                    }

                } else {
                    Log.i("syncRule",""+response.message());
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
            appExecutors.mainThread().execute(()-> callback.onDataLoaded(null));
        });

    }


    public void callInsertOrderList(List<OrderEntity> orders) {

        appExecutors.networkIO().execute(() -> {

            List<OrderBody> results = new ArrayList<>();
            for (OrderEntity o: orders) {
                OrderBody orderBody = new OrderBody(o.mId,
                        o.title,
                        o.orderDate,
                        o.orderHms,
                        o.orderOption,
                        o.quantity,
                        o.price,
                        o.currency,
                        o.orderNum,
                        o.orderState,
                        o.imgUrl);

                results.add(orderBody);
                Log.i("saveOrderBody","info : "+orderBody);
            }

            try {
                Log.i("result","SaveOrdersBody : "+new SaveOrdersBody(results));
                Response<String> response = mApi.callSaveOrders(new SaveOrdersBody(results)).execute();
                if (response.isSuccessful()) {
                    String result = response.body();
                    Log.i("callInsertOrderList","result : "+result);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });

    }

    public void getOrderList(ScrapService.Callback<List<OrderEntity>> callback, int... mIds) {
        appExecutors.diskIO().execute(() -> {
            List<OrderEntity> list = orderDao.getOrders(mIds);
            appExecutors.mainThread().execute(() -> callback.onDataLoaded(list));
        });
    }

    public void getOrderList(ScrapService.Callback<List<OrderEntity>> callback, int mId) {
        appExecutors.diskIO().execute(() -> {
            List<OrderEntity> list = orderDao.getOrders(mId);
            appExecutors.mainThread().execute(() -> callback.onDataLoaded(list));
        });
    }


    public void getAllOrderList(ScrapService.Callback<List<OrderEntity>> callback) {
        appExecutors.diskIO().execute(() -> {
            List<OrderEntity> list = orderDao.getOrders();
            appExecutors.mainThread().execute(() -> callback.onDataLoaded(list));
        });

    }

    public void updateUserLastScrapAt(long lastScrapAt, int mallId, String userId){
        try {

            appExecutors.diskIO().execute(() -> userDao.updateUserLastScrapAt(lastScrapAt, mallId, userId));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateUserForSignOut(int mId, ScrapService.OnResultCallback<Void> callback) {
        try {

            appExecutors.diskIO().execute(() -> {
                long i = userDao.updateUserIsLogin(mId, false);
                Log.i("updateUserForSignOut","i : "+i);
                if (i > 0 ) {
                    callback.onDataLoaded(null);
                } else {
                    callback.onFail(mId, Constants.ERROR.LOGIN_OUT_FAIL, "logout fail");
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void insertOrders(List<OrderEntity> orderEntityList) {
        try {
            appExecutors.diskIO().execute(() -> orderDao.insertList(orderEntityList));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertUsers(UserEntity userEntity) {
        try {
            appExecutors.diskIO().execute(() -> {
                userDao.insert(userEntity);
                List<UserEntity> l = userDao.getUsers();
                Log.i("user", "info : "+ l);
                for (UserEntity u : l) {
                    Log.i("user", "info : "+ u);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteOrder(int orderId) {
        try {
            appExecutors.diskIO().execute(() -> orderDao.deleteOrder(orderId));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteOrder(int... orderIds) {
        try {
            appExecutors.diskIO().execute(() -> orderDao.deleteOrders(orderIds));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteForMallId(int mId) {
        try {
            appExecutors.diskIO().execute(() -> orderDao.deleteOrdersForMallId(mId));

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteForMallIds(int... mIds) {
        try {
            appExecutors.diskIO().execute(() -> orderDao.deleteOrderForMallIds(mIds));

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteAll() {
        try {
            appExecutors.diskIO().execute(() -> orderDao.deleteAll());

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//    public void getUser(String userId, String pwd, Constants.MALL mall, ScrapService.Callback<UserEntity> callback) {
//
//        Runnable runnable = () -> {
//
//            UserEntity userEntity = null;
//            try {
//                userEntity = userDao.getUser(userId, pwd, mall.name());
//
//                if(userEntity == null) {
//                    userEntity = new UserEntity(0, mall.name(), userId, pwd, "");
//                    userEntity.setId((int) userDao.insertList(userEntity));
//                }
//            } catch (Exception e) {
//                e.printStackTrace();
//            } finally {
//                UserEntity finalUserEntity = userEntity;
//                appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalUserEntity));
//            }
//        };
//
//        appExecutors.diskIO().execute(runnable);
//
//    }

//    public void getUser(Constants.MALL mall, ScrapService.Callback<UserEntity> callback) {
//
//        Runnable runnable = () -> {
//
//            UserEntity userEntity = null;
//            try {
//                userEntity = userDao.getUser(mall.name());
//            } catch (Exception e) {
//                e.printStackTrace();
//            } finally {
//                UserEntity finalUserEntity = userEntity;
//                appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalUserEntity));
//            }
//        };
//
//        appExecutors.diskIO().execute(runnable);
//
//    }

//    public void deleteUser(Constants.MALL mall) {
//        Runnable runnable = () -> {
//            try {
//                userDao.deleteUser(mall.name());
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//        };
//
//        appExecutors.diskIO().execute(runnable);
//    }
//
//    public void deleteUser(UserEntity userEntity) {
//        Runnable runnable = () -> {
//            try {
//                userDao.deleteUser(userEntity.getId());
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//        };
//
//        appExecutors.diskIO().execute(runnable);
//    }

    public void checkIsActiveMall(int mId, ScrapService.Callback<MallEntity> callback) {
        Runnable runnable = () -> {
            MallEntity mallEntity = mallDao.getMall(mId);
            callback.onDataLoaded(mallEntity);
        };
        appExecutors.diskIO().execute(runnable);
    }

    public void getMallWithUser(int mId, String uId, ScrapService.onResultInterface<MallWithUser> callback) {
        appExecutors.diskIO().execute(() -> {
            try {
                MallWithUser mallWithUser = mallWithUserDao.getInfo(mId, uId);
                Log.i("getMallWithUser","info : "+mallWithUser);
                if (mallWithUser != null) {
                    callback.onDataLoaded(mallWithUser);
                } else {
                    callback.onFail();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });

    }

    public void getMallWithUser(ScrapService.Callback<List<MallWithUser>> callback) {

        appExecutors.diskIO().execute(() -> {
            try {
                List<MallWithUser> list = mallWithUserDao.getInfoForActiveMall();
//                List<UserEntity> l = userDao.getUsers();
//                Log.i("user", "info : "+ l);
//                for (UserEntity u : l) {
//                    Log.i("user", "info : "+ u);
//                }
                appExecutors.mainThread().execute(() -> {
                    callback.onDataLoaded(list);
                });

            } catch (Exception e) {
                e.printStackTrace();
            }
        });

    }

    public void getMallWithActiveUser(ScrapService.Callback<List<MallWithUser>> callback) {

        appExecutors.diskIO().execute(() -> {
            try {
                List<MallWithUser> list = mallWithUserDao.getInfoForActiveUser();
                Log.i("getMallWithActiveUser", "info : "+ list);
                for (MallWithUser u : list) {
                    Log.i("getMallWithActiveUser", "info : "+ u);
                }
                appExecutors.mainThread().execute(() -> {
                    callback.onDataLoaded(list);
                });

            } catch (Exception e) {
                e.printStackTrace();
            }
        });

    }


    public void getLoginRule(int mId, ScrapService.Callback<LoginRule> callback) {
        appExecutors.diskIO().execute(() -> {
            LoginRule loginRule = loginRuleDao.getInfo(mId);
            Log.i("login","loginRule : "+loginRule);
            appExecutors.mainThread().execute(() -> callback.onDataLoaded(loginRule));
        });
    }



    public void getOrderWebRule(int mId, ScrapService.Callback<OrderWebRule> callback) {
        appExecutors.diskIO().execute(() -> {
            OrderWebRuleJson orderWebRuleJson = orderWebRuleDao.getInfo(mId);
            callback.onDataLoaded(new OrderWebRule(orderWebRuleJson));
        });
    }

    public void getOrderApiRule(int mId, ScrapService.Callback<OrderApiRuleJson> callback) {
        appExecutors.diskIO().execute(() -> {
            OrderApiRuleJson orderApiRuleJson = orderApiRuleDao.getInfo(mId);
            callback.onDataLoaded(orderApiRuleJson);

        });
    }


//    public void geScrapRule(Constants.MALL mall, ScrapService.Callback<ScrapEntity> callback) {
//
//        Runnable runnable = () -> {
//            Log.i("geScrapRule","mall name : "+mall.name());
//            List<ScrapEntity> es = scrapDao.getScraps();
//            for (ScrapEntity a :es){
//                Log.i("aaaa","a : "+a);
//            }
//            ScrapEntity scrapEntity = null;
//            try {
//                scrapEntity = scrapDao.getScrap(mall.name());
//            } catch (Exception e) {
//                e.printStackTrace();
//            } finally {
//                ScrapEntity finalScrapEntity = scrapEntity;
//                Log.i("geScrapRule","result_info : "+finalScrapEntity);
//                appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalScrapEntity));
//            }
//        };
//
//        appExecutors.diskIO().execute(runnable);
//
//    }

//    public void requestMallParsing(int uid, RequestDocumentData html, ScrapService.Callback<Void> callback) {
//
//        Runnable runnable = () -> {
//
//            Response<Orders> response;
//            try {
//                response = mApi.callPurchaseParser(html).execute();
//
//                if(response.isSuccessful()) {
//
//                    Orders result = response.body();
//                    if(result != null) {
//
//                        for(Order order : result.getOrders()) {
//                            orderDao.insertList(order.toEntity(uid));
//                        }
//                    }
//                }
//
//            } catch (Exception e) {
//                e.printStackTrace();
//            } finally {
//                appExecutors.mainThread().execute(() -> callback.onDataLoaded(null));
//
//            }
//        };
//        appExecutors.networkIO().execute(runnable);

//    }

//    public void getAllOrders(ScrapService.Callback<List<OrderEntity>> callback) {
//        Runnable runnable = () -> {
//
//            List<OrderEntity> orderEntities = new ArrayList<>();
//            List<UserEntity> userEntities = new ArrayList<>();
//            List<ScrapEntity> scrapEntities = new ArrayList<>();
//            try {
//                orderEntities = orderDao.getOrders();
//                userEntities = userDao.getUsers();
//                scrapEntities = scrapDao.getScraps();
//
//                for(OrderEntity order : orderEntities) {
//                    for(UserEntity user : userEntities) {
//                        if(order.getuId() == user.getId()) {
//                            order.setUserEntity(user);
//                            for(ScrapEntity scrap : scrapEntities) {
//                                if(user.getMallName().equals(scrap.getName())) {
//                                    Log.i("getAllOrders",""+scrap);
//                                    order.setScrapEntity(scrap);
//                                    break;
//                                }
//                            }
//                        }
//                    }
//                }
//            } catch (Exception e) {
//                e.printStackTrace();
//            } finally {
//                List<OrderEntity> finalOrderEntities = orderEntities;
//                appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalOrderEntities));
//            }
//        };
//
//        appExecutors.diskIO().execute(runnable);
//    }
//
//

//    /**
//     * 파싱된 정보 저장
//     * TODO 파이어베이스 데이터 로드 추가
//     */
//    public void insertOrders(UserEntity userEntity, ScrapEntity scrapEntity,  List<Order> orders, ScrapService.Callback<Void> callback) {
//        Runnable runnable = () -> {
//            try {
//
//                for(Order order : orders) {
//                    orderDao.insertList(order.toEntity(userEntity.getId()));
//                }
//
//            } catch (Exception e) {
//                e.printStackTrace();
//            } finally {
//                appExecutors.mainThread().execute(() -> callback.onDataLoaded(null));
//            }
//        };
//
//        appExecutors.diskIO().execute(runnable);
//    }

    public void getRule(Constants.MALL mall, ScrapService.Callback<RuleEntity> callback) {
        Runnable runnable = () -> {
            RuleEntity rule = null;
            try {
                rule = ruleDao.getRule(mall.name());

            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                RuleEntity finalRule = rule;
                Log.i("getRule","info : "+ finalRule);
                appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalRule));
            }
        };

        appExecutors.diskIO().execute(runnable);
    }


//    public void getMalls(ScrapService.Callback<List<Mall_temp>> callback) {
//        Runnable runnable = () -> {
//            List<Mall_temp> malls = new ArrayList<>();
//            try {
//                List<ScrapEntity> scrapEntities = scrapDao.getScraps();
//                List<UserEntity> userEntities = userDao.getUsers();
//
//                for(ScrapEntity entity : scrapEntities) {
//                    Mall_temp mall = entity.toMall();
//                    for(UserEntity userEntity : userEntities) {
//                        if(entity.getName().equals(userEntity.getMallId())) {
//                            mall.setSignIn(true);
//                            break;
//                        }
//                    }
//                    malls.add(mall);
//                }
//            } catch (Exception e) {
//                e.printStackTrace();
//            } finally {
//                appExecutors.mainThread().execute(() -> callback.onDataLoaded(malls));
//            }
//        };
//
//        appExecutors.diskIO().execute(runnable);
//    }
}
