/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.model;

import android.support.annotation.Nullable;
import com.tenqube.visual_scraper.db.entity.ScrapEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.UserEntity;
import com.tenqube.visual_scraper.utils.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ParsingRuleData
implements Serializable {
    private final ScrapEntity scrap;
    private final UserEntity user;
    private String purchaseUrl;
    private String webViewScriptCode;
    @Nullable
    private Map<String, String> loginParams;
    @Nullable
    private Map<String, String> purchaseParams;

    public ParsingRuleData(ScrapEntity scrap, UserEntity userEntity) {
        this.scrap = scrap;
        this.user = userEntity;
        this.setExceptScriptCode(this.user.getUserId(), this.user.getUserPwd());
        this.purchaseUrl = Validator.replaceDateParams(scrap.getPurchaseUrl(), String.valueOf(this.user.getLastScrapAt()));
        if (scrap.getPurchaseParams() != null && !scrap.getPurchaseParams().isEmpty()) {
            this.purchaseParams = Validator.convertMapToString(scrap.getPurchaseParams());
            for (String key : this.purchaseParams.keySet()) {
                if (!this.purchaseParams.get(key).startsWith("dynamicDate")) continue;
                String value = this.purchaseParams.get(key);
                this.purchaseParams.put(key, Validator.replaceDateParams(value, String.valueOf(this.user.getLastScrapAt())));
            }
        }
        if (scrap.getLoginParams() != null && !scrap.getLoginParams().isEmpty()) {
            this.loginParams = Validator.convertMapToString(scrap.getLoginParams());
            for (String key : this.loginParams.keySet()) {
                if (this.loginParams.get(key).contains("dynamicID")) {
                    this.loginParams.put(key, this.user.getUserId());
                    continue;
                }
                if (!this.loginParams.get(key).contains("dynamicPW")) continue;
                this.loginParams.put(key, this.user.getUserPwd());
            }
        }
    }

    private void setExceptScriptCode(String userId, String userPw) {
        if (this.scrap.getIsWebviewLogin() == 1 && this.scrap.getScriptCodes() != null) {
            this.webViewScriptCode = String.format(this.scrap.getScriptCodes(), userId, userPw);
            if (this.scrap.getScriptCodes() == null || !this.scrap.getScriptCodes().isEmpty()) {
                // empty if block
            }
        }
    }

    public ScrapEntity getScrap() {
        return this.scrap;
    }

    public String getId() {
        return this.user.getUserId();
    }

    public String getPw() {
        return this.user.getUserPwd();
    }

    public String getPurchaseUrl() {
        return this.purchaseUrl;
    }

    public String getWebViewScriptCode() {
        return this.webViewScriptCode;
    }

    @Nullable
    public Map<String, String> getLoginParams() {
        return this.loginParams;
    }

    @Nullable
    public Map<String, String> getPurchaseParams() {
        return this.purchaseParams == null ? new HashMap() : this.purchaseParams;
    }
}

