package com.tenqube.visual_scraper;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.MallWithUser;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.UserEntity;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.FactoryMall;

import java.util.List;

public class ScrapServiceImpl implements ScrapService {

    private final Context context;
    private final String apiKey;
    private final String qualifier;
    ScrapRepository repository;
    private SharedPreferences preferences;
    private WebViewManager webViewManager;

    private boolean isDoing;
    private String uuid;
    private String serviceAppName;

    public ScrapServiceImpl(@NonNull Context context, @NonNull String apiKey, @NonNull String qualifier,/* @Nullable MallApiService api,*/
                            @NonNull String uuid, @NonNull String serviceAppName) throws ParameterException
    {
        this.context = context;
        this.apiKey = apiKey;
        this.qualifier = qualifier;
        preferences = Injection.provideSharedPreference(context);
        repository = Injection.provideScrapRepository(context.getApplicationContext(), preferences);
        repository.saveKey(apiKey);
        repository.saveLayer(qualifier);
        webViewManager = new WebViewManager(context/*, webView*/);
        this.uuid = uuid;
        this.serviceAppName = serviceAppName;

//        init(serviceAppName);
    }

    private void init(String serviceAppName) {
        // uuid 등록
        if (!preferences.getString(Constants.PREF_KEY.UUID, "").equals(uuid)) {
            Log.i("UUID","uuid 저장 및 사용자 등록");
            repository.signUpUser(serviceAppName, uuid, (Void) -> {
                //success get token
                // 룰 동기화
                repository.syncRule((callback) -> {
                    // 동기화 완료

                });
            });

        }
    }

    @Override
    public WebView getWebView() {
        return webViewManager.getWebView();
    }

    @Override
    public void startLoginAndParsing(String userId, String userPwd, int mId, OnResultCallback<List<OrderEntity>> onResult) throws ParameterException {
        if (TextUtils.isEmpty(userId) || TextUtils.isEmpty(userPwd) || mId == 0) throw new ParameterException("empty parameter");

        if (!preferences.getString(Constants.PREF_KEY.UUID, "").equals(uuid)) {
            repository.signUpUser(serviceAppName, uuid, (Void) -> {
                logInAndParsing(userId, userPwd, mId, onResult);
            });
        } else {
            logInAndParsing(userId, userPwd, mId, onResult);
        }
    }


//    @Override
    private void logInAndParsing(String userId, String userPwd, int mId, OnResultCallback<List<OrderEntity>> onResult) {

        // sdk 활성화 여부 체크
        if(isDoing | isEnabledSDK()) {
            return;
        }

        // 룰 동기화
        repository.syncRule((callback) -> {
            // 동기화 완료
            Log.i("logInAndParsing", "syncRule success");

            start(userId, userPwd, mId, new OnResult<List<OrderEntity>>() {
                @Override
                public void onSuccess(int mId, List<OrderEntity> itemList, String msg) {
                    Log.i("logInAndParsing", "parse success "+ mId + msg + itemList);

                    // itemList 바로 리턴 가능
                    // But, 중복 체크 (DB 에서 unique key 로?)

                    // 해당 몰Id data 조회해보고 리턴
                    repository.getOrderList(items -> {
                        Log.i("logInAndParsing", "size" + items.size());

                        onResult.onDataLoaded(items);

                    }, mId);
                }

                @Override
                public void onFail(int mId, Constants.ERROR error, String msg) {
                    Log.i("logInAndParsing", "error" + error.name() + "onFail" + msg);
                    onResult.onFail(mId, error, msg);
                }
            });
        });
    }


    //onResult -> 따로.. -> 받아서 lastScrapDate 동기화
//    @Override
    public void start(String userId, String userPwd, int mId, OnResult callback) {

        // 몰 활성화 여부 조회
        repository.checkIsActiveMall(mId, (mall) -> {
            // mall Active 하지 않거나, 해당 몰정보 없음
            if (mall == null) return;

            // 유저 (& 몰정보) 가져오기
            repository.getMallWithUser(mId, userId, new onResultInterface<MallWithUser>() {
                @Override
                public void onDataLoaded(MallWithUser item) {
                    // 유저 정보 존재 -> 로그인 성공시 비번 다를경우, 업데이트
                    // login
                    Log.i("getMallWithUser","item : "+item);
                    login(item, Constants.CRUD.UPDATE, callback);
                }

                @Override
                public void onFail() {
                    // 유저 및 몰정보 없음 -> 해당 mall 의 신규 user id 등록
                    Log.i("getMallWithUser","mId : "+mId);
                    login(new MallWithUser(mall, new UserEntity(mId, userId, userPwd)), Constants.CRUD.INSERT, callback);
                }
            });
        });
    }

    private void login(MallWithUser mallWithUser, int crud, OnResult onResult) {
        Log.i("login","MallWithUser : "+mallWithUser);
        // login rule 가져오기
        repository.getLoginRule(mallWithUser.mall.getId(), (loginRule) -> {
            Log.i("login","loginRule : "+loginRule);

            com.tenqube.visual_scraper.scrap.mall.Mall m = FactoryMall.create(mallWithUser.mall.getDisplayName(), repository, webViewManager);
            Log.i("login","Mall : "+m);
            if (m == null) return;

//            isDoing = true;
            /*if (loginRule != null && loginRule.loginApiRule != null) {
                // api login
                m.startApiLogin(loginRule, mallWithUser.user, crud, onResult);

            } else*/ if (loginRule != null && loginRule.loginWebRule != null) {
                // web login
                m.startWebViewLogin(loginRule.loginWebRule, mallWithUser.user, crud, onResult);

            } else {
                // login rule 정보 없음
                onResult.onFail(mallWithUser.mall.getId(), Constants.ERROR.NOT_FOUND_LOGIN_RULE, mallWithUser.mall.getDisplayName() +" login rule does not exist");
            }
        });
    }


    @Override
    public void startParsingMalls(OnResultCallback<List<OrderEntity>> onResult) {
        if (!preferences.getString(Constants.PREF_KEY.UUID, "").equals(uuid)) {
            repository.signUpUser(serviceAppName, uuid, (Void) -> {
                getMallsAndParsing(onResult);
            });
        } else {
            getMallsAndParsing(onResult);
        }
    }

    private void getMallsAndParsing(OnResultCallback<List<OrderEntity>> onResult) {

        // 몰 & 유저정보 가져오기
        repository.getMallWithUser((items -> {
            Log.i("getMallsAndParsing","item : "+items);
            for (MallWithUser mallWithUser : items) {

                login(mallWithUser, 0, new OnResult<List<OrderEntity>>() {
                    @Override
                    public void onSuccess(int mId, List<OrderEntity> itemList, String msg) {
                        Log.i("onSuccess", "name : "+mId + "size : "+itemList);

                        // 해당 몰Id data 조회해보고 리턴
                        repository.getOrderList(items -> {
                            Log.i("DB", "size : " + items.size());

                            onResult.onDataLoaded(items);

                        }, mId);
                    }

                    @Override
                    public void onFail(int mId, Constants.ERROR error, String msg) {

                    }
                });
            }
        }));

    }

    @Override
    public void setEnabled(boolean enabled) {
        preferences.edit().putBoolean(Constants.PREF_KEY.SDK_IS_ENABLE, enabled).apply();
    }

    private boolean isEnabledSDK() {
        return preferences.getBoolean(Constants.PREF_KEY.SDK_IS_ENABLE, false);
    }

    @Override
    public void getAllProducts(OnResultCallback<List<OrderEntity>> callback) {
        repository.getAllOrderList((callback::onDataLoaded));
    }

    @Override
    public void getMallWithUsers(Callback<List<MallWithUser>> callback) {
        repository.getMallWithUser(callback::onDataLoaded);
    }


    @Override
    public void signOut(int mId, OnResultCallback<Void> callback) {
        repository.updateUserForSignOut(mId, callback);
    }

    @Override
    public void deleteOrder(int orderId) {
        repository.deleteOrder(orderId);
    }

    @Override
    public void deleteOrders(int... orderIds) {
        repository.deleteOrder(orderIds);
    }

    @Override
    public void deleteAll(int... mIds) {
        if (mIds != null) {
            repository.deleteForMallIds();
        } else {
            // 전체 삭제
            repository.deleteAll();
        }
    }

    @Override
    public void deleteForMallId(int mid) {
        repository.deleteForMallId(mid);
    }

    @Override
    public void insertUserEntity(UserEntity userEntity) {
        repository.insertUsers(userEntity);
    }


    //
//    @Override
//    public void getMalls(Callback<List<Mall_temp>> callback) {
//        if (isEnabledSDK()) return;
//
//
//    }
//
//    @Override
//    public void getOrders(Callback<List<OrderEntity>> callback, int... mIds) {
//        if (isEnabledSDK()) return;
//
//        // uuid 로 조회
//
//
//        // 파싱 & 저장
////        startParsingMalls();
//
//        // 몰리스트 조회
//
//    }
//
//    @Override
//    public void deleteAll(int... mIds) {
//
//    }
//
//    @Override
//    public void exportCSV(Callback<File> callback, int... mIds) {
//
//    }

//
//    @Override
//    public void deleteOrder(int orderId) {
//
//    }
//
//
//    @Override
//    public void updateOrder(OrderEntity order) {
//
//    }


//    @Override
//    public void getProducts(Callback<List<OrderEntity>> callback, Constants.MALL... malls) {
//
//    }
//
//    @Override
//    public void exportCSV() {
//
//    }

    //    /**
//     * 이미 저장된 사용자 정보를 통해 로그인 처리
//     * @param mall 몰정보
//     * @param onResult
//     */
//    @Override
//    public void startParsingMalls(Constants.MALL mall, OnResult onResult) {
//        if(isDoing)
//            return;
//
//            repository.getUser(mall, user -> {
//
//                if(user == null) {
//                    onResult.onFail(mall, LOGIN_FAIL, "사용자 없음 ");
//                    return;
//                }
//
//                com.tenqube.visual_scraper.scrap.mall.Mall_temp m = FactoryMall.create(mall, repository);
//                if(m != null) {
//                    isDoing = true;
//                    m.startParsingMalls(context, user, onResult);
//                } else {
//                    onResult.onFail(mall, Constants.ERROR.NOT_FOUND_MALL, "몰 없음 ");
//                }
//        });
//    }

//    @Override
//    public void signOut(Constants.MALL mall) {
//        repository.deleteUser(mall);
//    }
//
//    @Override
//    public void getMalls(Callback<List<Mall_temp>> callback) {
//        repository.getMalls(callback);
//    }
//
//    @Override
//    public void getAllProducts(Callback<List<OrderEntity>> callback) {
//        repository.getAllOrders(callback);
//    }
//
//    @Override
//    public void getProducts(Callback<List<OrderEntity>> callback, Constants.MALL... malls) {
//
//    }
//
//    @Override
//    public void exportCSV() throws SecurityException {
//        String[] perms = {Manifest.permission.WRITE_EXTERNAL_STORAGE};
//
//        if (Utils.hasPermissions(context, perms)) {
//
//            repository.getAllOrders(CSVHelper::export);
//
//        } else {
//            throw new SecurityException();
//        }
//
//    }
}
