package com.tenqube.visual_scraper.model;

import android.support.annotation.Nullable;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.ScrapEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.UserEntity;
import com.tenqube.visual_scraper.utils.Validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by tenqube on 2018. 5. 18..
 */

public class ParsingRuleData implements Serializable {

    private final ScrapEntity scrap;

    private final UserEntity user;

    private String purchaseUrl;
    private String webViewScriptCode;

    public ParsingRuleData(ScrapEntity scrap, UserEntity userEntity) {
        this.scrap = scrap;
        this.user = userEntity;

        setExceptScriptCode(user.getUserId(), user.getUserPwd());

//        validCookieKey = new ArrayList<>(Arrays.asList(scrap.getValidCookieKeys().split(";")));
        purchaseUrl = Validator.replaceDateParams(scrap.getPurchaseUrl(), String.valueOf(user.getLastScrapAt()));

//        "shDateFrom": "dynamicDate:yyyyMMdd;start;year:dynamicEnd",
//                "shDateTo": "dynamicDate:yyyyMMdd;end;today:dynamicEnd",

        //order
        if (scrap.getPurchaseParams() != null && !scrap.getPurchaseParams().isEmpty()) {
            purchaseParams = Validator.convertMapToString(scrap.getPurchaseParams());
            for (String key : purchaseParams.keySet()) {
                if (purchaseParams.get(key).startsWith(Constants.DYNAMIC_KEY.DYNAMIC_DATE)) {
                    String value = purchaseParams.get(key);
                    purchaseParams.put(key, Validator.replaceDateParams(value, String.valueOf(user.getLastScrapAt())));
                }
            }
        }


        if (scrap.getLoginParams()!=null && !scrap.getLoginParams().isEmpty()) {
            loginParams = Validator.convertMapToString(scrap.getLoginParams());

            for (String key : loginParams.keySet()) {
                if (loginParams.get(key).contains(Constants.DYNAMIC_KEY.DYNAMIC_USER_ID_KEY)) {
                    loginParams.put(key, user.getUserId());
                } else if (loginParams.get(key).contains(Constants.DYNAMIC_KEY.DYNAMIC_USER_PW_KEY)) {
                    loginParams.put(key, user.getUserPwd());
                }
            }
        }


    }

    private void setExceptScriptCode(String userId, String userPw) {
        //webView 로그인 일 경우
        if (scrap.getIsWebviewLogin() == 1 && scrap.getScriptCodes() != null) {
            webViewScriptCode = String.format(scrap.getScriptCodes(), userId, userPw);
            if (scrap.getScriptCodes()!=null && !scrap.getScriptCodes().isEmpty()) {
//                exceptScriptCode = new ArrayList<>();
//                exceptScriptCode.add(scrap.getScriptCodes());
            }
        }
    }

//    @Nullable
//    private ArrayList<String> validCookieKey;

    @Nullable
    private Map<String, String> loginParams;

//    @Nullable
//    private ArrayList<String> exceptScriptCode;

    //purchase
    @Nullable
    private Map<String, String> purchaseParams;


    public ScrapEntity getScrap() {
        return scrap;
    }

    public String getId() {
        return user.getUserId();
    }

    public String getPw() {
        return user.getUserPwd();
    }

//    public String getLastSyncDate() {
//        return user.getLastScrapAt();
//    }

    public String getPurchaseUrl() {
        return purchaseUrl;
    }

    public String getWebViewScriptCode() {
        return webViewScriptCode;
    }

//    @Nullable
//    public ArrayList<String> getValidCookieKey() {
//        return validCookieKey;
//    }

    @Nullable
    public Map<String, String> getLoginParams() {
        return loginParams;
    }

//    @Nullable
//    public ArrayList<String> getExceptScriptCode() {
//        return exceptScriptCode;
//    }

    @Nullable
    public Map<String, String> getPurchaseParams() {
        return purchaseParams == null ? new HashMap<>() : purchaseParams;
    }
}
