/*
 * Copyright 2016, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tenqube.visual_scraper.db.entity.newEntity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;

import static android.arch.persistence.room.ForeignKey.CASCADE;

@Entity(tableName = "users", indices = {@Index(value = {"mall_id", "user_id", "pwd"}, unique = true)}
        /*foreignKeys =  {
                @ForeignKey(entity = MallEntity.class,
                        parentColumns = "m_id",
                        childColumns = "mall_id",
                        onDelete = CASCADE)}*/)
public final class UserEntity {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "u_id")
    private int id;

    @NonNull
    @ColumnInfo(name = "mall_id")
    private final int mId;

    @NonNull
    @ColumnInfo(name = "user_id")
    private final String userId;

    @NonNull
    @ColumnInfo(name = "pwd")
    private final String userPwd;

    @ColumnInfo(name = "cookie")
    private String cookie;

    @ColumnInfo(name = "is_login")
    private boolean isLogin;

    @ColumnInfo(name = "is_progress")
    private boolean isProgress;

    @ColumnInfo(name = "last_scrap_at")
    private long lastScrapAt; //마지막 스크랩한 날짜

//    @Ignore
//    public UserEntity(int id, @NonNull int mId, @NonNull String userId, @NonNull String userPwd,
//                      @NonNull String cookie, boolean isLogin, boolean isProgress, @NonNull long lastScrapAt) {
//        this.id = id;
//        this.mId = mId;
//        this.userId = userId;
//        this.userPwd = userPwd;
//        this.cookie = cookie;
//        this.isLogin = isLogin;
//        this.isProgress = isProgress;
//        this.lastScrapAt = lastScrapAt;
//    }

    public UserEntity(int mId, @NonNull String userId, @NonNull String userPwd) {
        this.mId = mId;
        this.userId = userId;
        this.userPwd = userPwd;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @NonNull
    public int getmId() {
        return mId;
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    @NonNull
    public String getUserPwd() {
        return userPwd;
    }

    public String getCookie() {
        return cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public boolean isLogin() {
        return isLogin;
    }

    public void setLogin(boolean login) {
        isLogin = login;
    }

    public boolean isProgress() {
        return isProgress;
    }

    public void setProgress(boolean progress) {
        isProgress = progress;
    }

    public long getLastScrapAt() {
        return lastScrapAt;
    }

    public void setLastScrapAt(long lastScrapAt) {
        this.lastScrapAt = lastScrapAt;
    }

    @Override
    public String toString() {
        return "UserEntity{" +
                "id=" + id +
                ", mId=" + mId +
                ", userId='" + userId + '\'' +
                ", userPwd='" + userPwd + '\'' +
                ", cookie='" + cookie + '\'' +
                ", isLogin=" + isLogin +
                ", isProgress=" + isProgress +
                ", lastScrapAt=" + lastScrapAt +
                '}';
    }
}
