package com.tenqube.visual_scraper.constants;

/**
 * Created by tenqube on 2018. 4. 9..
 */

public class Constants {

    public static final String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36";

    public enum DateFormatType {
        SLASH,
        DASH,
        DOT,
        NONE
    }

    public static final class DEFAULT_MALL {
        public static final String Auction = "Auction";
        public static final String Coupang = "Coupang";
        public static final String ElevenStreet = "ElevenStreet";
        public static final String Gmarket = "Gmarket";
        public static final String Gshome = "Gshome";
        public static final String Hmall = "Hmall";
        public static final String Interpark = "Interpark";
        public static final String LotteHome = "LotteHome";
        public static final String NaverPay = "NaverPay";
        public static final String Tmon = "Tmon";
        public static final String Wemake = "Wemake";
    }

    public enum MALL {
        Auction,
        Coupang,
        ElevenStreet,
        Gmarket,
        Gshome,
        Hmall,
        Interpark,
        LotteHome,
        NaverPay,
        Tmon,
        Wemake,
    }

    public enum ERROR {
        REQUEST_FREQUENT,
        LOGIN_FAIL,
        LOGIN_OUT_FAIL,
        NETWORK,
        PARSING,
        NOT_FOUND_MALL,
        NOT_FOUND_RULE,
        NOT_FOUND_LOGIN_RULE,
        PARSING_FAIL
    }

    public static final class PERMISSION {
        public static final int STORAGE = 0;
    }

    public static final class PREF_KEY {
        public static final String X_API_KEY = "x-api-key";
        public static final String LAYER = "layer";
        public static final String RULE_VERSION = "version";

        public static final String UUID = "uuid";
        public static final String SDK_IS_ENABLE = "SDK_IS_ENABLE";

        public static final String TOKEN = "token";

        public static final String CHECK_PARSING_TIME = "CHECK_PARSING_TIME";
        public static final String PARSING_FREQUENCY = "PARSING_FREQUENCY";

    }

    public static final class CRUD {
        public static final int INSERT = 1;
        public static final int UPDATE = 2;
    }

    public static final class LAYER {
        public static final String PROD = "prod";
        public static final String DEV = "dev";
    }

    public static final class API {
        public static final String X_API_KEY = "x-api-key";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String AUTHORIZATION = "Authorization";

    }

    public static class SCRAP_TYPE {

        public static final int PURCHASE = 0;
        public static final int DETAIL_PURCHASE = 1;
        public static final int PRODUCT = 2;
    }

    public static class METHOD_TYPE{
        public static final int GET = 0;
        public static final int POST = 1;
    }
    public static class CONTENT_TYPE{
        public static final int URL_ENCODED = 0;
        public static final int JSON = 1;
        public static final String JSON_KEY= "application/json";
    }
    public static class DYNAMIC_KEY {
        public static final String DYNAMIC_DATE = "dynamicDate";
        public static final String DYNAMIC_END = "dynamicEnd";
        public static final String DYNAMIC_USER_ID_KEY = "dynamicID";
        public static final String DYNAMIC_USER_PW_KEY = "dynamicPW";
        public static final String DYNAMIC_ORDER_NUM_KEY = "dynamicOrderNum";
    }



    public static class MESSAGES{
        public static final String NO_DATA = "no data";
        public static final String INVALID_USER_INFO = "Invalid User Info";
        public static final String PARSING_SUCCESS = "Parsing Success";
        public static final String TIMEOUT_FAIL = "Timeout Fail";
        public static final String PARSING_FAIL = "Parsing FAIL";
        public static final String LOGIN_SUCCESS = "Success LoginPage";
        public static final String PURCHASE_START = "Start scraping Purchase";
        public static final String PURCHASE_END = "done";
        public static final String INVALID_EMAIL_FORMAT = "Invalid Email format";
    }
    public static class STATUSCODE{
        public static final int SUCCESS_CODE =200;
        public static final int FAIL_CODE = 400;
        public static final int INVALID_USER_CODE = 404;

    }
}
