package com.tenqube.visual_scraper.api;

import com.tenqube.visual_scraper.model.jsonParsing.MallScrapInfo;
import com.tenqube.visual_scraper.model.newApi.request.SaveOrdersBody;
import com.tenqube.visual_scraper.model.newApi.request.SignUpBody;
import com.tenqube.visual_scraper.model.newApi.response.ResultBody;
import com.tenqube.visual_scraper.model.newApi.response.ResultRuleVersion;
import com.tenqube.visual_scraper.model.newApi.response.ResultSignUp;


import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;

/**
 * Created by tenqube on 2018. 6. 14..
 */

public interface ScrapApiService {

    String BASE_URL = "https://lmfur57mca.execute-api.ap-northeast-2.amazonaws.com/%s/";//dev/";


    @POST("sign-up")
    Call<ResultBody<ResultSignUp>> callSignUpUser(@Body SignUpBody signUpBody);


    @GET("rules")
    Call<ResultBody<MallScrapInfo>> callGetRules();


    @POST("orders")
    Call<String> callSaveOrders(@Body SaveOrdersBody orders);


    @GET("rules/version")
    Call<ResultRuleVersion> callGetRuleVersion();



//    /**
//     *
//     * @param requestDocumentData 상세페이지 데이터
//     * @return OrderData
//     */
//    @POST("detail-parser")
//    ScrapCallAdapter.MyCall<Order> callDetailParser(@Body RequestDocumentData requestDocumentData);
//
//    /******************************************* SCRAPING ********************************************************/
//    @POST("orders")
//    ScrapCallAdapter.MyCall<Void> callOrders(@Body RequestOrders requestOrders);

}
