package com.tenqube.visual_scraper.scrap.mall;


import android.support.annotation.NonNull;
import android.util.Log;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.repository.ScrapRepository;

import org.jsoup.nodes.Element;

public class Auction extends Mall {

    public Auction(String mallName, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallName, repository, webViewManager);
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        return orderNum.replace("주문번호", "").trim();
    }

    @Override
    protected String imgUrlFilter(@NonNull String imgUrl) {
        StringBuilder result = new StringBuilder(imgUrl);
        int pos = result.lastIndexOf(".jpg");
        if (pos != -1) {
            result.setCharAt(pos-1, '5');
        }
        Log.i("imgUrlFilter","result : "+ result.toString());
        return result.toString();
    }
}
