/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.vo;

import android.support.annotation.Nullable;
import com.tenqube.visual_scraper.db.entity.ScrapEntity;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.utils.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ParsingRuleData
implements Serializable {
    private final ScrapEntity scrap;
    private final UserEntity user;
    private String purchaseUrl;
    private String webViewScriptCode;
    @Nullable
    private ArrayList<String> validCookieKey;
    @Nullable
    private Map<String, String> loginParams;
    @Nullable
    private ArrayList<String> exceptScriptCode;
    @Nullable
    private Map<String, String> purchaseParams;

    public ParsingRuleData(ScrapEntity scrap, UserEntity userEntity) {
        this.scrap = scrap;
        this.user = userEntity;
        this.setExceptScriptCode(this.user.getUserId(), this.user.getPassword());
        this.validCookieKey = new ArrayList<String>(Arrays.asList(scrap.getValidCookieKeys().split(";")));
        this.purchaseUrl = Validator.replaceDateParams(scrap.getPurchaseUrl(), this.user.getLastScrapAt());
        if (scrap.getPurchaseParams() != null && !scrap.getPurchaseParams().isEmpty()) {
            this.purchaseParams = Validator.convertMapToString(scrap.getPurchaseParams());
            for (String key : this.purchaseParams.keySet()) {
                if (!this.purchaseParams.get(key).startsWith("dynamicDate")) continue;
                String value = this.purchaseParams.get(key);
                this.purchaseParams.put(key, Validator.replaceDateParams(value, this.user.getLastScrapAt()));
            }
        }
        if (scrap.getLoginParams() != null && !scrap.getLoginParams().isEmpty()) {
            this.loginParams = Validator.convertMapToString(scrap.getLoginParams());
            for (String key : this.loginParams.keySet()) {
                if (this.loginParams.get(key).contains("dynamicID")) {
                    this.loginParams.put(key, this.user.getUserId());
                    continue;
                }
                if (!this.loginParams.get(key).contains("dynamicPW")) continue;
                this.loginParams.put(key, this.user.getPassword());
            }
        }
    }

    private void setExceptScriptCode(String userId, String userPw) {
        if (this.scrap.getIsWebviewLogin() == 1 && this.scrap.getScriptCodes() != null) {
            this.webViewScriptCode = String.format(this.scrap.getScriptCodes(), userId, userPw);
            if (this.scrap.getScriptCodes() != null && !this.scrap.getScriptCodes().isEmpty()) {
                this.exceptScriptCode = new ArrayList();
                this.exceptScriptCode.add(this.scrap.getScriptCodes());
            }
        }
    }

    public ScrapEntity getScrap() {
        return this.scrap;
    }

    public String getId() {
        return this.user.getUserId();
    }

    public String getPw() {
        return this.user.getPassword();
    }

    public String getLastSyncDate() {
        return this.user.getLastScrapAt();
    }

    public String getPurchaseUrl() {
        return this.purchaseUrl;
    }

    public String getWebViewScriptCode() {
        return this.webViewScriptCode;
    }

    @Nullable
    public ArrayList<String> getValidCookieKey() {
        return this.validCookieKey;
    }

    @Nullable
    public Map<String, String> getLoginParams() {
        return this.loginParams;
    }

    @Nullable
    public ArrayList<String> getExceptScriptCode() {
        return this.exceptScriptCode;
    }

    @Nullable
    public Map<String, String> getPurchaseParams() {
        return this.purchaseParams == null ? new HashMap() : this.purchaseParams;
    }
}

