/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scrap.login;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tenqube.visual_scraper.scrap.login.LoginService;
import com.tenqube.visual_scraper.utils.LogUtil;
import com.tenqube.visual_scraper.vo.ParsingRuleData;
import java.util.Timer;
import java.util.TimerTask;

public class WebViewLogin
implements LoginService {
    private LoginService.OnLoginCallback callback;
    private ParsingRuleData mParsingRuleData;
    private Handler handler;
    private WebView webView;
    private boolean usedLoginScript;
    private boolean isLoginSuccess;
    private static final long TiMEOUT_TIMEMILLIS = 10000L;
    private Timer timer;
    private TimerTask timerTask;
    private Handler mTimerHandler = new Handler();
    private Context mContext;
    private static final String TAG = LogUtil.makeLogTag(WebViewLogin.class);
    private CookieManager cookieManager;

    @SuppressLint(value={"AddJavascriptInterface", "SetJavaScriptEnabled"})
    public WebViewLogin(Context context, ParsingRuleData parsingRuleData) {
        this.mParsingRuleData = parsingRuleData;
        this.mContext = context;
        this.handler = new Handler();
        this.init(this.mContext);
    }

    private void init(Context context) {
        this.webView = new WebView(context);
        this.cookieManager = this.createCookieManager();
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setUserAgentString("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36");
        this.webView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                WebViewLogin.this.stopTimer();
                WebViewLogin.this.closeWebView();
                if (Build.VERSION.SDK_INT >= 23) {
                    WebViewLogin.this.callback.onLoginFail(error.getErrorCode(), error.getDescription().toString());
                } else {
                    WebViewLogin.this.callback.onLoginFail(403, error.toString());
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                try {
                    WebViewLogin.this.stopTimer();
                    if (WebViewLogin.this.checkLoginState(url)) {
                        return;
                    }
                    if (!WebViewLogin.this.usedLoginScript) {
                        WebViewLogin.this.loadUrl(WebViewLogin.this.mParsingRuleData.getWebViewScriptCode());
                        WebViewLogin.this.usedLoginScript = true;
                    } else {
                        WebViewLogin.this.usedLoginScript = false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    WebViewLogin.this.closeWebView();
                    WebViewLogin.this.callback.onLoginFail(403, e.toString());
                }
            }
        });
    }

    private boolean checkLoginState(String url) {
        if (this.usedLoginScript && this.cookieManager.getCookie(url) != null) {
            this.isLoginSuccess = this.isLoginSuccess(this.cookieManager.getCookie(url));
            this.closeWebView();
            if (this.isLoginSuccess) {
                this.callback.onLoginSuccess(this.cookieManager.getCookie(url));
            } else {
                this.callback.onLoginFail(403, "Invalid User Info");
            }
            return true;
        }
        return false;
    }

    private void loadUrl(String url) {
        this.startTimer();
        this.handler.post(() -> this.webView.loadUrl(url, null));
    }

    private CookieManager createCookieManager() {
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        CookieSyncManager.createInstance((Context)this.mContext);
        if (Build.VERSION.SDK_INT >= 26) {
            this.webView.getSettings().setSafeBrowsingEnabled(false);
        }
        return cookieManager;
    }

    @Override
    public void login(LoginService.OnLoginCallback callback) {
        this.callback = callback;
        this.loadUrl(this.mParsingRuleData.getScrap().getLoginUrl());
    }

    private void closeWebView() {
        if (this.webView != null) {
            this.handler.post(() -> {
                this.webView.stopLoading();
                this.webView.clearCache(true);
                this.webView.clearHistory();
                if (Build.VERSION.SDK_INT >= 21) {
                    this.cookieManager.removeSessionCookies(value -> {});
                } else {
                    this.cookieManager.removeSessionCookie();
                }
                this.cookieManager.removeAllCookie();
            });
        }
    }

    private boolean isLoginSuccess(String cookie) {
        LogUtil.LOGI(TAG, cookie);
        if (this.mParsingRuleData.getValidCookieKey() != null) {
            for (String invalidKey : this.mParsingRuleData.getValidCookieKey()) {
                if (cookie.contains(invalidKey)) continue;
                return false;
            }
        }
        return true;
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
            this.timerTask = null;
        }
    }

    private void startTimer() {
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                WebViewLogin.this.mTimerHandler.post(() -> {
                    WebViewLogin.this.stopTimer();
                    if (WebViewLogin.this.mParsingRuleData.getExceptScriptCode() != null && WebViewLogin.this.mParsingRuleData.getExceptScriptCode().size() > 0) {
                        WebViewLogin.this.loadUrl(WebViewLogin.this.mParsingRuleData.getExceptScriptCode().get(0));
                        WebViewLogin.this.mParsingRuleData.getExceptScriptCode().remove(0);
                    } else {
                        WebViewLogin.this.closeWebView();
                        WebViewLogin.this.usedLoginScript = false;
                        WebViewLogin.this.callback.onLoginFail(403, "Timeout Fail");
                    }
                });
            }
        };
        this.timer.schedule(this.timerTask, 10000L);
    }
}

