package com.tenqube.visual_scraper.scrap;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.scrap.login.ApiLogin;
import com.tenqube.visual_scraper.scrap.login.LoginService;
import com.tenqube.visual_scraper.scrap.login.WebViewLogin;
import com.tenqube.visual_scraper.scrap.mall.MallParser;
import com.tenqube.visual_scraper.scrap.mall.Parser;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.vo.ParsingRuleData;
import com.tenqube.visual_scraper.vo.api.RequestDocumentData;

public class Scraper {

    private final static String TAG = Scraper.class.getSimpleName();

    private Parser mParser;
    private OnPurchaseResult mListener;
    private LoginService mLogin;
    public static Boolean SCRAPING_DEBUG_MODE = false;
    private Context mContext;
    private AppExecutors appExecutors;

    public Scraper(@NonNull Context context,
                   @NonNull ParsingRuleData parsingRuleData,
                   @NonNull OnPurchaseResult listener,
                   boolean debugMode) {

        mContext = context;
        mListener = listener;
        SCRAPING_DEBUG_MODE = debugMode;

        mLogin = parsingRuleData.getScrap().getIsWebviewLogin() == 0 ?
                new ApiLogin(parsingRuleData)
                :
                new WebViewLogin(mContext, parsingRuleData);

        mParser = new MallParser(parsingRuleData);

        appExecutors = new AppExecutors();

    }

    /**
     * 파서 시작 함수
     * 로그인 - 파싱
     */
    public void start() {

        Log.i(TAG, "start");

        Runnable runnable = () -> mLogin.login(new LoginService.OnLoginCallback() {
            @Override
            public void onLoginSuccess(String cookie) {

                Log.i(TAG, "onLoginSuccess cookie : " + cookie);

                parse(cookie);
            }

            @Override
            public void onLoginFail(int statusCode, String statusMessage) {
                Log.i(TAG, "onLoginFail statusMessage : " + statusMessage);

                mListener.onLoginFail(statusCode, statusMessage);
            }
        });

        appExecutors.networkIO().execute(runnable);
    }

    /**
     * 몰 파싱
     * @param cookie
     */
    private void parse(String cookie) {
        Runnable runnable = () -> mParser.parse(cookie, new Parser.OnResponsePurchasePage() {
                @Override
                public void onPurchasePageResult(RequestDocumentData documents) {

                    Log.i(TAG, "onPurchasePageResult : " + documents.contents.size());

                    mListener.onPurchaseFinished(Constants.MESSAGES.PURCHASE_END, documents);
                }

                @Override
                public void onParsingFail(String message) {
                    mListener.onFail(Constants.STATUSCODE.FAIL_CODE, message);
                }
            });

        appExecutors.networkIO().execute(runnable);
    }
}
