/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.repository;

import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.api.ScrapApiService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.ScraperDatabase;
import com.tenqube.visual_scraper.db.dao.LoginApiRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginWebRuleDao;
import com.tenqube.visual_scraper.db.dao.MallDao;
import com.tenqube.visual_scraper.db.dao.MallWithUserDao;
import com.tenqube.visual_scraper.db.dao.OrderApiRuleDao;
import com.tenqube.visual_scraper.db.dao.OrderDao;
import com.tenqube.visual_scraper.db.dao.OrderDetailWebRuleDao;
import com.tenqube.visual_scraper.db.dao.OrderWebRuleDao;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.dao.UserWithOrdersDao;
import com.tenqube.visual_scraper.db.entity.MallEntity;
import com.tenqube.visual_scraper.db.entity.OrderApiRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderDetailWebRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.OrderWebRuleJson;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.model.jsonParsing.MallScrapInfo;
import com.tenqube.visual_scraper.model.newApi.request.OrderBody;
import com.tenqube.visual_scraper.model.newApi.request.SaveOrdersBody;
import com.tenqube.visual_scraper.model.newApi.request.SignUpBody;
import com.tenqube.visual_scraper.model.newApi.response.ResultBody;
import com.tenqube.visual_scraper.model.newApi.response.ResultSignUp;
import com.tenqube.visual_scraper.model.query.LoginRule;
import com.tenqube.visual_scraper.model.query.MallWithUser;
import com.tenqube.visual_scraper.model.view.MallInfo;
import com.tenqube.visual_scraper.model.view.OrderInfo;
import com.tenqube.visual_scraper.model.view.OrderWebRule;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.utils.DateUtils;
import com.tenqube.visual_scraper.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Response;

public class ScrapRepository {
    private static ScrapRepository sInstance;
    private AppExecutors appExecutors;
    private final ScraperDatabase mDatabase;
    private final UserDao userDao;
    private final OrderDao orderDao;
    private final UserWithOrdersDao userWithOrdersDao;
    private final MallWithUserDao mallWithUserDao;
    private final MallDao mallDao;
    private final LoginRuleDao loginRuleDao;
    private final LoginApiRuleDao loginApiRuleDao;
    private final LoginWebRuleDao loginWebRuleDao;
    private final OrderApiRuleDao orderApiRuleDao;
    private final OrderWebRuleDao orderWebRuleDao;
    private final OrderDetailWebRuleDao orderDetailWebRuleDao;
    private final ScrapApiService mApi;
    private SharedPreferences preferences;

    private ScrapRepository(ScraperDatabase database, ScrapApiService scrapApi, AppExecutors appExecutors, SharedPreferences preferences) {
        this.mDatabase = database;
        this.userDao = database.userDao();
        this.orderDao = database.orderDao();
        this.userWithOrdersDao = database.userWithOrdersDao();
        this.mallWithUserDao = database.mallWithUserDao();
        this.mallDao = database.mallDao();
        this.loginRuleDao = database.loginRuleDao();
        this.loginApiRuleDao = database.loginApiRuleDao();
        this.loginWebRuleDao = database.loginWebRuleDao();
        this.orderApiRuleDao = database.orderApiRuleDao();
        this.orderWebRuleDao = database.orderWebRuleDao();
        this.orderDetailWebRuleDao = database.orderDetailWebRuleDao();
        this.preferences = preferences;
        this.mApi = scrapApi;
        this.appExecutors = appExecutors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScrapRepository getInstance(ScraperDatabase database, ScrapApiService scrapApi, AppExecutors appExecutors, SharedPreferences preferences) {
        if (sInstance != null) return sInstance;
        Class<ScrapRepository> clazz = ScrapRepository.class;
        synchronized (ScrapRepository.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ScrapRepository(database, scrapApi, appExecutors, preferences);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return sInstance;
        }
    }

    public void saveKey(String apiKey) {
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            apiKey = "sVPnrNW0Fg4fujRSLJrYn8FJWyO5BtS21hAbOYXc";
        }
        this.preferences.edit().putString("x-api-key", apiKey).apply();
    }

    public void saveLayer(String layer) {
        this.preferences.edit().putString("layer", layer).apply();
    }

    public void signUpUser(String appName, String uuid, ScrapService.Callback<Void> callback) {
        this.appExecutors.networkIO().execute(() -> {
            try {
                Response response = this.mApi.callSignUpUser(new SignUpBody(appName, uuid)).execute();
                if (response.isSuccessful()) {
                    Log.i((String)"signUpUser", (String)("success : " + response.body()));
                    this.preferences.edit().putString("uuid", uuid).apply();
                    ResultBody result = (ResultBody)response.body();
                    if (result != null) {
                        this.preferences.edit().putString("token", ((ResultSignUp)result.result).authorization.mall).apply();
                        this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(null));
                    }
                } else {
                    Log.i((String)"signUpUser", (String)("error :" + response.message()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void syncRule(ScrapService.Callback<Void> callback) {
        this.appExecutors.networkIO().execute(() -> {
            try {
                Response response = this.mApi.callGetRules().execute();
                if (response.isSuccessful()) {
                    Log.i((String)"syncRule", (String)("success !!: " + response.body()));
                    ResultBody results = (ResultBody)response.body();
                    if (results != null) {
                        if (this.preferences.getInt("ruleVersion", -1) == ((MallScrapInfo)results.result).getVersion()) {
                            callback.onDataLoaded(null);
                            return;
                        }
                        this.preferences.edit().putInt("ruleVersion", ((MallScrapInfo)results.result).getVersion()).apply();
                        this.mallDao.insertList(((MallScrapInfo)results.result).getMalls());
                        if (((MallScrapInfo)results.result).getLoginJsonRules() != null) {
                            this.loginApiRuleDao.insert(((MallScrapInfo)results.result).getLoginJsonRules());
                        }
                        if (((MallScrapInfo)results.result).getLoginHtmlRules() != null) {
                            this.loginWebRuleDao.insertList(((MallScrapInfo)results.result).getLoginHtmlRules());
                        }
                        if (((MallScrapInfo)results.result).getOrderJsonRules() != null) {
                            this.orderApiRuleDao.insert(((MallScrapInfo)results.result).getOrderJsonRules());
                        }
                        if (((MallScrapInfo)results.result).getOrderHtmlRules() != null) {
                            this.orderWebRuleDao.insertList(((MallScrapInfo)results.result).getOrderHtmlRules());
                        }
                        if (((MallScrapInfo)results.result).getOrderDetailHtmlRules() != null) {
                            this.orderDetailWebRuleDao.insertList(((MallScrapInfo)results.result).getOrderDetailHtmlRules());
                        }
                        Log.i((String)"getJsonMallScraps", (String)("getMalls : " + ((MallScrapInfo)results.result).getMalls()));
                        Log.i((String)"getJsonMallScraps", (String)("getLoginJsonRules : " + ((MallScrapInfo)results.result).getLoginJsonRules()));
                        Log.i((String)"getJsonMallScraps", (String)("getLoginHtmlRules : " + ((MallScrapInfo)results.result).getLoginHtmlRules()));
                        Log.i((String)"getJsonMallScraps", (String)("getOrderJsonRules : " + ((MallScrapInfo)results.result).getOrderJsonRules()));
                        Log.i((String)"getJsonMallScraps", (String)("getOrderHtmlRules : " + ((MallScrapInfo)results.result).getOrderHtmlRules()));
                        Log.i((String)"getJsonMallScraps", (String)("getOrderHtmlRules : " + ((MallScrapInfo)results.result).getOrderDetailHtmlRules()));
                    }
                } else {
                    Log.i((String)"syncRule", (String)("" + response.message()));
                }
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(null));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void callInsertOrderList() {
        this.appExecutors.networkIO().execute(() -> {
            List<OrderEntity> dataList = this.orderDao.getOrdersForServer();
            if (dataList.size() > 0) {
                ArrayList<OrderBody> results = new ArrayList<OrderBody>();
                ArrayList<Integer> ids = new ArrayList<Integer>();
                for (OrderEntity o : dataList) {
                    OrderBody orderBody = new OrderBody(o.mId, o.title, DateUtils.transformDateStr(o.orderDate), o.orderHms == null ? "" : DateUtils.transformHmsStr(o.orderHms), o.orderOption, o.quantity, o.price, o.currency, o.orderNum, o.orderState, o.imgUrl);
                    results.add(orderBody);
                    ids.add(o._id);
                    Log.i((String)"saveOrderBody", (String)("info : " + orderBody));
                }
                try {
                    Log.i((String)"result", (String)("SaveOrdersBody : " + new SaveOrdersBody(results)));
                    Response response = this.mApi.callSaveOrders(new SaveOrdersBody(results)).execute();
                    if (response.isSuccessful()) {
                        String result = (String)response.body();
                        this.orderDao.updateIsSendServer(ids);
                        Log.i((String)"callInsertOrderList", (String)("result : " + result));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void getOrderList(ScrapService.Callback<List<OrderEntity>> callback, int ... mIds) {
        this.appExecutors.diskIO().execute(() -> {
            List<OrderEntity> list = this.orderDao.getOrders(mIds);
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(list));
        });
    }

    public void getOrderList(ScrapService.Callback<List<OrderEntity>> callback, int mId) {
        this.appExecutors.diskIO().execute(() -> {
            List<OrderEntity> list = this.orderDao.getOrders(mId);
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(list));
        });
    }

    public void getAllOrderList(ScrapService.Callback<List<OrderInfo>> callback) {
        this.appExecutors.diskIO().execute(() -> {
            List<OrderEntity> list = this.orderDao.getOrders();
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(Utils.convertOrderInfo(list)));
        });
    }

    public void updateUserLastScrapAt(long lastScrapAt, int mallId, String userId) {
        try {
            this.appExecutors.diskIO().execute(() -> this.userDao.updateUserLastScrapAt(lastScrapAt, mallId, userId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateUserForSignOut(final int mId, final ScrapService.OnResultCallback<Void> callback) {
        try {
            this.appExecutors.diskIO().execute(() -> {
                final long i = this.userDao.updateUserIsLogin(mId, false);
                Log.i((String)"updateUserForSignOut", (String)("i : " + i));
                this.appExecutors.mainThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (i > 0L) {
                            callback.onDataLoaded(null);
                        } else {
                            callback.onFail(mId, Constants.ERROR.LOGIN_OUT_FAIL, "logout fail");
                        }
                    }
                });
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertOrders(List<OrderEntity> orderEntityList, ScrapService.Callback<List<OrderEntity>> callback) {
        try {
            this.appExecutors.diskIO().execute(() -> {
                List<Long> savedIds = this.orderDao.insertList(orderEntityList);
                Log.i((String)"insertOrders", (String)("savedIds size : " + savedIds.size() + " / " + savedIds));
                ArrayList<Long> resultIds = new ArrayList<Long>();
                for (Long l : savedIds) {
                    if (l == -1L) continue;
                    resultIds.add(l);
                }
                Log.i((String)"insertOrders", (String)("resultIds size : " + resultIds.size() + " / " + resultIds));
                List<OrderEntity> savedList = this.orderDao.getOrderList(resultIds);
                Log.i((String)"insertOrders", (String)("savedList size : " + savedList.size() + " / " + savedList));
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(savedList));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertUsers(UserEntity userEntity) {
        try {
            this.appExecutors.diskIO().execute(() -> {
                this.userDao.insert(userEntity);
                List<UserEntity> l = this.userDao.getUsers();
                Log.i((String)"user", (String)("info : " + l));
                for (UserEntity u : l) {
                    Log.i((String)"user", (String)("info : " + u));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteOrder(int orderId) {
        try {
            this.appExecutors.diskIO().execute(() -> this.orderDao.deleteOrder(orderId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteOrder(int ... orderIds) {
        try {
            this.appExecutors.diskIO().execute(() -> this.orderDao.deleteOrders(orderIds));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteForMallId(int mId) {
        try {
            this.appExecutors.diskIO().execute(() -> this.orderDao.deleteOrdersForMallId(mId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteForMallIds(int ... mIds) {
        try {
            this.appExecutors.diskIO().execute(() -> this.orderDao.deleteOrderForMallIds(mIds));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteAll() {
        try {
            this.appExecutors.diskIO().execute(() -> this.orderDao.deleteAll());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkIsActiveMall(int mId, ScrapService.Callback<MallEntity> callback) {
        Runnable runnable = () -> {
            MallEntity mallEntity = this.mallDao.getMall(mId);
            callback.onDataLoaded(mallEntity);
        };
        this.appExecutors.diskIO().execute(runnable);
    }

    public void getMallList(ScrapService.Callback<List<MallInfo>> callback) {
        this.appExecutors.diskIO().execute(() -> {
            try {
                List<MallEntity> list = this.mallDao.getMalls();
                ArrayList<MallInfo> results = new ArrayList<MallInfo>();
                for (MallEntity mallEntity : list) {
                    results.add(new MallInfo(mallEntity.getId(), mallEntity.getDisplayName(), mallEntity.getIconUrl()));
                }
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(results));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void getMallWithUser(int mId, String uId, ScrapService.onResultInterface<MallWithUser> callback) {
        this.appExecutors.diskIO().execute(() -> {
            try {
                MallWithUser mallWithUser = this.mallWithUserDao.getInfo(mId, uId);
                Log.i((String)"getMallWithUser", (String)("info : " + mallWithUser));
                if (mallWithUser != null) {
                    callback.onDataLoaded(mallWithUser);
                } else {
                    callback.onFail();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void getMallWithUser(ScrapService.Callback<List<MallWithUser>> callback) {
        this.appExecutors.diskIO().execute(() -> {
            try {
                List<MallWithUser> list = this.mallWithUserDao.getInfoForActiveMall();
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(list));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void getMallWithActiveUsers(ScrapService.Callback<List<MallWithUser>> callback) {
        this.appExecutors.diskIO().execute(() -> {
            try {
                List<MallWithUser> list = this.mallWithUserDao.getInfosForActiveUser();
                Log.i((String)"getMallWithActiveUsers", (String)("info : " + list));
                for (MallWithUser u : list) {
                    Log.i((String)"getMallWithActiveUsers", (String)("info : " + u));
                }
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(list));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void getMallWithActiveUser(int mallId, ScrapService.Callback<MallWithUser> callback) {
        this.appExecutors.diskIO().execute(() -> {
            try {
                MallWithUser mallWithUser = this.mallWithUserDao.getInfoForActiveUser(mallId);
                Log.i((String)"getMallWithActiveUser", (String)("info : " + mallWithUser));
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(mallWithUser));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void getLoginRule(int mId, ScrapService.Callback<LoginRule> callback) {
        this.appExecutors.diskIO().execute(() -> {
            LoginRule loginRule = this.loginRuleDao.getInfo(mId);
            Log.i((String)"login", (String)("loginRule : " + loginRule));
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(loginRule));
        });
    }

    public void getOrderWebRule(int mId, ScrapService.Callback<OrderWebRule> callback) {
        this.appExecutors.diskIO().execute(() -> {
            OrderWebRuleJson orderWebRuleJson = this.orderWebRuleDao.getInfo(mId);
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(new OrderWebRule(orderWebRuleJson)));
        });
    }

    public void getOrderApiRule(int mId, ScrapService.Callback<OrderApiRuleJson> callback) {
        this.appExecutors.diskIO().execute(() -> {
            OrderApiRuleJson orderApiRuleJson = this.orderApiRuleDao.getInfo(mId);
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(orderApiRuleJson));
        });
    }

    public void getDetailHtmlRule(int mId, ScrapService.Callback<OrderDetailWebRuleJson> callback) {
        this.appExecutors.diskIO().execute(() -> {
            OrderDetailWebRuleJson orderDetailWebRuleJson = this.orderDetailWebRuleDao.getInfo(mId);
            Utils.getDetailUrl(orderDetailWebRuleJson);
            this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(orderDetailWebRuleJson));
        });
    }
}

