package com.tenqube.visual_scraper.manager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import com.tenqube.visual_scraper.MallViewService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.scrap.mall.Mall;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.util.Timer;
import java.util.TimerTask;

public class WebViewManager {

    private static final long TIMEOUT_TIMEMILLIS = 30000;

    private Mall mall;
    private WebView webView;
    private Context context;
    private Handler handler;
    private CookieManager cookieManager;

    private WebViewCallback callback;
    private Timer timer, tempTimer;
    private TimerTask timerTask;
    private Handler mTimerHandler = new Handler();

    private String webUrl;
    private String scripts;
    private String tempScripts;
    private int action;

    public static final int DEFAULT = 0;
    public static final int LOGIN = 1;
    public static final int ORDER_PARSING = 2;
    private int failedCnt = 0;
    private boolean isFinishedCallback;
    private MallViewService mallViewService;
    private boolean isVisibleWebView;
    private boolean isLoginFinished;
    private boolean isCheckedCaptcha;

    @SuppressLint({"JavascriptInterface", "SetJavaScriptEnabled", "AddJavascriptInterface"})
    public WebViewManager(Context context, MallViewService mallViewService /*, WebView view*/) {
        this.context = context;
        this.handler = new Handler();
        this.mallViewService = mallViewService;
        initWebView();
    }

    @SuppressLint({"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initWebView() {
        this.webView = /*view == null ? */new WebView(context) /*: view*/;
//        createCookieManager();
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setUserAgentString(Constants.USER_AGENT);

        webView.addJavascriptInterface(new ScriptInterface(), "HtmlViewer");
        webView.getSettings().setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) webView.getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_COMPATIBILITY_MODE);
        webView.setLayerType(WebView.LAYER_TYPE_SOFTWARE, null);
        webView.setWebViewClient(new WebViewClient() {
            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                Log.i("onReceivedError","error : "+error);

                stopTimer();
//                closeWebView();

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    switch (error.getErrorCode()) {
                        case ERROR_UNSUPPORTED_SCHEME:
                            return;
                }}

                new Handler(Looper.getMainLooper()).post(() -> {

                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {

                        callback.onFail(error.getErrorCode(), error.getDescription().toString());
                    } else {
                        callback.onFail(403, error.toString());
                    }
                });

            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                Log.i("onPageFinished","url : "+url);

                onPageFinishedCallback(view, url);

            }



//            @Override
//            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
//                Log.i("isRedirect","!!"+request.isRedirect());
//                view.loadUrl(request.getUrl());
//
//            }

        });

        webView.setWebChromeClient(new WebChromeClient(){
            @Override
            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                Log.i("onJsAlert","message : "+ message + "url : "+url);
                LoginFailed(message);
                result.confirm();
                return true;
            }
        });

    }

    private void onPageFinishedCallback(WebView view, String url) {

        if (action == LOGIN && isLoginFinished) return;

        if ("about:blank".equals(url) && view.getTag() != null) {
            view.loadUrl(view.getTag().toString());
            return;
        } else {
            view.setTag(url);
        }

//      sycCookie();
        stopTimer();



        if(/*url.contains(webUrl) && */scripts != null){
            loadScripts(scripts);
            tempScripts = scripts;
            scripts = null;
            isFinishedCallback = true;
        } else if(action == LOGIN/* && scripts == null*/){

            if (url.contains(webUrl) || mall.identifyLoginPageOrNot(url) /*|| url.contains("https://nid.naver.com/signin/")*/){
                // 로그인 실패
                Log.i("scripts fail","!! " + failedCnt + " "+ isVisibleWebView);
                // check Error or Captcha
//                if (failedCnt ==0) {
                if (mall.doCheckLoginError() || (mall.doCheckLoginCaptcha() && !isVisibleWebView && !isCheckedCaptcha)){
                    getLoginHtml();
//                    failedCnt++;
                } else {
                    if (!isVisibleWebView) retryLogin();
                }


            } else {
                // 로그인 성공
                failedCnt = 0;
                if (isVisibleWebView) {
                    new Handler(Looper.getMainLooper()).post(()->{
                        if (mallViewService != null) mallViewService.setWebView(webView, View.GONE);
                        isVisibleWebView = false;
                    });
                }
                finish();
            }
        } else {
            if (action == ORDER_PARSING &&  (url.contains("main") || url.contains("Home") || (url.contains("www.naver.com") ))) {
                Log.i("page","Pass!!!!!!!");
//                        startTimer();
                return;
            }
            failedCnt = 0;
            finish();
        }
    }

    private void retryLogin() {
        failedCnt++;
        Log.i("retryLogin","failedCnt : "+failedCnt);

        if (failedCnt == 5){
            callback.onFail(400, "로그인 실패 5번"); // 실패
            closeWebView();
            return;
        }
        loadScripts(tempScripts);
    }

    private void sycCookie() {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            CookieSyncManager.getInstance().sync();
        } else {
            CookieManager.getInstance().flush();
        }

    }

    private void finish() {
        Log.i("webview","finish "+ action);
        if (callback != null) {
            switch (action) {
                case DEFAULT :
                    callback.onResult(webUrl, webView);
                    break;
                case LOGIN :
                    new Handler(Looper.getMainLooper()).post(() -> {

//                        if (checkLoginState()){
                            Toast.makeText(context, "Login finished", Toast.LENGTH_SHORT).show();
                            failedCnt = 0;
                            isLoginFinished = true;
                            callback.onResult(null, webView);//cookieManager.getCookie(webUrl), webView); // 성공
//                        } else {
//                            callback.onFail(403, "로그인 실패");
//                            closeWebView();
//                        }
                    });
                    break;

                case ORDER_PARSING :
                    // html 가져오기
                    getHtml();
//                    closeWebView();
                    break;
            }
        }
    }

    class ScriptInterface {

        ScriptInterface() {
        }

        @SuppressLint("SetJavaScriptEnabled")
        @JavascriptInterface
        public void showHTML(String html) {
//            Log.i("showHTML", "html : "+html);
            if (callback != null) {
                callback.onResult(html, webView);
                Toast.makeText(context, "finish", Toast.LENGTH_SHORT).show();
                closeWebView();
            }
        }

        @SuppressLint("SetJavaScriptEnabled")
        @JavascriptInterface
        public void checkHTML(String html) {
//            Log.i("checkHTML", "html : "+html);

            Document document = Jsoup.parse(html);
            if (document == null) return;

            if (mall.doCheckLoginError()) {
                String error = mall.checkLoginError(document);
                Log.i("checkHTML", "error : "+error);

                if (!TextUtils.isEmpty(error)) {
                    // 로그인 오류 > CLOSED
                    LoginFailed(error);

                } else if (mall.doCheckLoginCaptcha()){
                    if (!findCapchaImage(document)) retryLogin();
                } else {
                    retryLogin();
                }
            } else if (mall.doCheckLoginCaptcha()){
                // 로그인 에러 안주는 몰일경우 retryLogin 대신 로그인 에러처리 (x) -> 몇번수행후 에러처리
                if (!findCapchaImage(document)) retryLogin();
            }
        }

    }

    private boolean findCapchaImage(Document document) {
        isCheckedCaptcha = true;
        if (mall.checkCaptchaImage(document)){
            // webView 띄우기
            Log.i("checkHTML","captcha");
            new Handler(Looper.getMainLooper()).post(() -> {
                if (mallViewService != null){
                    isVisibleWebView = true;
                    mallViewService.setWebView(webView, View.VISIBLE);
                } else {
                    // 로그인 실패
                    callback.onFail(403, "(캡챠) 로그인 실패");
                    closeWebView();
                }
            });
            return true;
        }
        return false;
    }


    @JavascriptInterface
    private void getHtml() {
        webView.loadUrl("javascript:window.HtmlViewer.showHTML" +
                "('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
    }

    @JavascriptInterface
    private void getLoginHtml() {
        Log.i("getLoginHtml","!!");

        handler.post(()-> {
            webView.loadUrl("javascript:window.HtmlViewer.checkHTML" +
                    "('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
        });
    }

    private void LoginFailed(String error){
        new Handler(Looper.getMainLooper()).post(() -> {
            isLoginFinished = true;
            stopTimer();
            Toast.makeText(context, ""+error, Toast.LENGTH_LONG).show();
            callback.onFail(400, "로그인 오류");
            closeWebView();
        });
    }

    public WebViewManager setWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public WebViewManager setScripts(String scripts) {
        this.scripts = scripts;
        return this;
    }

    public WebViewManager setAction(int mode) {
        this.action = mode;
        return this;
    }

    public void build(WebViewCallback callback) {
        this.callback = callback;
        if (webUrl != null){
            isLoginFinished = false;
            loadWebView(webUrl, false);
            //test
//            mallViewService.setWebView(webView, View.VISIBLE);
        } else {
            callback.onFail(403, "webUrl does not exist");
            closeWebView();
        }
    }

    public void setMall(Mall mall) {
        this.mall = mall;
    }

    private void loadScripts(String scripts) {

        try {

            // 1. cookie 존재 유무 체크
//            if (checkLoginState()) {
//                // 1-1. cookie 존재 > Success
//                if (action == LOGIN){
//                    finish();
//                } else {
//                    // scripts 실행
//                    Log.i("loadScripts","scripts 실행 "+ scripts);
//                    loadWebView(scripts);
//                    scripts = null;
//                }
//            } else {
                // 1-2. cookie 존재 x  > 로그인 스크립트 실행
//                callback.onFail(403, "로그인 되어있지 않음");
            Log.i("loadScripts","scripts 실행 "+ scripts);
            Toast.makeText(context, "loadScripts : "+scripts, Toast.LENGTH_SHORT).show();
            loadWebView(scripts, true);

            tempTimer = timer;
            Log.i("TEST","temp : "+tempTimer + "//"+timer + "/"+timerTask);
            if (failedCnt > 2) return;

            handler.postDelayed(() -> {
                    // 3초후에 finish 가 울리지 않는다면
                    // timer 체크
                    Log.i("TESTT","temp : "+tempTimer + "//"+timer + "/"+timerTask);
                    if (action == LOGIN && timer != null) {
                        Log.i("loadScripts","OnPageFinished 안울림 , 로그인 오류 체크 ");
                        // 로그인 오류 체크
                        stopTimer();
                        getLoginHtml();

                    }

                    if (action == ORDER_PARSING && timer != null && mall.doParsingMall()) {
                        stopTimer();
                        if (isFinishedCallback) {
                            finish();
                        }
                    }
                }, 10000);
//            }
        } catch (Exception e) {
            e.printStackTrace();
            callback.onFail(403, e.toString());
            closeWebView();
        }
    }

    private boolean checkLoginState() {
        return cookieManager.getCookie(webUrl) != null;
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void loadWebView(String urlOrScripts, boolean isScripts) {
        Log.i("loadWebView","url :"+ urlOrScripts + " //\nisScript : "+ isScripts +"//" +scripts );
        startTimer();
        handler.postDelayed(() -> webView.loadUrl(urlOrScripts, null), /*isScripts? 1000 :*/ 0);
    }

     private WebViewManager createCookieManager() {
        cookieManager = CookieManager.getInstance();//.getCookieStore();
        cookieManager.setAcceptCookie(true);
        cookieManager.setAcceptThirdPartyCookies(webView, true);

         if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            webView.getSettings().setSafeBrowsingEnabled(false);
        }

        return this;
    }




    public interface WebViewCallback {
        void onResult(String item, WebView webView);
        void onFail(int statusCode, String statusMessage);
    }


    private void closeWebView() {
        Log.i("closeWebView","!!");
        if (webView != null) {
            handler.post(() -> {
                if (action == LOGIN) isLoginFinished = true;
                failedCnt = 0;
                isFinishedCallback = false;
//                webView.stopLoading();
                webView.clearCache(true);
//                webView.clearHistory();
//
//                if (cookieManager != null) {
//
//                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
//                        cookieManager.removeSessionCookies(value -> {
//                        });
//                    } else {
//                        cookieManager.removeSessionCookie();
//                    }
//                    cookieManager.removeAllCookie();
//                }
            });
        }
    }

    private void stopTimer(){
        if(timer != null){
            timer.cancel();
            timer.purge();
            timer = null;
            timerTask = null;
        }
    }

    public WebView getWebView(){
        return webView;
    }

    private void startTimer() {

        timer = new Timer();
        timerTask = new TimerTask() {
            @Override
            public void run() {

                mTimerHandler.post(() -> {
                    Log.i("TimeOut", "action : "+action + "/url : "+webUrl+" scripts : "+scripts);
                    stopTimer();
                    if (isFinishedCallback) {
                        finish();
                        return;
                    }

                    closeWebView();
                    callback.onFail(403, Constants.MESSAGES.TIMEOUT_FAIL);
                });

            }
        };
        timer.schedule(timerTask, TIMEOUT_TIMEMILLIS);

    }
}
