package com.tenqube.visual_scraper.model.view;

import com.tenqube.visual_scraper.db.entity.OrderWebRuleJson;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.utils.Utils;

public class OrderWebRule {

    private final int id;

    private final int mallId;

    private final QueryRuleBody url;

    private final String requestBody;

    private final int requestMethod;

    private final QueryRuleBody periodScripts;

//    private final String pageDiv;

    private final ParsingOrderRules container;

    private final ParsingOrderRules title;

    private final ParsingOrderRules orderDate;

    private final ParsingOrderRules orderHms;

    private final ParsingOrderRules orderOption;

    private final ParsingOrderRules quantity;

    private final ParsingOrderRules price;

    private final ParsingOrderRules orderNum;

    private final ParsingOrderRules orderState;

    private final ParsingOrderRules imgUrl;

    private final ParsingOrderRules detailOrderLink;

    private final ParsingOrderRules detailProductLink;


    public OrderWebRule(OrderWebRuleJson orderWebRuleJson) {
        this.id = orderWebRuleJson.getId();
        this.mallId = orderWebRuleJson.getMallId();
        this.url = Utils.parseJsonObject(orderWebRuleJson.getUrl(), QueryRuleBody.class);
        this.requestBody = orderWebRuleJson.getRequestBody();
        this.requestMethod = orderWebRuleJson.getRequestMethod();
        this.periodScripts = Utils.parseJsonObject(orderWebRuleJson.getPeriodScripts(), QueryRuleBody.class);
        this.container = Utils.parseJsonObject(orderWebRuleJson.getContainer(), ParsingOrderRules.class);
        this.title = Utils.parseJsonObject(orderWebRuleJson.getTitle(), ParsingOrderRules.class);
        this.orderDate = Utils.parseJsonObject(orderWebRuleJson.getOrderDate(), ParsingOrderRules.class);
        this.orderHms = Utils.parseJsonObject(orderWebRuleJson.getOrderHms(), ParsingOrderRules.class);
        this.orderOption = Utils.parseJsonObject(orderWebRuleJson.getOrderOption(), ParsingOrderRules.class);
        this.quantity = Utils.parseJsonObject(orderWebRuleJson.getQuantity(), ParsingOrderRules.class);
        this.price = Utils.parseJsonObject(orderWebRuleJson.getPrice(), ParsingOrderRules.class);
        this.orderNum = Utils.parseJsonObject(orderWebRuleJson.getOrderNum(), ParsingOrderRules.class);
        this.orderState = Utils.parseJsonObject(orderWebRuleJson.getOrderState(), ParsingOrderRules.class);
        this.imgUrl = Utils.parseJsonObject(orderWebRuleJson.getImgUrl(), ParsingOrderRules.class);
        this.detailOrderLink = Utils.parseJsonObject(orderWebRuleJson.getDetailOrderLink(), ParsingOrderRules.class);
        this.detailProductLink = Utils.parseJsonObject(orderWebRuleJson.getDetailProductLink(), ParsingOrderRules.class);
    }

    public int getId() {
        return id;
    }

    public int getMallId() {
        return mallId;
    }

    public QueryRuleBody getUrl() {
        return url;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public int getRequestMethod() {
        return requestMethod;
    }

    public QueryRuleBody getPeriodScripts() {
        return periodScripts;
    }

    public ParsingOrderRules getContainer() {
        return container;
    }

    public ParsingOrderRules getTitle() {
        return title;
    }

    public ParsingOrderRules getOrderDate() {
        return orderDate;
    }

    public ParsingOrderRules getOrderHms() {
        return orderHms;
    }

    public ParsingOrderRules getOrderOption() {
        return orderOption;
    }

    public ParsingOrderRules getQuantity() {
        return quantity;
    }

    public ParsingOrderRules getPrice() {
        return price;
    }

    public ParsingOrderRules getOrderNum() {
        return orderNum;
    }

    public ParsingOrderRules getOrderState() {
        return orderState;
    }

    public ParsingOrderRules getImgUrl() {
        return imgUrl;
    }

    public ParsingOrderRules getDetailOrderLink() {
        return detailOrderLink;
    }

    public ParsingOrderRules getDetailProductLink() {
        return detailProductLink;
    }

    @Override
    public String toString() {
        return "OrderWebRule{" +
                "id=" + id +
                ", mallId=" + mallId +
                ", url=" + url +
                ", requestBody='" + requestBody + '\'' +
                ", requestMethod=" + requestMethod +
                ", periodScripts=" + periodScripts +
                ", container=" + container +
                ", title=" + title +
                ", orderDate=" + orderDate +
                ", orderHms=" + orderHms +
                ", orderOption=" + orderOption +
                ", quantity=" + quantity +
                ", price=" + price +
                ", orderNum=" + orderNum +
                ", orderState=" + orderState +
                ", imgUrl=" + imgUrl +
                ", detailOrderLink=" + detailOrderLink +
                ", detailProductLink=" + detailProductLink +
                '}';
    }
}
