package com.tenqube.visual_scraper.db.entity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;

import java.io.Serializable;

@Entity(tableName = "order_web_rule"/*,
        indices = {@Index(value = {"uid", "order_num"}, unique = true)},
        foreignKeys =  {
                @ForeignKey(entity = UserEntity.class,
                        parentColumns = "user_id",
                        childColumns = "uid",
                        onDelete = CASCADE)}*/)
public class OrderWebRuleJson implements Serializable {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    private int id;

    @ColumnInfo(name = "mall_id")
    private final int mallId;

    @ColumnInfo(name = "url")
    private final String url;

    @ColumnInfo(name = "request_body")
    private final String requestBody;

    @ColumnInfo(name = "request_method")
    private final int requestMethod;

    @ColumnInfo(name = "period_scripts")
    private final String periodScripts;

//    @ColumnInfo(name = "page_div")
//    private final String pageDiv;

    @ColumnInfo(name = "container")
    private final String container;

    @ColumnInfo(name = "title")
    private final String title;

    @ColumnInfo(name = "order_date")
    private final String orderDate;

    @ColumnInfo(name = "order_hms")
    private final String orderHms;

    @ColumnInfo(name = "order_option")
    private final String orderOption;

    @ColumnInfo(name = "quantity")
    private final String quantity;

    @ColumnInfo(name = "price")
    private final String price;

    @ColumnInfo(name = "order_num")
    private final String orderNum;

    @ColumnInfo(name = "order_state")
    private final String orderState;

    @ColumnInfo(name = "img_url")
    private final String imgUrl;

    @ColumnInfo(name = "detail_order_link")
    private final String detailOrderLink;

    @ColumnInfo(name = "detail_product_link")
    private final String detailProductLink;

    public OrderWebRuleJson(int mallId, String url, String requestBody, int requestMethod, String periodScripts, String container, String title, String orderDate, String orderHms, String orderOption, String quantity, String price, String orderNum, String orderState, String imgUrl, String detailOrderLink, String detailProductLink) {
        this.mallId = mallId;
        this.url = url;
        this.requestBody = requestBody;
        this.requestMethod = requestMethod;
        this.periodScripts = periodScripts;
        this.container = container;
        this.title = title;
        this.orderDate = orderDate;
        this.orderHms = orderHms;
        this.orderOption = orderOption;
        this.quantity = quantity;
        this.price = price;
        this.orderNum = orderNum;
        this.orderState = orderState;
        this.imgUrl = imgUrl;
        this.detailOrderLink = detailOrderLink;
        this.detailProductLink = detailProductLink;
    }

    public int getMallId() {
        return mallId;
    }

    public int getId() {
        return id;
    }

    public String getUrl() {
        return url;
    }

    @NonNull
    public String getContainer() {
        return container;
    }

    @NonNull
    public String getTitle() {
        return title;
    }

    @NonNull
    public String getOrderDate() {
        return orderDate;
    }

    @NonNull
    public String getOrderHms() {
        return orderHms;
    }

    @NonNull
    public String getOrderOption() {
        return orderOption;
    }

    @NonNull
    public String getQuantity() {
        return quantity;
    }

    @NonNull
    public String getPrice() {
        return price;
    }

    @NonNull
    public String getOrderNum() {
        return orderNum;
    }

    @NonNull
    public String getOrderState() {
        return orderState;
    }

    @NonNull
    public String getImgUrl() {
        return imgUrl;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public int getRequestMethod() {
        return requestMethod;
    }

    public String getPeriodScripts() {
        return periodScripts;
    }

    public String getDetailOrderLink() {
        return detailOrderLink;
    }

    public String getDetailProductLink() {
        return detailProductLink;
    }

    @Override
    public String toString() {
        return "OrderWebRuleJson{" +
                "id=" + id +
                ", mallId=" + mallId +
                ", url='" + url + '\'' +
                ", requestBody='" + requestBody + '\'' +
                ", requestMethod=" + requestMethod +
                ", periodScripts='" + periodScripts + '\'' +
                ", container='" + container + '\'' +
                ", title='" + title + '\'' +
                ", orderDate='" + orderDate + '\'' +
                ", orderHms='" + orderHms + '\'' +
                ", orderOption='" + orderOption + '\'' +
                ", quantity='" + quantity + '\'' +
                ", price='" + price + '\'' +
                ", orderNum='" + orderNum + '\'' +
                ", orderState='" + orderState + '\'' +
                ", imgUrl='" + imgUrl + '\'' +
                ", detailOrderLink='" + detailOrderLink + '\'' +
                ", detailProductLink='" + detailProductLink + '\'' +
                '}';
    }
}
