/*
 * Copyright 2016, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tenqube.visual_scraper.db.entity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;

import java.util.Date;

import static android.arch.persistence.room.ForeignKey.CASCADE;

/**
 * TODO uId, title, order_date 가 unique 키로 설정
 */
@Entity(tableName = "orders", indices = {@Index(value = {"order_num", "title", "order_date", "order_hms", "price"}, unique = true)}

        /*,
        foreignKeys =  {
                @ForeignKey(entity = MallEntity.class,
                        parentColumns = "_id",
                        childColumns = "mall_id",
                        onDelete = CASCADE)}*/)
public final class OrderEntity {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    public int _id;

    @ColumnInfo(name = "mall_id")
    public int mId;

    @ColumnInfo(name = "user_id")
    public int uId;

    @NonNull
    @ColumnInfo(name = "title")
    public String title;

    @NonNull
    @ColumnInfo(name = "order_date")
    public Date orderDate;

    @ColumnInfo(name = "order_hms")
    public Date orderHms;

    @ColumnInfo(name = "order_option")
    public String orderOption;

    @ColumnInfo(name = "quantity")
    public int quantity;

    @NonNull
    @ColumnInfo(name = "price")
    public double price;

    @ColumnInfo(name = "currency")
    public String currency;

    @NonNull
    @ColumnInfo(name = "order_num")
    public String orderNum;

    @ColumnInfo(name = "order_state")
    public String orderState;

    @ColumnInfo(name = "img_url")
    public String imgUrl;

    @ColumnInfo(name = "memo")
    public String memo;

    @ColumnInfo(name = "is_delete")
    public boolean isDelete;

    @ColumnInfo(name = "is_success")
    public boolean isSuccess;

    @Ignore
    @ColumnInfo(name = "uuid")
    public String uuid;

    @ColumnInfo(name = "detail_order_link")
    public String detailOrderLink;

    @ColumnInfo(name = "detail_prod_link")
    public String detailProductLink;


    public OrderEntity() {
        super();
    }

    @Ignore
    public OrderEntity(int mId, int uId, @NonNull String title, @NonNull Date orderDate, Date orderHms, String orderOption, int quantity, double price, String orderNum, String orderState, String imgUrl) {
        this.mId = mId;
        this.uId = uId;
        this.title = title;
        this.orderDate = orderDate;
        this.orderHms = orderHms;
        this.orderOption = orderOption;
        this.quantity = quantity;
        this.price = price;
        this.orderNum = orderNum;
        this.orderState = orderState;
        this.imgUrl = imgUrl;
        this.currency = "KRW";
    }

    public int get_id() {
        return _id;
    }

    public int getmId() {
        return mId;
    }

    public int getuId() {
        return uId;
    }

    @NonNull
    public String getTitle() {
        return title;
    }

    @NonNull
    public Date getOrderDate() {
        return orderDate;
    }

    public Date getOrderHms() {
        return orderHms;
    }

    public String getOrderOption() {
        return orderOption;
    }

    public int getQuantity() {
        return quantity;
    }

    public double getPrice() {
        return price;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public String getOrderState() {
        return orderState;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public String getMemo() {
        return memo;
    }

    public boolean isDelete() {
        return isDelete;
    }

    public boolean isSuccess() {
        return isSuccess;
    }

    public String getUuid() {
        return uuid;
    }

    public String getDetailOrderLink() {
        return detailOrderLink;
    }

    public String getDetailProdLink() {
        return detailProductLink;
    }

    @Override
    public String toString() {
        return "OrderEntity{" +
                "_id=" + _id +
                ", mId=" + mId +
                ", uId=" + uId +
                ", title='" + title + '\'' +
                ", orderDate=" + orderDate +
                ", orderHms=" + orderHms +
                ", orderOption='" + orderOption + '\'' +
                ", quantity=" + quantity +
                ", price=" + price +
                ", currency='" + currency + '\'' +
                ", orderNum='" + orderNum + '\'' +
                ", orderState='" + orderState + '\'' +
                ", imgUrl='" + imgUrl + '\'' +
                ", memo='" + memo + '\'' +
                ", isDelete=" + isDelete +
                ", isSuccess=" + isSuccess +
                ", uuid='" + uuid + '\'' +
                ", detailOrderLink='" + detailOrderLink + '\'' +
                ", detailProductLink='" + detailProductLink + '\'' +
                '}';
    }
}
