/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.tenqube.visual_scraper.db.Converters;
import com.tenqube.visual_scraper.db.dao.LoginApiRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginWebRuleDao;
import com.tenqube.visual_scraper.db.dao.MallDao;
import com.tenqube.visual_scraper.db.dao.MallWithUserDao;
import com.tenqube.visual_scraper.db.dao.OrderApiRuleDao;
import com.tenqube.visual_scraper.db.dao.OrderDao;
import com.tenqube.visual_scraper.db.dao.OrderDetailWebRuleDao;
import com.tenqube.visual_scraper.db.dao.OrderWebRuleDao;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.dao.UserWithOrdersDao;
import com.tenqube.visual_scraper.db.entity.LoginApiRule;
import com.tenqube.visual_scraper.db.entity.LoginWebRule;
import com.tenqube.visual_scraper.db.entity.MallEntity;
import com.tenqube.visual_scraper.db.entity.OrderApiRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderDetailWebRule;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.OrderWebRuleJson;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.model.jsonParsing.MallScrapInfo;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.utils.Utils;

@Database(entities={UserEntity.class, OrderEntity.class, MallEntity.class, LoginApiRule.class, LoginWebRule.class, OrderApiRuleJson.class, OrderWebRuleJson.class, OrderDetailWebRule.class}, version=1, exportSchema=false)
@TypeConverters(value={Converters.class})
public abstract class ScraperDatabase
extends RoomDatabase {
    public static final String DATABASE_NAME = "online_malls";
    private static ScraperDatabase sInstance;
    private final MutableLiveData<Boolean> mIsDatabaseCreated = new MutableLiveData();

    public abstract UserDao userDao();

    public abstract OrderDao orderDao();

    public abstract UserWithOrdersDao userWithOrdersDao();

    public abstract MallWithUserDao mallWithUserDao();

    public abstract MallDao mallDao();

    public abstract LoginRuleDao loginRuleDao();

    public abstract LoginWebRuleDao loginWebRuleDao();

    public abstract LoginApiRuleDao loginApiRuleDao();

    public abstract OrderApiRuleDao orderApiRuleDao();

    public abstract OrderWebRuleDao orderWebRuleDao();

    public abstract OrderDetailWebRuleDao orderDetailWebRuleDao();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScraperDatabase getInstance(Context context, AppExecutors executors) {
        if (sInstance != null) return sInstance;
        Class<ScraperDatabase> clazz = ScraperDatabase.class;
        synchronized (ScraperDatabase.class) {
            if (sInstance != null) return sInstance;
            sInstance = ScraperDatabase.buildDatabase(context.getApplicationContext(), executors);
            sInstance.updateDatabaseCreated(context.getApplicationContext());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    private static ScraperDatabase buildDatabase(final Context appContext, final AppExecutors executors) {
        return (ScraperDatabase)Room.databaseBuilder((Context)appContext, ScraperDatabase.class, (String)DATABASE_NAME).addCallback(new RoomDatabase.Callback(){

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                super.onCreate(db);
                executors.diskIO().execute(() -> {
                    ScraperDatabase.addDelay();
                    ScraperDatabase database = ScraperDatabase.getInstance(appContext, executors);
                    database.setDatabaseCreated();
                });
            }
        }).build();
    }

    private void updateDatabaseCreated(Context context) {
        if (context.getDatabasePath(DATABASE_NAME).exists()) {
            this.setDatabaseCreated();
        }
    }

    private void setDatabaseCreated() {
        this.mIsDatabaseCreated.postValue((Object)true);
    }

    private static void getJsonMallScraps(Context context, ScraperDatabase database) {
        String jsonStr = Utils.loadJSONFromAsset(context, "mall_info.json");
        try {
            Log.i((String)"array", (String)("jsonStr : " + jsonStr));
            MallScrapInfo mallScrapInfo = Utils.fromJson(jsonStr, MallScrapInfo.class);
            Log.i((String)"getJsonMallScraps", (String)("mall_info : " + mallScrapInfo));
            database.mallDao().insertList(mallScrapInfo.getMalls());
            if (mallScrapInfo.getLoginJsonRules() != null) {
                database.loginApiRuleDao().insert(mallScrapInfo.getLoginJsonRules());
            }
            database.loginWebRuleDao().insertList(mallScrapInfo.getLoginHtmlRules());
            database.orderApiRuleDao().insert(mallScrapInfo.getOrderJsonRules());
            database.orderWebRuleDao().insertList(mallScrapInfo.getOrderHtmlRules());
            Log.i((String)"getJsonMallScraps", (String)("getMalls : " + mallScrapInfo.getMalls()));
            Log.i((String)"getJsonMallScraps", (String)("getLoginJsonRules : " + mallScrapInfo.getLoginJsonRules()));
            Log.i((String)"getJsonMallScraps", (String)("getLoginHtmlRules : " + mallScrapInfo.getLoginHtmlRules()));
            Log.i((String)"getJsonMallScraps", (String)("getOrderJsonRules : " + mallScrapInfo.getOrderJsonRules()));
            Log.i((String)"getJsonMallScraps", (String)("getOrderHtmlRules : " + mallScrapInfo.getOrderHtmlRules()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addDelay() {
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public LiveData<Boolean> getDatabaseCreated() {
        return this.mIsDatabaseCreated;
    }
}

