package com.tenqube.visual_scraper.db.entity.newEntity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.PrimaryKey;

import java.io.Serializable;

@Entity(tableName = "order_detail_web_rule")
public class OrderDetailWebRule implements Serializable {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    private int id;

    @ColumnInfo(name = "mall_id")
    private final int mallId;

    @ColumnInfo(name = "url")
    private final String url;

    @ColumnInfo(name = "request_body")
    private final String requestBody;

    @ColumnInfo(name = "request_method")
    private final int requestMethod;

    public OrderDetailWebRule(int mallId, String url, String requestBody, int requestMethod) {
        this.mallId = mallId;
        this.url = url;
        this.requestBody = requestBody;
        this.requestMethod = requestMethod;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getMallId() {
        return mallId;
    }

    public String getUrl() {
        return url;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public int getRequestMethod() {
        return requestMethod;
    }

    @Override
    public String toString() {
        return "OrderDetailWebRule{" +
                "id=" + id +
                ", mallId=" + mallId +
                ", url='" + url + '\'' +
                ", requestBody='" + requestBody + '\'' +
                ", requestMethod=" + requestMethod +
                '}';
    }
}
