package com.tenqube.visual_scraper.db.entity.newEntity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.utils.Utils;

import java.io.Serializable;

import static android.arch.persistence.room.ForeignKey.CASCADE;

@Entity(tableName = "login_web_rules",
        indices = {@Index(value = {"mall_id"}, unique = true)},
        foreignKeys =  {
                @ForeignKey(entity = MallEntity.class,
                        parentColumns = "m_id",
                        childColumns = "mall_id",
                        onDelete = CASCADE)})
public class LoginWebRule implements Serializable {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "id")
    private int id;

    @ColumnInfo(name = "mall_id")
    private final String mallId;

    @ColumnInfo(name = "web_url")
    private final String url;

    @ColumnInfo(name = "loginScripts")
    private final String loginScripts;
//
//    @ColumnInfo(name = "is_captcha_on")
//    public final int isCaptchaOn;

    @ColumnInfo(name = "captcha_container")
    private final String captchaContainer;

    @ColumnInfo(name = "fail_message")
    private final String failMessage;

    @Ignore
    @ColumnInfo(name = "scripts_body")
    private QueryRuleBody scriptsBody;

    @Ignore
    @ColumnInfo(name = "url_body")
    private QueryRuleBody urlBody;



    // 생성시 스크립트 gson 변환
    public LoginWebRule(String mallId, String url, @NonNull String loginScripts, String captchaContainer, String failMessage/*, int isCaptchaOn*/) {
        this.mallId = mallId;
        this.url = url;
        this.loginScripts = loginScripts;
        this.captchaContainer = captchaContainer;
        this.failMessage = failMessage;
//        this.isCaptchaOn = isCaptchaOn;
    }

    public int getId() {
        return id;
    }

    public String getMallId() {
        return mallId;
    }

    public String getUrl() {
        return url;
    }


    public String getLoginScripts() {
        return loginScripts;
    }

    public void setId(int id) {
        this.id = id;
    }

//    public boolean isCaptchaOn() {
//        return isCaptchaOn == 1;
//    }

    public QueryRuleBody getScriptsBody() {
        if (scriptsBody == null && !TextUtils.isEmpty(loginScripts)) scriptsBody = Utils.fromJson(loginScripts, QueryRuleBody.class);
        return scriptsBody;
    }

    public void setScriptsBody(QueryRuleBody scriptsBody) {
        this.scriptsBody = scriptsBody;
    }

    public QueryRuleBody getUrlBody() {
        if (urlBody == null && !TextUtils.isEmpty(url)) urlBody = Utils.fromJson(url, QueryRuleBody.class);
        return urlBody;
    }

    public void setUrlBody(QueryRuleBody urlBody) {
        this.urlBody = urlBody;
    }

    public String getCaptchaContainer() {
        return captchaContainer;
    }

    public String getFailMessage() {
        return failMessage;
    }

    @Override
    public String toString() {
        return "LoginWebRule{" +
                "id=" + id +
                ", mallId='" + mallId + '\'' +
                ", url='" + url + '\'' +
                ", loginScripts='" + loginScripts + '\'' +
                ", captchaContainer='" + captchaContainer + '\'' +
                ", failMessage='" + failMessage + '\'' +
                ", scriptsBody=" + scriptsBody +
                ", urlBody=" + urlBody +
                '}';
    }
}
