/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.gson.Gson;
import com.tenqube.visual_scraper.api.HeaderInterceptor;
import com.tenqube.visual_scraper.api.ScrapApiService;
import com.tenqube.visual_scraper.db.ScraperDatabase;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.utils.NullOnEmptyConverterFactory;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Injection {
    public static ScrapRepository provideScrapRepository(Context context, SharedPreferences preferences) {
        AppExecutors appExecutors = Injection.provideAppExecutor();
        OkHttpClient okHttpClient = Injection.provideOkHttpClient(preferences);
        Retrofit retrofit = Injection.provideRetrofit(okHttpClient, Injection.provideSharedPreference(context));
        ScrapApiService apiService = Injection.provideScrapApiService(retrofit);
        return ScrapRepository.getInstance(Injection.provideScraperDatabase(context, appExecutors), apiService, appExecutors, preferences);
    }

    private static AppExecutors provideAppExecutor() {
        return new AppExecutors();
    }

    private static ScraperDatabase provideScraperDatabase(Context context, AppExecutors appExecutors) {
        return ScraperDatabase.getInstance(context, appExecutors);
    }

    public static SharedPreferences provideSharedPreference(Context context) {
        return context.getSharedPreferences("com.tenqube.visual_scraper", 0);
    }

    private static ScrapApiService provideScrapApiService(Retrofit retrofit) {
        return (ScrapApiService)retrofit.create(ScrapApiService.class);
    }

    private static Retrofit provideRetrofit(OkHttpClient okHttpClient, SharedPreferences preferences) {
        return new Retrofit.Builder().baseUrl(String.format("https://lmfur57mca.execute-api.ap-northeast-2.amazonaws.com/%s/", preferences.getString("layer", "dev"))).client(okHttpClient).addConverterFactory((Converter.Factory)new NullOnEmptyConverterFactory()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new Gson())).build();
    }

    private static OkHttpClient provideOkHttpClient(SharedPreferences sharedPreferences) {
        HttpLoggingInterceptor logInter = new HttpLoggingInterceptor();
        logInter.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.connectTimeout(10L, TimeUnit.SECONDS);
        okHttpClientBuilder.readTimeout(10L, TimeUnit.SECONDS);
        okHttpClientBuilder.writeTimeout(10L, TimeUnit.SECONDS);
        okHttpClientBuilder.addInterceptor((Interceptor)logInter);
        okHttpClientBuilder.addInterceptor((Interceptor)new HeaderInterceptor(sharedPreferences));
        return okHttpClientBuilder.build();
    }
}

