package com.tenqube.visual_scraper.manager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.http.SslError;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.HttpAuthHandler;
import android.webkit.JavascriptInterface;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import com.tenqube.visual_scraper.constants.Constants;

import java.util.Timer;
import java.util.TimerTask;

public class WebViewManager {

    private static final long TiMEOUT_TIMEMILLIS = 30000;

    private WebView webView;
    private Context context;
    private Handler handler;
    private CookieManager cookieManager;
//    private CookieStore cookieStore;

//    private LoginService.OnLoginCallback loginCallback;
    private WebViewCallback callback;
    private Timer timer;
    private TimerTask timerTask;
    private Handler mTimerHandler = new Handler();

    private String webUrl;
    private String scripts;
    private String tempScripts;
    private int action;

    public static final int DEFAULT = 0;
    public static final int LOGIN = 1;
    public static final int ORDER_PARSING = 2;
    private int failedCnt = 0;
    private boolean isFinishedCallback;


    @SuppressLint({"JavascriptInterface", "SetJavaScriptEnabled", "AddJavascriptInterface"})
    public WebViewManager(Context context/*, WebView view*/) {
        this.context = context;
        this.handler = new Handler();
        initWebView();
    }

    @SuppressLint({"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initWebView() {
        this.webView = /*view == null ? */new WebView(context) /*: view*/;
        createCookieManager();
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setUserAgentString(Constants.USER_AGENT);

        webView.addJavascriptInterface(new ScriptInterface(), "HtmlViewer");
        webView.getSettings().setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) webView.getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_COMPATIBILITY_MODE);
        webView.setLayerType(WebView.LAYER_TYPE_SOFTWARE, null);
        webView.setWebViewClient(new WebViewClient() {
            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                Log.i("onReceivedError","error : "+error);

                stopTimer();
//                closeWebView();
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    callback.onFail(error.getErrorCode(), error.getDescription().toString());
                } else {
                    callback.onFail(403, error.toString());
                }
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                Log.i("onPageFinished","url : "+url);

                if ("about:blank".equals(url) && view.getTag() != null) {
                    view.loadUrl(view.getTag().toString());
                    return;
                } else {
                    view.setTag(url);
                }

//                sycCookie();
                stopTimer();


                if(/*url.contains(webUrl) && */scripts != null){
                    loadScripts(scripts);
                    tempScripts = scripts;
                    scripts = null;
                    isFinishedCallback = true;
                } else if(action == LOGIN/* && scripts == null*/ && (url.contains(webUrl) || url.contains("Login") || url.contains("login"))) {
                    // 로그인 실패
                    Log.i("scripts fail","!!");
                    failedCnt++;
                    if (failedCnt == 5){
                        callback.onFail(400, "로그인 실패 5번");
                        return;
                    }
                    loadScripts(tempScripts);

                } else {
                    if (action == ORDER_PARSING &&  (url.contains("main") || url.contains("Home") || (url.contains("www.naver.com") ))) {
                        Log.i("test","!!!!!!!");
//                        startTimer();
                        return;
                    }
                    failedCnt = 0;
                    finish();
                }

            }

//            @Override
//            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
//                Log.i("isRedirect","!!"+request.isRedirect());
//                view.loadUrl(request.getUrl());
//
//            }

        });
    }

    private void sycCookie() {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            CookieSyncManager.getInstance().sync();
        } else {
            CookieManager.getInstance().flush();
        }

    }

    private void finish() {
        Log.i("webview","finish");
        Toast.makeText(context, "finish", Toast.LENGTH_SHORT).show();
        if (callback != null) {
            switch (action) {
                case DEFAULT :
                    callback.onResult(webUrl, webView);
                    break;
                case LOGIN :
                    if (checkLoginState()){
                        callback.onResult(cookieManager.getCookie(webUrl), webView);
                    } else {
                        callback.onFail(403, "로그인 실패");
                    }
                    break;

                case ORDER_PARSING :
                    // html 가져오기
                    getHtml();
//                    closeWebView();
                    break;
            }
        }
    }

    class ScriptInterface {

        ScriptInterface() {
        }

        @SuppressLint("SetJavaScriptEnabled")
        @JavascriptInterface
        public void showHTML(String html) {
            Log.i("showHTML", "html : "+html);
            if (callback != null) {
                callback.onResult(html, webView);
                closeWebView();
            }
        }
    }

    @JavascriptInterface
    private void getHtml() {
        webView.loadUrl("javascript:window.HtmlViewer.showHTML" +
                "('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
    }


    public WebViewManager setWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public WebViewManager setScripts(String scripts) {
        this.scripts = scripts;
        return this;
    }

    public WebViewManager setAction(int mode) {
        this.action = mode;
        return this;
    }

    public void build(WebViewCallback callback) {
        this.callback = callback;
        if (webUrl != null){
            loadWebView(webUrl, false);
        } else {
            callback.onFail(403, "webUrl does not exist");
            closeWebView();
        }
    }

    private void loadScripts(String scripts) {
        Log.i("loadScripts","info : "+scripts);
        Toast.makeText(context, "loadScripts : "+scripts, Toast.LENGTH_SHORT).show();

        try {

            // 1. cookie 존재 유무 체크
//            if (checkLoginState()) {
//                // 1-1. cookie 존재 > Success
//                if (action == LOGIN){
//                    finish();
//                } else {
//                    // scripts 실행
//                    Log.i("loadScripts","scripts 실행 "+ scripts);
//                    loadWebView(scripts);
//                    scripts = null;
//                }
//            } else {
                // 1-2. cookie 존재 x  > 로그인 스크립트 실행
//                callback.onFail(403, "로그인 되어있지 않음");
                Log.i("loadScripts","scripts 실행 "+ scripts);
                loadWebView(scripts, true);
//            }
        } catch (Exception e) {
            e.printStackTrace();
            callback.onFail(403, e.toString());
            closeWebView();
        }
    }

    private boolean checkLoginState() {
        return cookieManager.getCookie(webUrl) != null;
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void loadWebView(String urlOrScripts, boolean isScripts) {
        Log.i("loadWebView","url :"+ urlOrScripts + " //\nisScript : "+ isScripts +"//" +scripts );
        startTimer();
        handler.postDelayed(() -> webView.loadUrl(urlOrScripts, null), /*isScripts? 1000 :*/ 0);
    }

     private WebViewManager createCookieManager() {
        cookieManager = CookieManager.getInstance();//.getCookieStore();
        cookieManager.setAcceptCookie(true);
        cookieManager.setAcceptThirdPartyCookies(webView, true);

         if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            webView.getSettings().setSafeBrowsingEnabled(false);
        }

        return this;
    }




    public interface WebViewCallback {
        void onResult(String item, WebView webView);
        void onFail(int statusCode, String statusMessage);
    }


    private void closeWebView() {
        Log.i("closeWebView","!!");
        if (webView != null) {
            handler.post(() -> {
                isFinishedCallback = false;
                webView.stopLoading();
                webView.clearCache(true);
                webView.clearHistory();

                if (cookieManager != null) {

                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                        cookieManager.removeSessionCookies(value -> {
                        });
                    } else {
                        cookieManager.removeSessionCookie();
                    }
                    cookieManager.removeAllCookie();
                }
            });
        }
    }

    private void stopTimer(){
        if(timer != null){
            timer.cancel();
            timer.purge();
            timer = null;
            timerTask = null;
        }
    }

    public WebView getWebView(){
        return webView;
    }

    private void startTimer() {

        timer = new Timer();
        timerTask = new TimerTask() {
            @Override
            public void run() {

                mTimerHandler.post(() -> {

                    stopTimer();
                    if (isFinishedCallback) {
                        finish();
                        return;
                    }

                    closeWebView();
                    callback.onFail(403, Constants.MESSAGES.TIMEOUT_FAIL);
                });

            }
        };
        timer.schedule(timerTask, TiMEOUT_TIMEMILLIS);

    }
}
