/*
 * Copyright 2016, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tenqube.visual_scraper.db.entity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;

import static android.arch.persistence.room.ForeignKey.CASCADE;

/**
 * TODO uid, title, order_date 가 unique 키로 설정
 */
@Entity(tableName = "orders",
        indices = {@Index(value = {"uid", "order_num"}, unique = true)},
        foreignKeys =  {
                @ForeignKey(entity = UserEntity.class,
                        parentColumns = "_id",
                        childColumns = "uid",
                        onDelete = CASCADE)})
public final class OrderEntity {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    private final int _id;

    @ColumnInfo(name = "uid")
    private final int uid;

    @NonNull
    @ColumnInfo(name = "title")
    private final String title;

    @NonNull
    @ColumnInfo(name = "order_date")
    private final String orderDate;

    @ColumnInfo(name = "order_hms")
    private final String orderHms;

    @ColumnInfo(name = "order_option")
    private final String orderOption;

    @ColumnInfo(name = "quantity")
    private final int quantity;

    @ColumnInfo(name = "price")
    private final int price;

    @ColumnInfo(name = "order_num")
    private final String orderNum;

    @ColumnInfo(name = "order_state")
    private final String orderState;

    @ColumnInfo(name = "img_url")
    private final String imgUrl;

    @ColumnInfo(name = "detail_order")
    private final String detailOrder;

    @ColumnInfo(name = "detail_prod_link")
    private final String detailProdLink;

    @Ignore
    private ScrapEntity scrapEntity;

    @Ignore
    private UserEntity userEntity;

    public OrderEntity(int _id, int uid, @NonNull String title, @NonNull String orderDate, String orderHms, String orderOption, int quantity, int price, String orderNum, String orderState, String imgUrl, String detailOrder, String detailProdLink) {
        this._id = _id;
        this.uid = uid;
        this.title = title;
        this.orderDate = orderDate;
        this.orderHms = orderHms;
        this.orderOption = orderOption;
        this.quantity = quantity;
        this.price = price;
        this.orderNum = orderNum;
        this.orderState = orderState;
        this.imgUrl = imgUrl;
        this.detailOrder = detailOrder;
        this.detailProdLink = detailProdLink;
    }

    public ScrapEntity getScrapEntity() {
        return scrapEntity;
    }

    public void setScrapEntity(ScrapEntity scrapEntity) {
        this.scrapEntity = scrapEntity;
    }

    public UserEntity getUserEntity() {
        return userEntity;
    }

    public void setUserEntity(UserEntity userEntity) {
        this.userEntity = userEntity;
    }

    public int getId() {
        return _id;
    }

    public int getUid() {
        return uid;
    }

    @NonNull
    public String getTitle() {
        return title;
    }

    @NonNull
    public String getOrderDate() {
        return orderDate;
    }

    public String getOrderHms() {
        return orderHms;
    }

    public String getOrderOption() {
        return orderOption;
    }

    public int getQuantity() {
        return quantity;
    }

    public int getPrice() {
        return price;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public String getOrderState() {
        return orderState;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public String getDetailOrder() {
        return detailOrder;
    }

    public String getDetailProdLink() {
        return detailProdLink;
    }
}
