/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scrap.mall;

import android.support.annotation.NonNull;
import com.tenqube.visual_scraper.scrap.mall.Parser;
import com.tenqube.visual_scraper.vo.ParsingRuleData;
import com.tenqube.visual_scraper.vo.api.RequestContentData;
import com.tenqube.visual_scraper.vo.api.RequestDocumentData;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class MallParser
implements Parser {
    public static final String TAG = MallParser.class.getSimpleName();
    @NonNull
    private ParsingRuleData mParsingRuleData;

    public MallParser(@NonNull ParsingRuleData parsingRuleData) {
        this.mParsingRuleData = parsingRuleData;
    }

    @Override
    public void parse(String cookie, Parser.OnResponsePurchasePage mListener) {
        try {
            Connection.Response response = this.requestUrl(this.mParsingRuleData.getPurchaseUrl(), cookie, this.mParsingRuleData.getScrap().getPurchaseMethodType(), Objects.requireNonNull(this.mParsingRuleData.getPurchaseParams()));
            RequestDocumentData requestDocumentData = this.parseResponse(response);
            mListener.onPurchasePageResult(requestDocumentData);
        }
        catch (Exception e) {
            e.printStackTrace();
            mListener.onParsingFail(e.toString());
        }
    }

    private Connection.Response requestUrl(String url, String cookie, int methodType, @NonNull Map<String, String> queryParams) throws Exception {
        return Jsoup.connect((String)url).userAgent("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36").followRedirects(true).data(queryParams).timeout(26000).ignoreContentType(true).header("cookie", cookie).method(methodType == 0 ? Connection.Method.GET : Connection.Method.POST).execute();
    }

    private RequestDocumentData parseResponse(@NonNull Connection.Response response) throws Exception {
        Document doc = response.parse();
        RequestDocumentData requestDocumentData = new RequestDocumentData();
        requestDocumentData.contents = new ArrayList();
        RequestContentData requestData = new RequestContentData();
        if (response.contentType().contains("application/json")) {
            requestData.contentType = 1;
            requestData.content = doc.select("body").html();
        } else {
            requestData.contentType = 0;
            requestData.content = doc.select(Objects.requireNonNull(this.mParsingRuleData.getScrap().getPurchasePageDivCss())).outerHtml();
        }
        requestDocumentData.contents.add(requestData);
        requestDocumentData.name = this.mParsingRuleData.getScrap().getName();
        requestDocumentData.parsingType = 0;
        return requestDocumentData;
    }
}

