/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.content.Context;
import android.support.annotation.NonNull;
import com.tenqube.visual_scraper.db.DataGenerator;
import com.tenqube.visual_scraper.db.dao.OrderDao;
import com.tenqube.visual_scraper.db.dao.ScrapDao;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.dao.UserWithOrdersDao;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.ScrapEntity;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.utils.AppExecutors;
import java.util.List;

@Database(entities={ScrapEntity.class, UserEntity.class, OrderEntity.class}, version=1, exportSchema=false)
public abstract class ScraperDatabase
extends RoomDatabase {
    public static final String DATABASE_NAME = "online_malls";
    private static ScraperDatabase sInstance;
    private final MutableLiveData<Boolean> mIsDatabaseCreated = new MutableLiveData();

    public abstract ScrapDao scrapDao();

    public abstract UserDao userDao();

    public abstract OrderDao orderDao();

    public abstract UserWithOrdersDao userWithOrdersDao();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScraperDatabase getInstance(Context context, AppExecutors executors) {
        if (sInstance != null) return sInstance;
        Class<ScraperDatabase> clazz = ScraperDatabase.class;
        synchronized (ScraperDatabase.class) {
            if (sInstance != null) return sInstance;
            sInstance = ScraperDatabase.buildDatabase(context.getApplicationContext(), executors);
            sInstance.updateDatabaseCreated(context.getApplicationContext());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    private static ScraperDatabase buildDatabase(final Context appContext, final AppExecutors executors) {
        return (ScraperDatabase)Room.databaseBuilder((Context)appContext, ScraperDatabase.class, (String)DATABASE_NAME).addCallback(new RoomDatabase.Callback(){

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                super.onCreate(db);
                executors.diskIO().execute(() -> {
                    ScraperDatabase.addDelay();
                    ScraperDatabase database = ScraperDatabase.getInstance(appContext, executors);
                    List<ScrapEntity> scrapEntities = DataGenerator.generateScraps();
                    ScraperDatabase.insertData(database, scrapEntities);
                    database.setDatabaseCreated();
                });
            }
        }).build();
    }

    private void updateDatabaseCreated(Context context) {
        if (context.getDatabasePath(DATABASE_NAME).exists()) {
            this.setDatabaseCreated();
        }
    }

    private void setDatabaseCreated() {
        this.mIsDatabaseCreated.postValue((Object)true);
    }

    private static void insertData(ScraperDatabase database, List<ScrapEntity> scrapEntities) {
        database.runInTransaction(() -> database.scrapDao().inserts(scrapEntities));
    }

    private static void addDelay() {
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public LiveData<Boolean> getDatabaseCreated() {
        return this.mIsDatabaseCreated;
    }
}

