package com.tenqube.visual_scraper.api;

import com.tenqube.visual_scraper.vo.api.RequestDocumentData;
import com.tenqube.visual_scraper.vo.api.RuleData;
import com.tenqube.visual_scraper.vo.api.Orders;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

/**
 * Created by tenqube on 2018. 6. 14..
 */

public interface ScrapApiService {

    String BASE_URL = "https://17uz081ava.execute-api.ap-northeast-2.amazonaws.com/dev/";

    /**
     * 파싱룰 서버 동기화
     * @param version 동기화 필드
     * @return
     */
    @GET("sync-rule/{version}")
    Call<RuleData> callScrapingRule(@Path("version")int version);

    /**
     *
     * @param requestDocumentData 주문페이지 데이터
     * @return Orders
     */
    @POST("purchase-parser")
    Call<Orders> callPurchaseParser(@Body RequestDocumentData requestDocumentData);


//    /**
//     *
//     * @param requestDocumentData 상세페이지 데이터
//     * @return OrderData
//     */
//    @POST("detail-parser")
//    ScrapCallAdapter.MyCall<Order> callDetailParser(@Body RequestDocumentData requestDocumentData);
//
//    /******************************************* SCRAPING ********************************************************/
//    @POST("orders")
//    ScrapCallAdapter.MyCall<Void> callOrders(@Body RequestOrders requestOrders);

}
