/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.annotation.Nullable;
import com.tenqube.visual_scraper.data.parsed_data.Orders;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.request_interface.visualserver.VisualApi;
import com.tenqube.visual_scraper.request_interface.visualserver.VisualApiImpl;
import com.tenqube.visual_scraper.utils.LogUtil;
import java.io.Serializable;

public class ParsingService
extends IntentService {
    static final String TAG = ParsingService.class.getSimpleName();
    public static final int PARSING_START = 0;
    public static final int PARSING_FINISHED = 1;
    public static final int PARSING_ERROR = 2;
    public static final String RECEIVER = "scrper_receiver";
    public static final String PURCHASE_HTML = "purchase_html";
    public static final String MALL_ID = "mall_id";
    public static final String USER_ID = "user_id";
    VisualApi visualApi = VisualApiImpl.getInstance((Context)this);
    ResultReceiver receiver = null;

    public ParsingService() {
        super("ParsingService");
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        if (intent != null) {
            this.receiver = (ResultReceiver)intent.getParcelableExtra(RECEIVER);
            this.receiver.send(0, new Bundle());
            RequestDocumentData purchaseHtml = (RequestDocumentData)intent.getSerializableExtra(PURCHASE_HTML);
            String userID = intent.getStringExtra(USER_ID);
            int mallId = intent.getIntExtra(MALL_ID, 0);
            LogUtil.LOGI(TAG, purchaseHtml.toString());
            this.visualApi.callPurchaseParsing(new VisualApiImpl.OnNetworkResultListener<Orders>(){

                @Override
                public void onResult(Orders orders) {
                    Bundle bundle = new Bundle();
                    bundle.putSerializable("Orders", (Serializable)orders);
                    ParsingService.this.receiver.send(1, bundle);
                }

                @Override
                public void onFailResult(int i) {
                    ParsingService.this.receiver.send(2, new Bundle());
                }
            }, purchaseHtml);
        }
    }
}

