/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scraper;

import android.app.Activity;
import android.os.Handler;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.parsed_data.Order;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.request_interface.login.ApiLogin;
import com.tenqube.visual_scraper.request_interface.login.LoginRequest;
import com.tenqube.visual_scraper.request_interface.login.WebViewLogin;
import com.tenqube.visual_scraper.request_interface.page.PageParser;
import com.tenqube.visual_scraper.request_interface.page.PurchaseRequest;
import com.tenqube.visual_scraper.request_interface.result.OnPurchaseResult;
import java.util.ArrayList;

public class ScrapingOnlineMall
implements LoginRequest.OnResponse,
PurchaseRequest.OnResponsePurchasePage {
    private PurchaseRequest mPurchaseRequest;
    private OnPurchaseResult mListener;
    private LoginRequest mLoginRequest;
    private String mCookie;
    public static Boolean SCRAPING_DEBUG_MODE = false;
    private Handler handler;
    private Activity mActivity;
    private static final String TAG = ScrapingOnlineMall.class.getSimpleName();

    public ScrapingOnlineMall(Activity activity, OnPurchaseResult listener, boolean debugMode) {
        SCRAPING_DEBUG_MODE = debugMode;
        this.mListener = listener;
        this.mActivity = activity;
        this.handler = new Handler();
    }

    public void setScraping(ParsingRuleData parsingRuleData) {
        this.mLoginRequest = parsingRuleData.isApiLogin == 0 ? ApiLogin.getInstance(parsingRuleData) : WebViewLogin.getInstance(this.mActivity, parsingRuleData);
        this.mLoginRequest.setOnResponseCallbackListener(this);
        this.mPurchaseRequest = new PageParser(this, parsingRuleData);
    }

    public synchronized void start() throws Exception {
        if (this.mLoginRequest == null || this.mPurchaseRequest == null) {
            throw new Exception("you have to call setScraping first");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScrapingOnlineMall.this.mLoginRequest.doLogin();
            }
        }).start();
    }

    @Override
    public void onLoginSuccess(String cookie) {
        this.mCookie = cookie;
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ScrapingOnlineMall.this.mListener.onLoginSuccess("Success LoginPage");
                ScrapingOnlineMall.this.mListener.onPurchaseStart("Start scraping Purchase");
            }
        });
        this.mPurchaseRequest.doPurchasePageRequest(cookie);
    }

    @Override
    public void onLoginFail(final int statusCode, final String statusMessage) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ScrapingOnlineMall.this.mListener.onFail(statusCode, statusMessage);
            }
        });
    }

    @Override
    public void onPurchasePageResult(final RequestDocumentData documents) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ScrapingOnlineMall.this.mListener.onPurchaseFinished("done", documents);
            }
        });
    }

    @Override
    public void onDetailPurchasePageResult(final RequestDocumentData detailPurchaseDocuments) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ScrapingOnlineMall.this.mListener.onDetailPageScrapingFinished("done", detailPurchaseDocuments);
            }
        });
    }

    public void detailParsingStart(ArrayList<Order> parsedOrderData) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ScrapingOnlineMall.this.mListener.onDetailPageScrapingStart("Start scraping Purchase");
            }
        });
        this.mPurchaseRequest.doDetailPurchasePageRequest(this.mCookie, parsedOrderData);
    }

    @Override
    public void onParsingFail(final String message) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ScrapingOnlineMall.this.mListener.onFail(400, message);
            }
        });
    }
}

