/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.scraper_dao;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import com.tenqube.visual_scraper.db.ScraperDatabaseHelper;

public class QueryDao {
    public SQLiteDatabase db;
    protected SQLiteDatabase wdb;
    public Context mContext;
    public static final String SELECT = " SELECT ";
    public static final String VALUES = " VALUES ";
    public static final String LIMIT = " LIMIT ";
    public static final String ORDER_BY = " ORDER BY ";
    public static final String FROM = " FROM ";
    public static final String WHERE = " WHERE ";
    public static final String GROUP_BY = " GROUP BY ";
    public static final String JOIN = " JOIN ";
    public static final String ON = " ON ";
    public static final String AND = " AND ";
    public static final String IN = " IN ";
    public static final String NOT_IN = " NOT IN ";
    public static final String OR = " OR ";
    public static final String DESC = " DESC ";
    public static final String ASC = " ASC ";
    public static final String YYYY_MM_DD_H_M = "'%Y-%m-%d %H:%M'";
    public static final String YYYY_MM_DD = "'%Y-%m-%d'";
    public static final String MM_DD = "'%m-%d'";
    public static final String H_M_S = "'%H:%M:%S'";
    public static final String H_M = "'%H:%M'";

    public QueryDao(Context context) {
        this.mContext = context;
        this.db = ScraperDatabaseHelper.getInstance(context).getReadableDatabase();
        this.wdb = ScraperDatabaseHelper.getInstance(context).getWritableDatabase();
    }

    public long insert(String tableName, ContentValues values) {
        try {
            return this.wdb.insert(tableName, null, values);
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public long insertOnIgnore(String tableName, ContentValues values) {
        try {
            return this.wdb.insertWithOnConflict(tableName, null, values, 4);
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public long insertOnReplace(String tableName, ContentValues values) {
        try {
            return this.wdb.insertWithOnConflict(tableName, null, values, 5);
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public long update(String tableName, ContentValues values, String selection, String[] selectionArgs) {
        try {
            return this.wdb.update(tableName, values, selection, selectionArgs);
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public long delete(String tableName, String selection, String[] selectionArgs) {
        try {
            return this.wdb.delete(tableName, selection, selectionArgs);
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public Cursor runQuery(String query) {
        Cursor rows = this.db.rawQuery(query, null);
        if (rows == null) {
            return null;
        }
        try {
            int rowCount = rows.getCount();
            if (rowCount == 0 || !rows.moveToLast()) {
                rows.close();
                return null;
            }
        }
        catch (RuntimeException ex) {
            rows.close();
            return null;
        }
        return rows;
    }
}

