package com.tenqube.visual_scraper.scraper;

import android.app.Activity;
import android.os.Handler;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.parsed_data.Order;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.request_interface.login.ApiLogin;
import com.tenqube.visual_scraper.request_interface.login.LoginRequest;
import com.tenqube.visual_scraper.request_interface.login.WebViewLogin;
import com.tenqube.visual_scraper.request_interface.page.PageParser;
import com.tenqube.visual_scraper.request_interface.page.PurchaseRequest;
import com.tenqube.visual_scraper.request_interface.result.OnPurchaseResult;

import java.util.ArrayList;

/**
 * Created by tenqube on 2018. 5. 18..cw.jeon
 */

public class ScrapingOnlineMall implements LoginRequest.OnResponse, PurchaseRequest.OnResponsePurchasePage {

    private PurchaseRequest mPurchaseRequest;
    private OnPurchaseResult mListener;
    private LoginRequest mLoginRequest;
    private String mCookie;
    public static Boolean SCRAPING_DEBUG_MODE = false;
    private Handler handler;
    private Activity mActivity;
    private final static String TAG = ScrapingOnlineMall.class.getSimpleName();

    public ScrapingOnlineMall(Activity activity, OnPurchaseResult listener, boolean debugMode) {

        SCRAPING_DEBUG_MODE = debugMode;
        mListener = listener;
        mActivity = activity;
        handler = new Handler();
    }
    public void setScraping(ParsingRuleData parsingRuleData){

        if (parsingRuleData.isApiLogin == 0) {
            mLoginRequest =  ApiLogin.getInstance(parsingRuleData);
        } else {
            mLoginRequest = WebViewLogin.getInstance(mActivity, parsingRuleData);
        }
        mLoginRequest.setOnResponseCallbackListener(this);
        mPurchaseRequest = new PageParser(this, parsingRuleData);
    }

    public synchronized void start() throws Exception {

        if (mLoginRequest==null|| mPurchaseRequest==null)
            throw new Exception("you have to call setScraping first");
        else {
            new Thread(new Runnable() {
                @Override
                public void run() {

                    mLoginRequest.doLogin();
                }
            }).start();
        }
    }

    @Override
    public void onLoginSuccess(String cookie) {
        this.mCookie = cookie;

        handler.post(new Runnable() {
            @Override
            public void run() {
                mListener.onLoginSuccess(Constants.MESSAGES.LOGIN_SUCCESS);
                //call page
                mListener.onPurchaseStart(Constants.MESSAGES.PURCHASE_START);
            }
        });

        mPurchaseRequest.doPurchasePageRequest(cookie);


    }

    @Override
    public void onLoginFail(final int statusCode, final String statusMessage) {

        handler.post(new Runnable() {
            @Override
            public void run() {

                mListener.onFail(statusCode, statusMessage);
            }
        });
    }


    @Override
    public void onPurchasePageResult(final RequestDocumentData documents) {

        //구매내역 doc 긇어오기 완료
        handler.post(new Runnable() {
            @Override
            public void run() {
                mListener.onPurchaseFinished(Constants.MESSAGES.PURCHASE_END, documents);
            }
        });
        //call server


        //이부분을 밖으로 빼야함 onPurchaseFinish 메소드 안에서 콜하기


    }

    @Override
    public void onDetailPurchasePageResult(final RequestDocumentData detailPurchaseDocuments) {

        handler.post(new Runnable() {
            @Override
            public void run() {
                mListener.onDetailPageScrapingFinished(Constants.MESSAGES.PURCHASE_END, detailPurchaseDocuments);
            }
        });

    }


    public void detailParsingStart(ArrayList<Order> parsedOrderData) {

        //response받은 데이터 request
        handler.post(new Runnable() {
            @Override
            public void run() {
                mListener.onDetailPageScrapingStart(Constants.MESSAGES.PURCHASE_START);
            }
        });

        //call server
        mPurchaseRequest.doDetailPurchasePageRequest(mCookie, parsedOrderData);

    }

    @Override
    public void onParsingFail(final String message) {

        handler.post(new Runnable() {
            @Override
            public void run() {
                mListener.onFail(Constants.STATUSCODE.FAIL_CODE, message);
            }
        });
    }

}
