package com.tenqube.visual_scraper.request_interface.page;

import com.tenqube.visual_scraper.data.parsed_data.Order;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;

import java.util.ArrayList;

/**
 * Created by tenqube on 2018. 5. 18..
 */

public interface PurchaseRequest{

    /**
     * 구매내역 페이지 요청하기
     * @param cookie 로그인 된 쿠키
     */
    void doPurchasePageRequest( String cookie);

    /**
     * 상세페이지 요청하기
     * @param cookie 로그인 된 쿠키
     * @param parsedOrderDatas 구매페이지 파싱 데이터 리스트
     */
    void doDetailPurchasePageRequest(String cookie, ArrayList<Order> parsedOrderDatas);


    interface OnResponsePurchasePage{
        void onPurchasePageResult(RequestDocumentData documents);
        void onDetailPurchasePageResult(RequestDocumentData detailPurchaseDocuments);
        void onParsingFail(String message);
    }
}
