package com.tenqube.visual_scraper.request_interface.login;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.utils.Validator;

import org.jsoup.Connection;
import org.jsoup.Jsoup;

import java.io.IOException;
import java.util.Map;

import static com.tenqube.visual_scraper.constants.Constants.USER_AGENT;
import static com.tenqube.visual_scraper.utils.LogUtil.LOGI;
import static com.tenqube.visual_scraper.utils.LogUtil.makeLogTag;

/**
 * Created by tenqube on 2018. 5. 18..cw.jeon
 */

public class ApiLogin implements LoginRequest {
    private LoginRequest.OnResponse mResponse;
    private static ParsingRuleData mParsingRuleData;
    private static ApiLogin mInstance = null;
    private static final String TAG = makeLogTag(ApiLogin.class);

    private ApiLogin(ParsingRuleData parsingRuleData) {
        mParsingRuleData = parsingRuleData;
    }
    public static ApiLogin getInstance(ParsingRuleData parsingRuleData){
        if (mInstance==null)
            mInstance = new ApiLogin(parsingRuleData);
        else
            mParsingRuleData = parsingRuleData;

        return mInstance;
    }
    /**
     * loginParams setting
     * 로그인 post params setting
     */


    @Override
    public void doLogin() {
        try {

            LOGI(TAG, "login URL : "+mParsingRuleData.loginUrl);

            Connection.Response response = Jsoup.connect(mParsingRuleData.loginUrl)
                    .userAgent(USER_AGENT)
                    .followRedirects(true)
                    .timeout(6000)
                    .ignoreContentType(true)
                    .data(mParsingRuleData.loginParams)
                    .method(Connection.Method.POST)
                    .execute();

            Map<String, String> cookies = response.cookies();

            if (invalidUserCheck(cookies)) {
                LOGI(TAG, " invalidUserCheck true ");

                String cookie = Validator.convertMaptoString(response.cookies());
                mResponse.onLoginSuccess(cookie);

            } else {
                LOGI(TAG, " invalidUserCheck false ");
                mResponse.onLoginFail(response.statusCode(), Constants.MESSAGES.INVALID_USER_INFO);
            }

        } catch (IOException e) {
            e.printStackTrace();
        }


    }

    @Override
    public void setOnResponseCallbackListener(OnResponse responseCallbackListener) {
        this.mResponse = responseCallbackListener;
    }

    private boolean invalidUserCheck(Map<String, String> cookies) {
        for (String invalidKey : mParsingRuleData.validCookieKey){

            if (!cookies.containsKey(invalidKey))
                return false;

        }
        return true;
    }
}
