package com.tenqube.visual_scraper.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.tenqube.visual_scraper.db.table.SyncRuleMallsTable;

import static com.tenqube.visual_scraper.utils.LogUtil.makeLogTag;

/**
 * Created by tenqube on 2018. 4. 30..
 */

public class ScraperDatabaseHelper extends SQLiteOpenHelper{

    private static ScraperDatabaseHelper mInstance = null;
    private static final String DATABASE_NAME = ".com.scraper.db";
    private static final int DATABASE_VERSION = 1;
    protected static final String TAG = makeLogTag(ScraperDatabaseHelper.class);

    private Context mContext;

    private ScraperDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        this.mContext=context;
    }

    public static ScraperDatabaseHelper getInstance(Context context){
        synchronized (ScraperDatabaseHelper.class){
            if (mInstance == null){
                mInstance = new ScraperDatabaseHelper(context.getApplicationContext());
            }
            return mInstance;
        }
    }
    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(SyncRuleMallsTable.SQL_CREATE_TABLE);

        db.execSQL(SyncRuleMallsTable.indexing);

    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (newVersion > oldVersion) {
            switch (oldVersion){
                case 1:
            }
        }
    }
}
