/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.request_interface.login;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.ValueCallback;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tenqube.visual_scraper.R;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.request_interface.login.LoginRequest;
import com.tenqube.visual_scraper.utils.LogUtil;
import java.util.Timer;
import java.util.TimerTask;

public class WebViewLogin
implements LoginRequest {
    private LoginRequest.OnResponse mResponse;
    private ParsingRuleData mParsingRuleData;
    private ViewGroup viewGroup;
    private Handler handler;
    private WebView webView;
    private View webViewLayout;
    private boolean isLogin;
    private static final long TiMEOUT_TIMEMILLIS = 30000L;
    private Timer timer;
    private static final String TAG = LogUtil.makeLogTag(WebViewLogin.class);

    @SuppressLint(value={"AddJavascriptInterface", "SetJavaScriptEnabled"})
    public WebViewLogin(Activity activity, ParsingRuleData parsingRuleData) {
        this.mParsingRuleData = parsingRuleData;
        this.viewGroup = (ViewGroup)activity.getWindow().getDecorView().getRootView();
        this.handler = new Handler();
        LayoutInflater inflater = (LayoutInflater)activity.getSystemService("layout_inflater");
        if (inflater != null) {
            this.webViewLayout = inflater.inflate(R.layout.web_view_layout, null);
            this.viewGroup.addView(this.webViewLayout);
            this.webView = (WebView)this.webViewLayout.findViewById(R.id.visual_web_view);
            CookieManager.getInstance().setAcceptCookie(true);
            final CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT < 21) {
                CookieSyncManager.createInstance((Context)activity);
            }
            cookieManager.setAcceptCookie(true);
            this.webView.getSettings().setJavaScriptEnabled(true);
            this.webView.getSettings().setUserAgentString("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36");
            this.webView.setWebViewClient(new WebViewClient(){

                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    if (Build.VERSION.SDK_INT >= 19) {
                        LogUtil.LOGI(TAG, "login URL : " + url);
                        if (!WebViewLogin.this.isLogin) {
                            WebViewLogin.this.setTimeout();
                            view.loadUrl(((WebViewLogin)WebViewLogin.this).mParsingRuleData.webViewScriptCode, null);
                            WebViewLogin.this.isLogin = true;
                        } else if (((WebViewLogin)WebViewLogin.this).mParsingRuleData.exceptScriptCode.size() > 0) {
                            view.loadUrl(((WebViewLogin)WebViewLogin.this).mParsingRuleData.exceptScriptCode.get(0), null);
                            ((WebViewLogin)WebViewLogin.this).mParsingRuleData.exceptScriptCode.remove(0);
                        } else if (cookieManager.getCookie(url) != null) {
                            WebViewLogin.this.invalidloginCheck(cookieManager.getCookie(url));
                        }
                    }
                }

                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                    return super.shouldOverrideUrlLoading(view, request);
                }
            });
        }
    }

    @Override
    public void doLogin() {
        try {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    WebViewLogin.this.webView.loadUrl(((WebViewLogin)WebViewLogin.this).mParsingRuleData.loginUrl);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setOnResponseCallbackListener(LoginRequest.OnResponse responseCallbackListener) {
        this.mResponse = responseCallbackListener;
    }

    void closeWebView() {
        if (this.webView != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    WebViewLogin.this.webView.stopLoading();
                    WebViewLogin.this.webView.clearCache(true);
                    WebViewLogin.this.webView.clearHistory();
                    WebViewLogin.this.viewGroup.removeView(WebViewLogin.this.webViewLayout);
                    WebViewLogin.this.webViewLayout = null;
                    CookieManager cookieManager = CookieManager.getInstance();
                    if (Build.VERSION.SDK_INT >= 21) {
                        cookieManager.removeSessionCookies((ValueCallback)new ValueCallback<Boolean>(){

                            public void onReceiveValue(Boolean value) {
                            }
                        });
                    } else {
                        cookieManager.removeSessionCookie();
                    }
                    cookieManager.removeAllCookie();
                }
            });
        }
    }

    private void invalidloginCheck(final String cookie) {
        LogUtil.LOGI(TAG, cookie);
        for (String invalidKey : this.mParsingRuleData.validCookieKey) {
            if (cookie.contains(invalidKey)) continue;
            this.mResponse.onLoginFail(403, "Invalid User Info");
            this.closeWebView();
            return;
        }
        this.cancelTimeout();
        this.closeWebView();
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebViewLogin.this.mResponse.onLoginSuccess(cookie);
            }
        }).start();
    }

    private void setTimeout() {
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                WebViewLogin.this.closeWebView();
                WebViewLogin.this.mResponse.onLoginFail(403, "Timeout Fail");
            }
        };
        this.timer.schedule(timerTask, 30000L);
    }

    private void cancelTimeout() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

