/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.request_interface.login;

import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.request_interface.login.LoginRequest;
import com.tenqube.visual_scraper.utils.LogUtil;
import com.tenqube.visual_scraper.utils.Validator;
import java.io.IOException;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ApiLogin
implements LoginRequest {
    private LoginRequest.OnResponse mResponse;
    private ParsingRuleData mParsingRuleData;
    private static final String TAG = LogUtil.makeLogTag(ApiLogin.class);

    public ApiLogin(ParsingRuleData parsingRuleData) {
        this.mParsingRuleData = parsingRuleData;
    }

    @Override
    public void doLogin() {
        try {
            LogUtil.LOGI(TAG, "login URL : " + this.mParsingRuleData.loginUrl);
            Connection.Response response = Jsoup.connect((String)this.mParsingRuleData.loginUrl).userAgent("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36").followRedirects(true).timeout(6000).ignoreContentType(true).data(this.mParsingRuleData.loginParams).method(Connection.Method.POST).execute();
            Map cookies = response.cookies();
            if (this.invalidUserCheck(cookies)) {
                LogUtil.LOGI(TAG, " invalidUserCheck true ");
                String cookie = Validator.convertMaptoString(response.cookies());
                this.mResponse.onLoginSuccess(cookie);
            } else {
                LogUtil.LOGI(TAG, " invalidUserCheck false ");
                this.mResponse.onLoginFail(response.statusCode(), response.statusMessage());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setOnResponseCallbackListener(LoginRequest.OnResponse responseCallbackListener) {
        this.mResponse = responseCallbackListener;
    }

    private boolean invalidUserCheck(Map<String, String> cookies) {
        for (String invalidKey : this.mParsingRuleData.validCookieKey) {
            if (cookies.containsKey(invalidKey)) continue;
            return false;
        }
        return true;
    }
}

