/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.table;

import android.content.ContentValues;
import android.database.Cursor;
import android.provider.BaseColumns;
import com.tenqube.visual_scraper.data.PurchaseData;
import com.tenqube.visual_scraper.db.table.AbstractTable;
import com.tenqube.visual_scraper.utils.DateUtils;

public class PurchaseTable
extends AbstractTable
implements BaseColumns {
    public static final String TABLE_NAME = " purchase";
    public static final String ALIAS = " purchase.";
    public static final String AS_ALIAS = " AS purchase ";
    public static final String COLUMN_SHOPPING_MALL_ID = "mall_id";
    public static final String COLUMN_PURCHANSE_ID = "purchase_id_pk";
    public static final String COLUMN_PURCHASE_DATE = "purchase_date";
    public static final String COLUMN_PURCHASE_HMS = "purchase_hms";
    public static final String COLUMN_ORDER_NUMBER = "order_number";
    public static final String COLUMN_MALL_USER_ID = "mall_user_id";
    public static final String COLUMN_WHERE_TO_BUY = "where_to_buy";
    public static final String COLUMN_ORDER_STATE = "order_state";
    public static final String COLUMN_PRODUCT_NAME = "product_name";
    public static final String COLUMN_PRODUCT_PRICE = "product_price";
    public static final String COLUMN_PRODUCT_CATEGORY = "product_category";
    public static final String COLUMN_PRODUCT_IMG_DOMAIN = "product_img_address";
    public static final String COLUMN_PRODUCT_QUANTITY = "product_quantity";
    public static final String COLUMN_PRODUCT_OPTION = "product_option";
    public static final String COLUMN_PRODUCT_RATING = "product_rating";
    public static final String COLUMN_DELEVERY_COMPANY = "delivery_company";
    public static final String COLUMN_DELEVERY_PRICE = "delivery_price";
    public static final String SQL_CREATE_TABLE = " CREATE TABLE IF NOT EXISTS  purchase (purchase_id_pk INTEGER  PRIMARY KEY  , mall_id INTEGER  NOT NULL  , purchase_date TEXT  NOT NULL  , purchase_hms TEXT  , mall_user_id TEXT  NOT NULL  , order_number TEXT  NOT NULL  , where_to_buy TEXT  'none'  , product_name TEXT  NOT NULL  , product_price INTEGER  NOT NULL  , product_category TEXT  'none'  , product_option TEXT  'none'  , product_quantity INTEGER  , product_img_address TEXT  'none'  , product_rating REAL  , delivery_company TEXT  'none'  , delivery_price TEXT  'none'  , order_state TEXT  'none'  ,  FOREIGN KEY(mall_id) REFERENCES  shopping_mall(shopping_mall_id_pk)   ON DELETE CASCADE ,  UNIQUE (mall_id , order_number , purchase_date) )";
    public static final String indexing = "CREATE INDEX qlip_purchase_idx ON  purchase (order_number,mall_user_id)";
    public static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  purchase";

    public static PurchaseData populateModel(Cursor c) {
        PurchaseData model = new PurchaseData();
        model.user_id = c.getString(c.getColumnIndex(COLUMN_MALL_USER_ID));
        model.shopping_mall_id = c.getInt(c.getColumnIndex(COLUMN_SHOPPING_MALL_ID));
        model.orderNumber = c.getString(c.getColumnIndex(COLUMN_ORDER_NUMBER));
        model.whereTobuy = c.getString(c.getColumnIndex(COLUMN_WHERE_TO_BUY));
        model.purchaseDate = c.getString(c.getColumnIndex(COLUMN_PURCHASE_DATE));
        model.hms = c.getString(c.getColumnIndex(COLUMN_PURCHASE_HMS));
        model.prdTitle = c.getString(c.getColumnIndex(COLUMN_PRODUCT_NAME));
        model.prdImgAddress = c.getString(c.getColumnIndex(COLUMN_PRODUCT_IMG_DOMAIN));
        model.prdPrice = c.getInt(c.getColumnIndex(COLUMN_PRODUCT_PRICE));
        model.prdCategory = c.getString(c.getColumnIndex(COLUMN_PRODUCT_CATEGORY));
        model.prdQuantity = c.getInt(c.getColumnIndex(COLUMN_PRODUCT_QUANTITY));
        model.prdOption = c.getString(c.getColumnIndex(COLUMN_PRODUCT_OPTION));
        model.prdRating = c.getDouble(c.getColumnIndex(COLUMN_PRODUCT_RATING));
        model.deliveryCompany = c.getString(c.getColumnIndex(COLUMN_DELEVERY_COMPANY));
        model.deliveryPrice = c.getString(c.getColumnIndex(COLUMN_DELEVERY_PRICE));
        model.orderState = c.getString(c.getColumnIndex(COLUMN_ORDER_STATE));
        return model;
    }

    public static ContentValues populateContent(PurchaseData model) {
        ContentValues values = new ContentValues();
        values.put(COLUMN_SHOPPING_MALL_ID, Integer.valueOf(model.shopping_mall_id));
        values.put(COLUMN_PURCHASE_DATE, model.purchaseDate == null ? DateUtils.getTodayDate() : model.purchaseDate);
        values.put(COLUMN_MALL_USER_ID, model.user_id);
        values.put(COLUMN_ORDER_NUMBER, model.orderNumber == null ? "" : model.orderNumber);
        values.put(COLUMN_WHERE_TO_BUY, model.whereTobuy == null ? "" : model.whereTobuy);
        values.put(COLUMN_ORDER_STATE, model.orderState == null ? "" : model.orderState);
        values.put(COLUMN_PRODUCT_NAME, model.prdTitle);
        values.put(COLUMN_PRODUCT_PRICE, Double.valueOf(model.prdPrice));
        values.put(COLUMN_PRODUCT_CATEGORY, model.prdCategory == null ? "" : model.prdCategory);
        values.put(COLUMN_PRODUCT_OPTION, model.prdOption == null ? "" : model.prdOption);
        values.put(COLUMN_PRODUCT_QUANTITY, Integer.valueOf(model.prdQuantity));
        values.put(COLUMN_PRODUCT_IMG_DOMAIN, model.prdImgAddress == null ? "" : model.prdImgAddress);
        values.put(COLUMN_DELEVERY_COMPANY, model.deliveryCompany == null ? "" : model.deliveryCompany);
        values.put(COLUMN_DELEVERY_PRICE, model.deliveryPrice == null ? "" : model.deliveryPrice);
        values.put(COLUMN_PRODUCT_RATING, Double.valueOf(model.prdRating));
        values.put(COLUMN_PURCHASE_HMS, model.hms);
        return values;
    }
}

