/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.scraper_dao;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import com.tenqube.visual_scraper.data.MallUserData;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.PurchaseData;
import com.tenqube.visual_scraper.data.ShoppingMallData;
import com.tenqube.visual_scraper.data.dto_data.DtoRuleData;
import com.tenqube.visual_scraper.db.scraper_dao.QueryDao;
import com.tenqube.visual_scraper.db.table.PurchaseTable;
import com.tenqube.visual_scraper.db.table.ShoppingMallTable;
import com.tenqube.visual_scraper.db.table.ShoppingMallUserInfoTable;
import com.tenqube.visual_scraper.db.table.SyncRuleMallsTable;
import com.tenqube.visual_scraper.utils.DateUtils;
import com.tenqube.visual_scraper.utils.LogUtil;
import java.util.ArrayList;

public class OnlineMallDao
extends QueryDao {
    private static OnlineMallDao mInstance = null;
    private Context mContext;
    private static final String TAG = LogUtil.makeLogTag(OnlineMallDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OnlineMallDao getInstance(Context ctx) {
        Class<OnlineMallDao> clazz = OnlineMallDao.class;
        synchronized (OnlineMallDao.class) {
            if (mInstance == null) {
                mInstance = new OnlineMallDao(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private OnlineMallDao(Context context) {
        super(context);
        this.mContext = context;
    }

    public void syncParsingRule(DtoRuleData dtoRuleData) {
        LogUtil.LOGI(TAG, "ParsingRule data insert start...");
        if (dtoRuleData.onlineMalls.size() > 0) {
            for (DtoRuleData.OnlineMall parsingRuleData : dtoRuleData.onlineMalls) {
                LogUtil.LOGI(TAG, "insert :" + parsingRuleData.displayName);
                this.insertOnReplace("sync_rule_malls", SyncRuleMallsTable.populateContent(parsingRuleData));
                ContentValues mallContentValue = new ContentValues();
                mallContentValue.put("mall_name", parsingRuleData.name);
                mallContentValue.put("mall_icon_url", parsingRuleData.iconUrl);
                this.insertOnIgnore(" shopping_mall", mallContentValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadLastSyncDate(int mallId) {
        String query = " SELECT  *  FROM  shopping_mall WHERE shopping_mall_id_pk = " + mallId;
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                LogUtil.LOGI(TAG, "loadLastSyncDate : " + c.getString(c.getColumnIndex("last_sync_date")));
                String string = c.getString(c.getColumnIndex("last_sync_date"));
                return string;
            }
        }
        return null;
    }

    public void insertPurchaseData(PurchaseData purchaseData) {
        this.insertOnReplace(" purchase", PurchaseTable.populateContent(purchaseData));
        this.updateSyncDate(purchaseData.shopping_mall_id);
    }

    public void bulkInsertPurchaseData(ArrayList<PurchaseData> purchaseDataArrayList) {
        for (PurchaseData purchaseData : purchaseDataArrayList) {
            this.insertPurchaseData(purchaseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadParsingRule() {
        String query = " SELECT  *  FROM sync_rule_malls";
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    LogUtil.LOGI(TAG, c.getString(c.getColumnIndex("name")));
                    c.moveToNext();
                }
            }
        }
    }

    public void resetTables() {
        this.delete(" purchase", null, null);
        this.delete(" shopping_mall", null, null);
        this.delete(" mall_user", null, null);
        this.delete("sync_rule_malls", null, null);
        LogUtil.LOGI(TAG, "delete all data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ShoppingMallData> loadShoppingMallList() {
        ArrayList<ShoppingMallData> shoppingMallDatas = new ArrayList<ShoppingMallData>();
        String query = " SELECT  *  FROM  shopping_mall";
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    ShoppingMallData data = ShoppingMallTable.populateModel(c);
                    String userId = this.existUserInfo(data.id);
                    data.purchaseList = userId == null ? new ArrayList() : this.loadPurchaseList(data.id, userId);
                    shoppingMallDatas.add(data);
                    c.moveToNext();
                }
            }
        }
        return shoppingMallDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PurchaseData> loadPurchaseList(int mallId, String userId) {
        LogUtil.LOGI(TAG, "method : (loadPurchaseList) mallId : " + mallId + " userId : " + userId);
        ArrayList<PurchaseData> purchaseDataList = new ArrayList<PurchaseData>();
        String query = " SELECT  *  FROM  purchase WHERE mall_id = " + mallId + " AND " + "mall_user_id" + " = '" + userId + "'";
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    PurchaseData data = PurchaseTable.populateModel(c);
                    LogUtil.LOGI(TAG, "method : (loadPurchaseList) PurchaseData : " + data.toString());
                    purchaseDataList.add(data);
                    c.moveToNext();
                }
            }
        }
        return purchaseDataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String existUserInfo(int mallId) {
        String query = " SELECT  *  FROM  mall_user WHERE shopping_mall_id = " + mallId;
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null) {
                if (c.moveToFirst()) {
                    LogUtil.LOGI(TAG, "method : (existUserInfo) MallUserData : " + ShoppingMallUserInfoTable.populateModel(c).toString());
                    String string = c.getString(c.getColumnIndex("shopping_mall_user_id"));
                    return string;
                }
            } else {
                LogUtil.LOGI(TAG, "method : (existUserInfo) : no data");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MallUserData getUserData(ShoppingMallData mallData) {
        String query = " SELECT  *  FROM  mall_user WHERE shopping_mall_id = " + mallData.id;
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                MallUserData mallUserData = ShoppingMallUserInfoTable.populateModel(c);
                return mallUserData;
            }
        }
        return null;
    }

    public void updateSyncDate(int mallId) {
        ContentValues cv = new ContentValues();
        cv.put("last_sync_date", DateUtils.getTodayDate());
        String whereClause = "shopping_mall_id_pk=?";
        String[] args = new String[]{String.valueOf(mallId)};
        this.update(" shopping_mall", cv, whereClause, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirstParsing(int mallId) {
        String lastSyncDate = null;
        String query = " SELECT last_sync_date FROM  shopping_mall WHERE shopping_mall_id_pk  = " + mallId;
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                lastSyncDate = c.getString(c.getColumnIndex("last_sync_date"));
            }
        }
        return lastSyncDate == null;
    }

    public void updateMainType(int id, int mainType) {
        ContentValues values = new ContentValues();
        values.put("shopping_mall_main_type", Integer.valueOf(mainType));
        this.update(" shopping_mall", values, "shopping_mall_id_pk=?", new String[]{id + ""});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ShoppingMallData> loadMallWithMain() {
        ArrayList<ShoppingMallData> malls = new ArrayList<ShoppingMallData>();
        String query = " SELECT * FROM  shopping_mall WHERE shopping_mall_main_type= 1 ORDER BY priority ASC ";
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    malls.add(ShoppingMallTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return malls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsingRuleData getParsingRuleData(int mallId, String userId, String userPw) {
        String query = " SELECT * FROM sync_rule_malls WHERE _id=" + mallId;
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                ParsingRuleData parsingRuleData = SyncRuleMallsTable.populateModel(c, userId, userPw, this.loadLastSyncDate(mallId));
                return parsingRuleData;
            }
        }
        return null;
    }
}

