package com.tenqube.visual_scraper.utils;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/**
 * Created by tenqube on 2018. 4. 30..
 */

public class DateUtils {

    public static final DecimalFormat decimalFormat = new DecimalFormat("00");// decimalformat은
    public static final DecimalFormat firstdF = new DecimalFormat("0.#");// decimalformat은

    public static String getTodayDate() {
        Calendar cal = Calendar.getInstance();
        return getStringDateAsYYYYMMddHHmmss(cal);
    }

    public static String getStringDateAsYYYYMMddHHmmss(Calendar cal) {

        try {
            if (cal == null) cal = Calendar.getInstance();

            return cal.get(Calendar.YEAR) + "-" +
                    decimalFormat.format((cal.get(Calendar.MONTH) + 1)) + "-" +
                    decimalFormat.format(cal.get(Calendar.DATE)) + " " +
                    decimalFormat.format(cal.get(Calendar.HOUR_OF_DAY)) + ":" +
                    decimalFormat.format(cal.get(Calendar.MINUTE)) + ":" +
                    decimalFormat.format(cal.get(Calendar.SECOND));
        } catch (Exception e) {
            e.printStackTrace();
        }

        return "";
    }

    public static String convertDateFormat(String format, String oldDate) {

        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
            Date date = simpleDateFormat.parse(oldDate);
            SimpleDateFormat resultDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            return resultDateFormat.format(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return oldDate;
    }

    public static String getStartDateFormat(String format, String lastSyncDate) {
        try {

            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
            //처음 1년치
            if (lastSyncDate == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(Calendar.YEAR, -1);
                Date date = new Date();
                date.setTime(calendar.getTimeInMillis());
                return simpleDateFormat.format(date);
            } else {
                SimpleDateFormat dt = new SimpleDateFormat("yyyyy-MM-dd hh:mm:ss", Locale.getDefault());
                Date date = dt.parse(lastSyncDate);
                Calendar calendar = Calendar.getInstance();
                calendar.add(Calendar.MONTH,-1);
                date.setTime(calendar.getTimeInMillis());
                return simpleDateFormat.format(date);
            }

        } catch (ParseException e) {
            e.printStackTrace();
        }
        return getEndDateFormat(format);
    }

    public static String getParamsDate(String value, String lastSyncDate) {

        String[] valueArr = value.split(";");

        String format = "yyyy-MM-dd";

        for (String key : valueArr) {
            if (key.contains("yy")) {
                format = key;
            }
        }
        if (value.contains("start"))
            return getStartDateFormat(format, lastSyncDate);
        else if (value.contains("end"))
            return getEndDateFormat(format);
        return "";
    }

    public static String getMonthStartDateFormat(String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MONTH, -1);
        Date date = new Date();
        date.setTime(calendar.getTimeInMillis());
        return simpleDateFormat.format(date);
    }

    public static String getEndDateFormat(String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());

        return simpleDateFormat.format(new Date());
    }

}
