package com.tenqube.visual_scraper.request_interface.page;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.request_data.RequestContent;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.data.request_data.ScrapData;
import com.tenqube.visual_scraper.scraper.ScrapingOnlineMall;

import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

import static com.tenqube.visual_scraper.constants.Constants.METHOD_TYPE.GET;
import static com.tenqube.visual_scraper.constants.Constants.USER_AGENT;
import static com.tenqube.visual_scraper.utils.LogUtil.LOGI;

/**
 * Created by tenqube on 2018. 5. 18..cw.jeon
 */

public class PageParser implements PurchaseRequest {


    private PurchaseRequest.OnResponsePurchasePage mListener;
    private ParsingRuleData mParsingRuleData;


    public PageParser(OnResponsePurchasePage mListener, ParsingRuleData parsingRuleData) {
        this.mListener = mListener;
        this.mParsingRuleData = parsingRuleData;
    }


    private Connection.Response callGetRequest(String url, String cookie, Map<String, String> queryParams) {
        try {

            return Jsoup.connect(url)
                    .userAgent(USER_AGENT)
                    .followRedirects(true)
                    .data(queryParams)
                    .timeout(6000)
                    .ignoreContentType(true)
                    .header("cookie", cookie)
                    .method(Connection.Method.GET)
                    .execute();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }


    private Connection.Response callPostRequest(String url, String cookie, Map<String, String> postParams) {
        try {
            LOGI("PageParser", "REUQEST_URL" + url);
            LOGI("PageParser", "REUQEST_PARAMS" + postParams.toString());


            return Jsoup.connect(url)
                    .userAgent(USER_AGENT)
                    .followRedirects(true)
                    .timeout(6000)
                    .ignoreContentType(true)
                    .header("cookie", cookie)
                    .method(Connection.Method.POST)
                    .data(postParams)
                    .execute();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void doPurchasePageRequest(String cookie) {

        try {

            Connection.Response response;

            if (mParsingRuleData.purchaseMethodType == GET) {
                response = callGetRequest(mParsingRuleData.purchaseUrl, cookie, mParsingRuleData.purchaseParams);
                LOGI("PageParser", " get purchase BODY " + mParsingRuleData.purchaseParams.toString());

            } else {
                response = callPostRequest(mParsingRuleData.purchaseUrl, cookie, mParsingRuleData.purchaseParams);
                LOGI("PageParser", " post purchase BODY ");
            }


            if (response != null) {


                Document doc = response.parse();
                if (doc != null) {
                    RequestDocumentData requestDocumentData = new RequestDocumentData();
                    requestDocumentData.contents = new ArrayList<>();

                    RequestContent requestData = new RequestContent();
                    if (response.contentType().contains(Constants.CONTENT_TYPE.JSON_KEY)) {

                        requestData.contentType = Constants.CONTENT_TYPE.JSON;
                        requestData.content = doc.select("body").html();
                    } else {
                        requestData.contentType = Constants.CONTENT_TYPE.URL_ENCODED;

                        if (ScrapingOnlineMall.SCRAPING_DEBUG_MODE) {
                            for (Element ele : doc.select(mParsingRuleData.purchaseDivCss)) {
                                LOGI("PageParser","URL_ENCODED "+  ele.html());
                            }
                        }
                        requestData.content = doc.select(mParsingRuleData.purchaseDivCss).outerHtml();
                    }

                    requestDocumentData.contents.add(requestData);

                    requestDocumentData.name = mParsingRuleData.name;
                    requestDocumentData.parsingType = Constants.SCRAP_TYPE.PURCHASE;


                    LOGI("PageParser", " call URl " + response.url());

                    LOGI("PageParser", "purchase BODY ," + requestData.toString());

                    mListener.onPurchasePageResult(requestDocumentData);
                }else {
                    mListener.onParsingFail("request document null");
                }
            } else {
                mListener.onParsingFail("request response null");
            }


        } catch (IOException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        }

    }

    @Override
    public void doDetailPurchasePageRequest(String cookie, ArrayList<ScrapData> detailScrapData) {

        Connection.Response response;
        Document detailPage;
        RequestDocumentData requestData = new RequestDocumentData();
        requestData.contents = new ArrayList<>();
        try {
            for (ScrapData scrapData : detailScrapData) {

                if (scrapData.methodType == Constants.METHOD_TYPE.GET)
                    response = callGetRequest(scrapData.url, cookie, scrapData.params);
                else
                    response = callPostRequest(scrapData.url, cookie, scrapData.params);

                if (response != null) {
                    RequestContent requestContent = new RequestContent();
                    detailPage = response.parse();
                    requestContent.contentType = response.contentType().contains(Constants.CONTENT_TYPE.JSON_KEY) ?
                            Constants.CONTENT_TYPE.JSON :
                            Constants.CONTENT_TYPE.URL_ENCODED;
                    requestData.name = scrapData.name;
                    requestData.parsingType = Constants.SCRAP_TYPE.DETAIL_PURCHASE;

                    if (detailPage != null) {
                        requestContent.content = detailPage.select(scrapData.divCss).html();
                        LOGI("PageParser", "purchase BODY ," + requestData.toString());
                        requestData.contents.add(requestContent);
                    }

                }

            }
            if (requestData.contents.size() > 0)
                mListener.onDetailPurchasePageResult(requestData);
            else {
                mListener.onParsingFail("Fail detail scraping");
            }

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void callParsingPurchase(ArrayList<ScrapData> detailScrapDatas) {

    }


}
