package com.tenqube.visual_scraper.db.table;

import android.content.ContentValues;
import android.database.Cursor;
import android.provider.BaseColumns;

import com.tenqube.visual_scraper.data.ShoppingMallData;

/**
 * Created by tenqube on 2018. 4. 26..
 */


public class ShoppingMallTable extends AbstractTable implements BaseColumns {

    public static final String TABLE_NAME = " shopping_mall";
    public static final String ALIAS = " shopping_mall.";
    public static final String AS_ALIAS = " AS shpping_mall ";



    //purchase
    public static final String COLUMN_MALL_ID = "shopping_mall_id_pk";
    public static final String COLUMN_MALL_NAME = "mall_name";
    public static final String COLUMN_MALL_ICON_URL = "mall_icon_url";
    public static final String COLUMN_MAIN_TYPE = "shopping_mall_main_type";
    public static final String COLUMN_PRIORITY = "priority";
    public static final String COLUMN_LAST_SYNC_DATE = "last_sync_date";


    public static final String SQL_CREATE_TABLE =
            CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME + " (" +
                    COLUMN_MALL_ID + INTEGER_TYPE + PRIMARY_KEY + COMMA_SEP +
                    COLUMN_MALL_NAME + TEXT_TYPE + NOT_NULL + COMMA_SEP +
                    COLUMN_MALL_ICON_URL + TEXT_TYPE  + COMMA_SEP +
                    COLUMN_MAIN_TYPE + INTEGER_TYPE  + DEFAULT + DEFAULT_INT + COMMA_SEP +
                    COLUMN_PRIORITY + INTEGER_TYPE  + DEFAULT + DEFAULT_INT + COMMA_SEP +
                    COLUMN_LAST_SYNC_DATE + DATE_TYPE   +COMMA_SEP+
                    " FOREIGN KEY(" + COLUMN_MALL_NAME + ") REFERENCES " +
                    SyncRuleMallsTable.TABLE_NAME + "(" + SyncRuleMallsTable.COLUMN_MALL_NAME +
                    ") ON DELETE CASCADE" + COMMA_SEP +
                    UNIQUE + "("  + COLUMN_MALL_NAME + ")" + " )";

    public static final String indexing = "CREATE INDEX qlip_shopping_mall_idx ON " + TABLE_NAME + " (" + COLUMN_MALL_NAME + " , " + COLUMN_MALL_ID + ")";

    public static final String SQL_DELETE_ENTRIES =
            DROP_TABLE_IF_EXISTS + TABLE_NAME;


    /**
     * @param c cursor
     * @return ShoppingMallData
     */
    public static ShoppingMallData populateModel(Cursor c) {
        ShoppingMallData model = new ShoppingMallData();
        model.id = c.getInt(c.getColumnIndex(COLUMN_MALL_ID));
        model.mallName = c.getString(c.getColumnIndex(COLUMN_MALL_NAME));
        model.priority = c.getInt(c.getColumnIndex(COLUMN_PRIORITY));
        model.mainType = c.getInt(c.getColumnIndex(COLUMN_MAIN_TYPE));
        model.lastSyncDate = c.getString(c.getColumnIndex(COLUMN_LAST_SYNC_DATE));
        return model;
    }

    public static ContentValues populateContent(ShoppingMallData model) {
        ContentValues values = new ContentValues();
        values.put(COLUMN_MALL_NAME, model.mallName);
        values.put(COLUMN_MAIN_TYPE, model.mainType);
        values.put(COLUMN_PRIORITY, model.priority);

        return values;
    }

    public static final String INSERT_INIT = "INSERT OR REPLACE INTO " + ShoppingMallTable.TABLE_NAME +
            "(" + ShoppingMallTable.COLUMN_MALL_NAME + "," + ShoppingMallTable.COLUMN_MALL_ID + ") VALUES ";

}