package com.tenqube.visual_scraper.db.scraper_dao;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;

import com.tenqube.visual_scraper.data.MallUserData;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.PurchaseData;
import com.tenqube.visual_scraper.data.ShoppingMallData;
import com.tenqube.visual_scraper.data.dto_data.DtoRuleData;
import com.tenqube.visual_scraper.db.table.PurchaseTable;
import com.tenqube.visual_scraper.db.table.ShoppingMallTable;
import com.tenqube.visual_scraper.db.table.ShoppingMallUserInfoTable;
import com.tenqube.visual_scraper.db.table.SyncRuleMallsTable;
import com.tenqube.visual_scraper.utils.DateUtils;
import com.tenqube.visual_scraper.utils.LogUtil;

import java.util.ArrayList;

import static com.tenqube.visual_scraper.utils.LogUtil.LOGI;


public class OnlineMallDao extends QueryDao {

    private static OnlineMallDao mInstance = null;
    private Context mContext;
    private static final String TAG = LogUtil.makeLogTag(OnlineMallDao.class);

    public static OnlineMallDao getInstance(Context ctx) {

        synchronized (OnlineMallDao.class) {
            if (mInstance == null) {
                mInstance = new OnlineMallDao(ctx.getApplicationContext());

            }
        }
        return mInstance;
    }


    private OnlineMallDao(Context context) {
        super(context);
        this.mContext = context;
    }

    public void syncParsingRule(DtoRuleData dtoRuleData) {
        LOGI(TAG, "ParsingRule data insert start...");

        if (dtoRuleData.onlineMalls.size() > 0) {

            for (DtoRuleData.OnlineMall parsingRuleData : dtoRuleData.onlineMalls) {
                LOGI(TAG, "insert :" + parsingRuleData.displayName);


                insertOnReplace(SyncRuleMallsTable.TABLE_NAME, SyncRuleMallsTable.populateContent(parsingRuleData));
                ContentValues mallContentValue = new ContentValues();
                mallContentValue.put(ShoppingMallTable.COLUMN_MALL_NAME, parsingRuleData.name);
                mallContentValue.put(ShoppingMallTable.COLUMN_MALL_ICON_URL, parsingRuleData.iconUrl);
                insertOnIgnore(ShoppingMallTable.TABLE_NAME, mallContentValue);


            }

        }
    }

    public String loadLastSyncDate(int mallId) {
        String query = SELECT + " * " + FROM + ShoppingMallTable.TABLE_NAME + WHERE + ShoppingMallTable.COLUMN_MALL_ID + " = " + mallId;
        Cursor c = null;
        try {
            c = runQuery(query);

            if (c != null) {

                if (c.moveToFirst()) {
                    LOGI(TAG, "loadLastSyncDate : " + c.getString(c.getColumnIndex(ShoppingMallTable.COLUMN_LAST_SYNC_DATE)));
                    return c.getString(c.getColumnIndex(ShoppingMallTable.COLUMN_LAST_SYNC_DATE));
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (c != null)
                c.close();
        }
        return null;
    }

    public void insertPurchaseData(PurchaseData purchaseData) {

        insertOnReplace(PurchaseTable.TABLE_NAME, PurchaseTable.populateContent(purchaseData));
        updateSyncDate(purchaseData.shopping_mall_id);
    }

    public void bulkInsertPurchaseData(ArrayList<PurchaseData> purchaseDataArrayList) {

        for (PurchaseData purchaseData : purchaseDataArrayList) {
            insertPurchaseData(purchaseData);
        }
    }


    public void loadParsingRule() {

        String query =
                SELECT + " * " +
                        FROM + SyncRuleMallsTable.TABLE_NAME;
        Cursor c = null;
        try {
            c = runQuery(query);

            if (c != null) {

                if (c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        LOGI(TAG, c.getString(c.getColumnIndex(SyncRuleMallsTable.COLUMN_MALL_NAME)));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (c != null)
                c.close();
        }
    }

    public void resetTables() {
        delete(PurchaseTable.TABLE_NAME, null, null);
        delete(ShoppingMallTable.TABLE_NAME, null, null);
        delete(ShoppingMallUserInfoTable.TABLE_NAME, null, null);
        delete(SyncRuleMallsTable.TABLE_NAME, null, null);
        LOGI(TAG, "delete all data");

    }

    public ArrayList<ShoppingMallData> loadShoppingMallList() {

        ArrayList<ShoppingMallData> shoppingMallDatas = new ArrayList<>();
        String query =
                SELECT + " * " +
                        FROM + ShoppingMallTable.TABLE_NAME;
        Cursor c = null;
        try {
            c = runQuery(query);

            if (c != null) {

                if (c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        ShoppingMallData data = ShoppingMallTable.populateModel(c);

                        String userId = existUserInfo(data.id);

                        data.purchaseList = userId == null ?
                                new ArrayList<PurchaseData>() :
                                loadPurchaseList(data.id, userId);

                        shoppingMallDatas.add(data);
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (c != null)
                c.close();
        }
        return shoppingMallDatas;
    }


    public ArrayList<PurchaseData> loadPurchaseList(int mallId, String userId) {

        LOGI(TAG, "method : (loadPurchaseList) mallId : " + mallId + " userId : " + userId);

        ArrayList<PurchaseData> purchaseDataList = new ArrayList<>();
        String query =
                SELECT + " * " +
                        FROM + PurchaseTable.TABLE_NAME +
                        WHERE + PurchaseTable.COLUMN_SHOPPING_MALL_ID + " = " + mallId +
                        AND + PurchaseTable.COLUMN_MALL_USER_ID + " = '" + userId + "'";
        Cursor c = null;
        try {
            c = runQuery(query);

            if (c != null) {

                if (c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        PurchaseData data = PurchaseTable.populateModel(c);
                        LOGI(TAG, "method : (loadPurchaseList) PurchaseData : " + data.toString());

                        purchaseDataList.add(data);
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (c != null)
                c.close();
        }

        return purchaseDataList;
    }

    public String existUserInfo(int mallId) {


        String query =
                SELECT + " * " +
                        FROM + ShoppingMallUserInfoTable.TABLE_NAME +
                        WHERE + ShoppingMallUserInfoTable.COLUMN_MALL_ID + " = " + mallId;

        Cursor c = null;
        try {
            c = runQuery(query);

            if (c != null) {

                if (c.moveToFirst()) {
                    LOGI(TAG, "method : (existUserInfo) MallUserData : " + ShoppingMallUserInfoTable.populateModel(c).toString());
                    return c.getString(c.getColumnIndex(ShoppingMallUserInfoTable.COLUMN_MALL_USER_ID));
                }
            } else {

                LOGI(TAG, "method : (existUserInfo) : no data");
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (c != null)
                c.close();
        }
        return null;

    }

    public MallUserData getUserData(ShoppingMallData mallData) {


        String query =
                SELECT + " * " +
                        FROM + ShoppingMallUserInfoTable.TABLE_NAME +
                        WHERE + ShoppingMallUserInfoTable.COLUMN_MALL_ID + " = " + mallData.id;

        Cursor c = null;
        try {
            c = runQuery(query);

            if (c != null) {

                if (c.moveToFirst()) {
                    return ShoppingMallUserInfoTable.populateModel(c);
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (c != null)
                c.close();
        }
        return null;

    }

    public void updateSyncDate(int mallId) {
        ContentValues cv = new ContentValues();
        cv.put(ShoppingMallTable.COLUMN_LAST_SYNC_DATE, DateUtils.getTodayDate());
        String whereClause = ShoppingMallTable.COLUMN_MALL_ID + "=?";
        String args[] = {String.valueOf(mallId)};
        update(ShoppingMallTable.TABLE_NAME, cv, whereClause, args);
    }

    public boolean isFirstParsing (int mallId){
        String lastSyncDate = null;
        String query  = SELECT+ ShoppingMallTable.COLUMN_LAST_SYNC_DATE + FROM + ShoppingMallTable.TABLE_NAME+ WHERE+ShoppingMallTable.COLUMN_MALL_ID +"  = "+ mallId;
        Cursor c = null;
        try{
            c = runQuery(query);
            if (c!=null){
                if (c.moveToFirst()){
                    lastSyncDate = c.getString(c.getColumnIndex(ShoppingMallTable.COLUMN_LAST_SYNC_DATE));
                }
            }
        }catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (c != null)
                c.close();
        }

        return lastSyncDate == null;
    }


    public void updateMainType(int id, int mainType) {
        ContentValues values = new ContentValues();
        values.put(ShoppingMallTable.COLUMN_MAIN_TYPE, mainType);
        update(ShoppingMallTable.TABLE_NAME, values, ShoppingMallTable.COLUMN_MALL_ID + "=?", new String[]{id + ""});
    }

    public ArrayList<ShoppingMallData> loadMallWithMain() {

        ArrayList<ShoppingMallData> malls = new ArrayList<>();
        Cursor c = null;

        String query =
                SELECT + "*" +
                        FROM + ShoppingMallTable.TABLE_NAME +
                        WHERE + ShoppingMallTable.COLUMN_MAIN_TYPE + "= 1" +
                        ORDER_BY + ShoppingMallTable.COLUMN_PRIORITY + ASC;

        try {

            c = runQuery(query);

            if (c != null) {
                if (c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        malls.add(ShoppingMallTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }

        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (c != null)
                c.close();
        }

        return malls;
    }


    public ParsingRuleData getParsingRuleData(int mallId, String userId, String userPw) {
        Cursor c = null;

        String query =
                SELECT + "*" +
                        FROM + SyncRuleMallsTable.TABLE_NAME +
                        WHERE + SyncRuleMallsTable.COLUMN_MALL_ID + "=" + mallId;


        try {

            c = runQuery(query);

            if (c != null) {
                if (c.moveToFirst()) {

                    return SyncRuleMallsTable.populateModel(c, userId, userPw,loadLastSyncDate(mallId));
                }
            }

        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (c != null)
                c.close();
        }

        return null;

    }
}
