/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.ibkreceipt.di;

import android.content.Context;
import android.content.pm.PackageManager;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.ViewModelProvider;
import com.tenqube.ibkreceipt.IBKSharedPreference;
import com.tenqube.ibkreceipt.VisualReceiptViewModel;
import com.tenqube.ibkreceipt.di.IBKServiceLocator;
import com.tenqube.shared.prefs.PrefStorage;
import com.tenqube.shared.prefs.SharedPreferenceStorage;
import com.tenqube.visualbase.domain.auth.AuthService;
import com.tenqube.visualbase.domain.card.CardRepository;
import com.tenqube.visualbase.domain.category.CategoryRepository;
import com.tenqube.visualbase.domain.currency.CurrencyService;
import com.tenqube.visualbase.domain.notification.NotificationService;
import com.tenqube.visualbase.domain.transaction.TransactionRepository;
import com.tenqube.visualbase.domain.user.UserRepository;
import com.tenqube.visualbase.domain.usercategoryconfig.UserCategoryConfigRepository;
import com.tenqube.visualbase.infrastructure.adapter.auth.AuthServiceImpl;
import com.tenqube.visualbase.infrastructure.adapter.auth.remote.AuthApi;
import com.tenqube.visualbase.infrastructure.adapter.auth.remote.AuthRemoteDataSource;
import com.tenqube.visualbase.infrastructure.adapter.currency.CurrencyServiceImpl;
import com.tenqube.visualbase.infrastructure.adapter.currency.remote.CurrencyApiService;
import com.tenqube.visualbase.infrastructure.adapter.currency.remote.CurrencyRemoteDataSource;
import com.tenqube.visualbase.infrastructure.adapter.notification.NotificationServiceImpl;
import com.tenqube.visualbase.infrastructure.adapter.notification.local.NotificationAppLocalDataSource;
import com.tenqube.visualbase.infrastructure.data.card.CardRepositoryImpl;
import com.tenqube.visualbase.infrastructure.data.card.local.CardDao;
import com.tenqube.visualbase.infrastructure.data.category.CategoryRepositoryImpl;
import com.tenqube.visualbase.infrastructure.data.category.local.CategoryDao;
import com.tenqube.visualbase.infrastructure.data.transaction.TransactionRepositoryImpl;
import com.tenqube.visualbase.infrastructure.data.transaction.local.TransactionDao;
import com.tenqube.visualbase.infrastructure.data.transaction.remote.TransactionApiService;
import com.tenqube.visualbase.infrastructure.data.transaction.remote.TransactionRemoteDataSource;
import com.tenqube.visualbase.infrastructure.data.user.UserRepositoryImpl;
import com.tenqube.visualbase.infrastructure.data.user.local.UserDao;
import com.tenqube.visualbase.infrastructure.data.usercategoryconfig.UserCategoryConfigRepositoryImpl;
import com.tenqube.visualbase.infrastructure.data.usercategoryconfig.local.UserCategoryConfigDao;
import com.tenqube.visualbase.infrastructure.framework.db.VisualDatabase;
import com.tenqube.visualbase.infrastructure.framework.di.ServiceLocator;
import com.tenqube.visualbase.service.parser.ParserAppService;
import com.tenqube.visualbase.service.transaction.TransactionAppService;
import com.tenqube.visualbase.service.user.UserAppService;
import com.tenqube.webui.UIService;
import com.tenqube.webui.UIServiceBuilder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.Retrofit;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/tenqube/ibkreceipt/di/IBKServiceLocator;", "", "()V", "provideVisualViewModel", "Landroidx/lifecycle/ViewModelProvider$Factory;", "context", "Landroidx/appcompat/app/AppCompatActivity;", "ibkreceipt_release"})
public final class IBKServiceLocator {
    @NotNull
    public static final IBKServiceLocator INSTANCE = new IBKServiceLocator();

    private IBKServiceLocator() {
    }

    @NotNull
    public final ViewModelProvider.Factory provideVisualViewModel(@NotNull AppCompatActivity context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OkHttpClient okHttpClient = ServiceLocator.INSTANCE.provideOkHttpClient();
        Retrofit retrofit = ServiceLocator.INSTANCE.provideRetrofit(okHttpClient);
        SharedPreferenceStorage prefStorage = new SharedPreferenceStorage((Context)context);
        VisualDatabase db = ServiceLocator.INSTANCE.provideVisualDatabase((Context)context);
        UserDao userDao = ServiceLocator.INSTANCE.provideUserDao(db);
        CardDao cardDao = ServiceLocator.INSTANCE.provideCardDao(db);
        CategoryDao categoryDao = ServiceLocator.INSTANCE.provideCategoryDao(db);
        TransactionDao transactionDao = ServiceLocator.INSTANCE.provideTransactionDao(db);
        UserCategoryConfigDao userCategoryConfigDao = ServiceLocator.INSTANCE.provideUserCategoryConfigDao(db);
        UserRepositoryImpl userRepository = new UserRepositoryImpl(userDao);
        CardRepositoryImpl cardRepository = new CardRepositoryImpl(cardDao);
        CategoryRepositoryImpl categoryRepository = new CategoryRepositoryImpl(categoryDao);
        TransactionApiService transactionApi = (TransactionApiService)retrofit.create(TransactionApiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)transactionApi, (String)"transactionApi");
        TransactionRemoteDataSource transactionRemoteDataSource = new TransactionRemoteDataSource(transactionApi, (PrefStorage)prefStorage, null, 4, null);
        TransactionRepositoryImpl transactionRepository = new TransactionRepositoryImpl(transactionDao, transactionRemoteDataSource);
        UserCategoryConfigRepositoryImpl userCategoryRepository = new UserCategoryConfigRepositoryImpl(userCategoryConfigDao);
        UIService uiService2 = new UIServiceBuilder().activity(context).refreshCallback((Function1)provideVisualViewModel.uiService.1.INSTANCE).build();
        TransactionRepository transactionRepository2 = (TransactionRepository)transactionRepository;
        CardRepository cardRepository2 = (CardRepository)cardRepository;
        CategoryRepository categoryRepository2 = (CategoryRepository)categoryRepository;
        UserCategoryConfigRepository userCategoryConfigRepository = (UserCategoryConfigRepository)userCategoryRepository;
        PackageManager packageManager = context.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"context.packageManager");
        TransactionAppService transactionAppService = ServiceLocator.INSTANCE.provideTransactionAppService(transactionRepository2, cardRepository2, categoryRepository2, userCategoryConfigRepository, packageManager);
        AuthApi authApi = (AuthApi)retrofit.create(AuthApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)authApi, (String)"authApi");
        AuthRemoteDataSource authRemote = new AuthRemoteDataSource(authApi, (PrefStorage)prefStorage, null, 4, null);
        AuthServiceImpl authService = new AuthServiceImpl(authRemote, (UserRepository)userRepository, (TransactionRepository)transactionRepository, (CardRepository)cardRepository, (CategoryRepository)categoryRepository, (UserCategoryConfigRepository)userCategoryRepository);
        NotificationAppLocalDataSource notificationAppLocalDataSource = new NotificationAppLocalDataSource((Context)context, null, 2, null);
        NotificationServiceImpl notificationService = new NotificationServiceImpl((Context)context, (PrefStorage)prefStorage, notificationAppLocalDataSource);
        CurrencyApiService currencyApi = (CurrencyApiService)retrofit.create(CurrencyApiService.class);
        Context context2 = (Context)context;
        Intrinsics.checkNotNullExpressionValue((Object)currencyApi, (String)"currencyApi");
        CurrencyServiceImpl currencyService = new CurrencyServiceImpl(context2, new CurrencyRemoteDataSource(currencyApi, (PrefStorage)prefStorage, null, 4, null), ServiceLocator.INSTANCE.provideCurrencyDao(db));
        UserAppService userAppService = ServiceLocator.INSTANCE.provideUserAppService((Context)context, (AuthService)authService, (UserRepository)userRepository, (CategoryRepository)categoryRepository, (UserCategoryConfigRepository)userCategoryRepository, (CardRepository)cardRepository, (CurrencyService)currencyService, (PrefStorage)prefStorage, (NotificationService)notificationService);
        ParserAppService parserAppService = ServiceLocator.INSTANCE.provideParserAppService((Context)context, userAppService, transactionAppService, (PrefStorage)prefStorage, retrofit);
        return new VisualReceiptViewModel.Factory(userAppService, transactionAppService, uiService2, ServiceLocator.INSTANCE.provideBulkParserAppService(parserAppService), new IBKSharedPreference((Context)context), (PrefStorage)prefStorage);
    }
}

