/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.ibkreceipt;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.activity.OnBackPressedCallback;
import androidx.appcompat.app.AppCompatActivity;
import androidx.cardview.widget.CardView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.tenqube.ibkreceipt.PermissionUtil;
import com.tenqube.ibkreceipt.R;
import com.tenqube.ibkreceipt.VisualBaseActivity;
import com.tenqube.ibkreceipt.VisualIBKArg;
import com.tenqube.ibkreceipt.VisualReceiptSharedViewModel;
import com.tenqube.ibkreceipt.VisualReceiptViewModel;
import com.tenqube.ibkreceipt.bridge.AndroidUIBridge;
import com.tenqube.ibkreceipt.di.IBKServiceLocator;
import com.tenqube.ibkreceipt.progress.ProgressCount;
import com.tenqube.shared.util.Utils;
import com.tenqube.shared.webview.WebViewCallback;
import com.tenqube.shared.webview.WebViewManager;
import com.tenqube.shared.webview.WebViewParam;
import com.tenqube.visualbase.domain.user.command.CreateUser;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 E2\u00020\u0001:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001aH\u0002J\"\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J&\u0010'\u001a\u0004\u0018\u00010\u001d2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u0010.\u001a\u00020\u001aH\u0016J\b\u0010/\u001a\u00020\u001aH\u0016J\b\u00100\u001a\u00020\u001aH\u0016J\u001a\u00101\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\n\u00102\u001a\u0004\u0018\u000103H\u0002J\u0010\u00104\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\b\u00105\u001a\u00020\u001aH\u0002J\b\u00106\u001a\u00020\u001aH\u0002J\b\u00107\u001a\u00020\u001aH\u0002J\b\u00108\u001a\u00020\u001aH\u0002J\b\u00109\u001a\u00020\u001aH\u0002J\b\u0010:\u001a\u00020\u001aH\u0002J\b\u0010;\u001a\u00020\fH\u0002J\b\u0010<\u001a\u00020\u001aH\u0002J\b\u0010=\u001a\u00020\u001aH\u0002J\u0010\u0010>\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020\u001fH\u0002J\b\u0010@\u001a\u00020\u001aH\u0002J\u0012\u0010A\u001a\u00020\u001a2\b\u0010B\u001a\u0004\u0018\u00010CH\u0002J\b\u0010D\u001a\u00020\u001aH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/tenqube/ibkreceipt/VisualReceiptFragment;", "Landroidx/fragment/app/Fragment;", "()V", "adContainer", "Landroidx/cardview/widget/CardView;", "errorButton", "Landroid/widget/Button;", "errorContainer", "Landroid/widget/LinearLayout;", "errorTextView", "Landroid/widget/TextView;", "isBulk", "", "sharedViewModel", "Lcom/tenqube/ibkreceipt/VisualReceiptSharedViewModel;", "swipeRefreshLayout", "Landroidx/swiperefreshlayout/widget/SwipeRefreshLayout;", "viewModel", "Lcom/tenqube/ibkreceipt/VisualReceiptViewModel;", "webContainer", "Landroid/widget/FrameLayout;", "webView", "Landroid/webkit/WebView;", "webViewManager", "Lcom/tenqube/shared/webview/WebViewManager;", "closeProgress", "", "createCardView", "view", "Landroid/view/View;", "getUrl", "", "hideAd", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreateView", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onPause", "onResume", "onViewCreated", "parseArg", "Lcom/tenqube/ibkreceipt/VisualIBKArg;", "setupBridges", "setupErrorView", "setupEvents", "setupOnBackPressedDispatcher", "setupProgressEvents", "setupSwipeRefreshView", "setupWebView", "shouldRequestOverlayPermission", "showProgress", "start", "startByUrl", "url", "startByVisualUrl", "startOnInit", "user", "Lcom/tenqube/visualbase/domain/user/command/CreateUser;", "startVisual", "Companion", "ibkreceipt_release"})
public final class VisualReceiptFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private VisualReceiptViewModel viewModel;
    private VisualReceiptSharedViewModel sharedViewModel;
    private WebViewManager webViewManager;
    @Nullable
    private CardView adContainer;
    private WebView webView;
    private FrameLayout webContainer;
    private SwipeRefreshLayout swipeRefreshLayout;
    private LinearLayout errorContainer;
    private Button errorButton;
    private TextView errorTextView;
    private boolean isBulk;
    @NotNull
    public static final String URL = "%s?v=1.1&dv=1.0";
    @NotNull
    public static final String PROGRESS_URL = "loading#type=bulk";
    @NotNull
    public static final String VISUAL_IBK_ARG = "visual_ibk_arg";
    public static final int REQ_CODE_OVERLAY_PERMISSION = 10;
    public static final int REQ_CODE_NOTI_SETTINGS = 100;

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        ViewModel viewModel = new ViewModelProvider((ViewModelStoreOwner)this.requireActivity(), IBKServiceLocator.INSTANCE.provideVisualViewModel((AppCompatActivity)this.requireActivity())).get(VisualReceiptViewModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)viewModel, (String)"ViewModelProvider(\n     \u2026iptViewModel::class.java]");
        this.viewModel = (VisualReceiptViewModel)viewModel;
        ViewModel viewModel2 = new ViewModelProvider((ViewModelStoreOwner)this.requireActivity()).get(VisualReceiptSharedViewModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)viewModel2, (String)"ViewModelProvider(\n     \u2026redViewModel::class.java]");
        this.sharedViewModel = (VisualReceiptSharedViewModel)viewModel2;
        View view = inflater.inflate(R.layout.fragment_main_ibk, container, false);
        View view2 = view.findViewById(R.id.webView);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.findViewById(R.id.webView)");
        this.webView = (WebView)view2;
        View view3 = view.findViewById(R.id.container);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view.findViewById(R.id.container)");
        this.webContainer = (FrameLayout)view3;
        View view4 = view.findViewById(R.id.swipe_refresh_layout);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"view.findViewById(R.id.swipe_refresh_layout)");
        this.swipeRefreshLayout = (SwipeRefreshLayout)view4;
        View view5 = view.findViewById(R.id.error_container);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"view.findViewById(R.id.error_container)");
        this.errorContainer = (LinearLayout)view5;
        View view6 = view.findViewById(R.id.retry);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"view.findViewById(R.id.retry)");
        this.errorButton = (Button)view6;
        View view7 = view.findViewById(R.id.error_msg);
        Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"view.findViewById(R.id.error_msg)");
        this.errorTextView = (TextView)view7;
        return view;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.setupOnBackPressedDispatcher();
        this.setupSwipeRefreshView();
        this.setupWebView();
        this.setupProgressEvents();
        this.setupEvents();
        this.setupErrorView();
        this.start();
    }

    private final void start() {
        block9: {
            Unit unit;
            VisualIBKArg visualIBKArg = this.parseArg();
            if (visualIBKArg != null) {
                VisualIBKArg it = visualIBKArg;
                boolean bl = false;
                if (it.getPath() != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    VisualReceiptViewModel visualReceiptViewModel = this.viewModel;
                    if (visualReceiptViewModel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                        visualReceiptViewModel = null;
                    }
                    this.startByUrl(stringBuilder.append(visualReceiptViewModel.getUrl()).append(it.getPath()).toString());
                } else if (it.getRemoteUrl() != null) {
                    this.startByUrl(String.valueOf(it.getRemoteUrl()));
                } else if (it.getUser() != null) {
                    this.startOnInit(it.getUser());
                } else {
                    this.startByVisualUrl();
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block9;
            this.startByVisualUrl();
        }
    }

    private final void startByVisualUrl() {
        this.showProgress();
        VisualReceiptViewModel visualReceiptViewModel = this.viewModel;
        if (visualReceiptViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel = null;
        }
        visualReceiptViewModel.start(this.getUrl());
    }

    private final void startOnInit(CreateUser user) {
        this.showProgress();
        WebViewManager webViewManager = this.webViewManager;
        if (webViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webViewManager");
            webViewManager = null;
        }
        webViewManager.setClearHistory(true);
        VisualReceiptViewModel visualReceiptViewModel = this.viewModel;
        if (visualReceiptViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel = null;
        }
        visualReceiptViewModel.start(this.getUrl(), user);
    }

    private final String getUrl() {
        String string = URL;
        Object[] objectArray = new Object[1];
        VisualReceiptViewModel visualReceiptViewModel = this.viewModel;
        if (visualReceiptViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel = null;
        }
        objectArray[0] = visualReceiptViewModel.getUrl();
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private final void startVisual() {
        if (this.shouldRequestOverlayPermission()) {
            this.showProgress();
            StringBuilder stringBuilder = new StringBuilder();
            VisualReceiptViewModel visualReceiptViewModel = this.viewModel;
            if (visualReceiptViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                visualReceiptViewModel = null;
            }
            this.startByUrl(stringBuilder.append(visualReceiptViewModel.getUrl()).append("permission").toString());
        } else {
            this.startByVisualUrl();
        }
    }

    private final void startByUrl(String url) {
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.setBackgroundColor(0);
        FrameLayout frameLayout = this.webContainer;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webContainer");
            frameLayout = null;
        }
        frameLayout.setBackgroundColor(0);
        VisualReceiptViewModel visualReceiptViewModel = this.viewModel;
        if (visualReceiptViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel = null;
        }
        visualReceiptViewModel.start(url);
    }

    private final void setupSwipeRefreshView() {
        SwipeRefreshLayout swipeRefreshLayout = this.swipeRefreshLayout;
        if (swipeRefreshLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"swipeRefreshLayout");
            swipeRefreshLayout = null;
        }
        SwipeRefreshLayout $this$setupSwipeRefreshView_u24lambda_u2d2 = swipeRefreshLayout;
        boolean bl = false;
        $this$setupSwipeRefreshView_u24lambda_u2d2.setEnabled(false);
        $this$setupSwipeRefreshView_u24lambda_u2d2.setOnRefreshListener(() -> VisualReceiptFragment.setupSwipeRefreshView$lambda-2$lambda-1($this$setupSwipeRefreshView_u24lambda_u2d2, this));
    }

    private final void setupEvents() {
        VisualReceiptViewModel visualReceiptViewModel = this.viewModel;
        if (visualReceiptViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel = null;
        }
        visualReceiptViewModel.getStartVisual().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupEvents$lambda-3(this, arg_0));
        VisualReceiptViewModel visualReceiptViewModel2 = this.viewModel;
        if (visualReceiptViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel2 = null;
        }
        visualReceiptViewModel2.getUrl().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupEvents$lambda-4(this, arg_0));
        VisualReceiptViewModel visualReceiptViewModel3 = this.viewModel;
        if (visualReceiptViewModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel3 = null;
        }
        visualReceiptViewModel3.getShowAd().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupEvents$lambda-7(this, arg_0));
        VisualReceiptViewModel visualReceiptViewModel4 = this.viewModel;
        if (visualReceiptViewModel4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel4 = null;
        }
        visualReceiptViewModel4.getHideAd().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupEvents$lambda-8(this, arg_0));
        VisualReceiptViewModel visualReceiptViewModel5 = this.viewModel;
        if (visualReceiptViewModel5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel5 = null;
        }
        visualReceiptViewModel5.getRefreshEnabled().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupEvents$lambda-9(this, arg_0));
        VisualReceiptViewModel visualReceiptViewModel6 = this.viewModel;
        if (visualReceiptViewModel6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel6 = null;
        }
        visualReceiptViewModel6.getError().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupEvents$lambda-10(this, arg_0));
        VisualReceiptViewModel visualReceiptViewModel7 = this.viewModel;
        if (visualReceiptViewModel7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel7 = null;
        }
        visualReceiptViewModel7.getOpenPermission().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupEvents$lambda-11(this, arg_0));
        VisualReceiptViewModel visualReceiptViewModel8 = this.viewModel;
        if (visualReceiptViewModel8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel8 = null;
        }
        visualReceiptViewModel8.getOnPageLoaded().observe(this.getViewLifecycleOwner(), VisualReceiptFragment::setupEvents$lambda-12);
        VisualReceiptViewModel visualReceiptViewModel9 = this.viewModel;
        if (visualReceiptViewModel9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel9 = null;
        }
        visualReceiptViewModel9.getProgress().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupEvents$lambda-13(this, arg_0));
        VisualReceiptSharedViewModel visualReceiptSharedViewModel = this.sharedViewModel;
        if (visualReceiptSharedViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedViewModel");
            visualReceiptSharedViewModel = null;
        }
        visualReceiptSharedViewModel.getReload().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupEvents$lambda-14(this, arg_0));
    }

    private final void hideAd() {
        CardView it = this.adContainer;
        boolean bl = false;
        FrameLayout frameLayout = this.webContainer;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webContainer");
            frameLayout = null;
        }
        frameLayout.removeView((View)it);
        this.adContainer = null;
    }

    private final void setupErrorView() {
        Button button = this.errorButton;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorButton");
            button = null;
        }
        button.setOnClickListener(arg_0 -> VisualReceiptFragment.setupErrorView$lambda-16(this, arg_0));
    }

    private final CardView createCardView(View view) {
        try {
            if (this.isAdded() && this.getActivity() != null && this.adContainer == null) {
                String string;
                WebView webView = this.webView;
                if (webView == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                    webView = null;
                }
                String string2 = string = webView.getUrl();
                boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"receipt", (boolean)false, (int)2, null) : false;
                if (bl) {
                    this.adContainer = new CardView(this.requireContext());
                    String $this$createCardView_u24lambda_u2d17 = string = new CardView(this.requireContext());
                    boolean bl2 = false;
                    FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
                    params.setMargins(Utils.INSTANCE.dpToPx(16), Utils.INSTANCE.dpToPx(16), Utils.INSTANCE.dpToPx(16), Utils.INSTANCE.dpToPx(16));
                    params.gravity = 80;
                    $this$createCardView_u24lambda_u2d17.setLayoutParams((ViewGroup.LayoutParams)params);
                    $this$createCardView_u24lambda_u2d17.setRadius((float)Utils.INSTANCE.dpToPx(13));
                    $this$createCardView_u24lambda_u2d17.setCardBackgroundColor(Color.parseColor((String)"#00000000"));
                    $this$createCardView_u24lambda_u2d17.removeAllViews();
                    $this$createCardView_u24lambda_u2d17.addView(view);
                    this.adContainer = $this$createCardView_u24lambda_u2d17;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.adContainer;
    }

    private final VisualIBKArg parseArg() {
        VisualIBKArg visualIBKArg;
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            Bundle it = bundle;
            boolean bl = false;
            Serializable serializable = it.getSerializable(VISUAL_IBK_ARG);
            if (serializable == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.tenqube.ibkreceipt.VisualIBKArg");
            }
            visualIBKArg = (VisualIBKArg)serializable;
        } else {
            visualIBKArg = null;
        }
        return visualIBKArg;
    }

    private final void setupWebView() {
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        WebView $this$setupWebView_u24lambda_u2d19 = webView;
        boolean bl = false;
        this.webViewManager = new WebViewManager(new WebViewParam($this$setupWebView_u24lambda_u2d19, new WebViewCallback(){

            public void onPageFinished(@Nullable WebView view, @Nullable String url) {
            }
        }));
        WebViewManager webViewManager = this.webViewManager;
        if (webViewManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webViewManager");
            webViewManager = null;
        }
        webViewManager.setupWebView();
        this.setupBridges($this$setupWebView_u24lambda_u2d19);
    }

    private final void showProgress() {
        block0: {
            FragmentActivity fragmentActivity = this.getActivity();
            VisualBaseActivity visualBaseActivity = fragmentActivity instanceof VisualBaseActivity ? (VisualBaseActivity)fragmentActivity : null;
            if (visualBaseActivity == null) break block0;
            visualBaseActivity.showProgress();
        }
    }

    private final void closeProgress() {
        block0: {
            FragmentActivity fragmentActivity = this.getActivity();
            VisualBaseActivity visualBaseActivity = fragmentActivity instanceof VisualBaseActivity ? (VisualBaseActivity)fragmentActivity : null;
            if (visualBaseActivity == null) break block0;
            visualBaseActivity.closeProgress();
        }
    }

    @SuppressLint(value={"JavascriptInterface"})
    private final void setupBridges(WebView webView) {
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this;
        VisualReceiptViewModel visualReceiptViewModel = this.viewModel;
        if (visualReceiptViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel = null;
        }
        AndroidUIBridge $this$setupBridges_u24lambda_u2d20 = new AndroidUIBridge(lifecycleOwner, webView, visualReceiptViewModel);
        boolean bl = false;
        webView.addJavascriptInterface((Object)$this$setupBridges_u24lambda_u2d20, $this$setupBridges_u24lambda_u2d20.getBridgeName());
    }

    private final void setupProgressEvents() {
        VisualReceiptViewModel visualReceiptViewModel = this.viewModel;
        if (visualReceiptViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel = null;
        }
        visualReceiptViewModel.isProgress().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupProgressEvents$lambda-21(this, arg_0));
        VisualReceiptViewModel visualReceiptViewModel2 = this.viewModel;
        if (visualReceiptViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel2 = null;
        }
        visualReceiptViewModel2.getProgressCount().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupProgressEvents$lambda-22(this, arg_0));
        VisualReceiptViewModel visualReceiptViewModel3 = this.viewModel;
        if (visualReceiptViewModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel3 = null;
        }
        visualReceiptViewModel3.getError().observe(this.getViewLifecycleOwner(), arg_0 -> VisualReceiptFragment.setupProgressEvents$lambda-23(this, arg_0));
    }

    private final void setupOnBackPressedDispatcher() {
        block0: {
            FragmentActivity fragmentActivity = this.getActivity();
            if (fragmentActivity == null || (fragmentActivity = fragmentActivity.getOnBackPressedDispatcher()) == null) break block0;
            fragmentActivity.addCallback(new OnBackPressedCallback(this){
                final /* synthetic */ VisualReceiptFragment this$0;
                {
                    this.this$0 = $receiver;
                    super(true);
                }

                public void handleOnBackPressed() {
                    block4: {
                        block3: {
                            WebView webView = VisualReceiptFragment.access$getWebView$p(this.this$0);
                            if (webView == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                                webView = null;
                            }
                            if (!webView.canGoBack()) break block3;
                            WebView webView2 = VisualReceiptFragment.access$getWebView$p(this.this$0);
                            if (webView2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                                webView2 = null;
                            }
                            webView2.goBack();
                            VisualReceiptFragment.access$hideAd(this.this$0);
                            break block4;
                        }
                        FragmentActivity fragmentActivity = this.this$0.getActivity();
                        if (fragmentActivity != null) {
                            fragmentActivity.overridePendingTransition(0, 0);
                        }
                        FragmentActivity fragmentActivity2 = this.this$0.getActivity();
                        if (fragmentActivity2 == null) break block4;
                        fragmentActivity2.finish();
                    }
                }
            });
        }
    }

    private final boolean shouldRequestOverlayPermission() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        return PermissionUtil.INSTANCE.shouldRequestOverlayPermission(context);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 10: {
                WebViewManager webViewManager = this.webViewManager;
                if (webViewManager == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webViewManager");
                    webViewManager = null;
                }
                webViewManager.setClearHistory(true);
                this.closeProgress();
                this.startByVisualUrl();
                break;
            }
            case 100: {
                WebView webView = this.webView;
                if (webView == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                    webView = null;
                }
                webView.reload();
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.destroy();
    }

    public void onPause() {
        super.onPause();
        this.hideAd();
    }

    public void onResume() {
        super.onResume();
    }

    private static final void setupSwipeRefreshView$lambda-2$lambda-1(SwipeRefreshLayout $this_with, VisualReceiptFragment this$0) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $this_with.setRefreshing(false);
        WebView webView = this$0.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.reload();
    }

    private static final void setupEvents$lambda-3(VisualReceiptFragment this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.startVisual();
    }

    private static final void setupEvents$lambda-4(VisualReceiptFragment this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        WebView webView = this$0.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.loadUrl(it);
    }

    private static final void setupEvents$lambda-7(VisualReceiptFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            CardView cardView = this$0.createCardView(it);
            if (cardView != null) {
                FrameLayout frameLayout;
                CardView adView = cardView;
                boolean bl = false;
                int adIndex = 0;
                adIndex = -1;
                FrameLayout frameLayout2 = this$0.webContainer;
                if (frameLayout2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webContainer");
                    frameLayout2 = null;
                }
                Iterable $this$forEach$iv = (Iterable)new IntRange(0, frameLayout2.getChildCount());
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    View view;
                    int element$iv;
                    int index = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    FrameLayout frameLayout3 = this$0.webContainer;
                    if (frameLayout3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"webContainer");
                        frameLayout3 = null;
                    }
                    if (!((view = frameLayout3.getChildAt(index)) instanceof CardView)) continue;
                    adIndex = index;
                }
                if (adIndex != -1) {
                    FrameLayout frameLayout4;
                    FrameLayout frameLayout5 = this$0.webContainer;
                    if (frameLayout5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"webContainer");
                        frameLayout5 = null;
                    }
                    if ((frameLayout4 = this$0.webContainer) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"webContainer");
                        frameLayout4 = null;
                    }
                    frameLayout5.removeView(frameLayout4.getChildAt(adIndex));
                }
                if ((frameLayout = this$0.webContainer) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webContainer");
                    frameLayout = null;
                }
                frameLayout.addView((View)adView);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final void setupEvents$lambda-8(VisualReceiptFragment this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.hideAd();
    }

    private static final void setupEvents$lambda-9(VisualReceiptFragment this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        SwipeRefreshLayout swipeRefreshLayout = this$0.swipeRefreshLayout;
        if (swipeRefreshLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"swipeRefreshLayout");
            swipeRefreshLayout = null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        swipeRefreshLayout.setEnabled(it.booleanValue());
    }

    private static final void setupEvents$lambda-10(VisualReceiptFragment this$0, String it) {
        LinearLayout linearLayout;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        VisualReceiptViewModel visualReceiptViewModel = this$0.viewModel;
        if (visualReceiptViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            visualReceiptViewModel = null;
        }
        if (visualReceiptViewModel.isLogger()) {
            VisualReceiptViewModel visualReceiptViewModel2 = this$0.viewModel;
            if (visualReceiptViewModel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                visualReceiptViewModel2 = null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            visualReceiptViewModel2.showToast(it);
            TextView textView = this$0.errorTextView;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"errorTextView");
                textView = null;
            }
            textView.setText((CharSequence)it);
        }
        if ((linearLayout = this$0.errorContainer) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorContainer");
            linearLayout = null;
        }
        linearLayout.setVisibility(0);
    }

    private static final void setupEvents$lambda-11(VisualReceiptFragment this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + this$0.requireContext().getApplicationContext().getPackageName())));
                intent.addFlags(262144);
                this$0.startActivityForResult(intent, 10);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final void setupEvents$lambda-12(Unit it) {
    }

    private static final void setupEvents$lambda-13(VisualReceiptFragment this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Boolean bl = it;
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            this$0.showProgress();
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            this$0.closeProgress();
        }
    }

    private static final void setupEvents$lambda-14(VisualReceiptFragment this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        WebView webView = this$0.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.reload();
    }

    private static final void setupErrorView$lambda-16(VisualReceiptFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        LinearLayout linearLayout = this$0.errorContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorContainer");
            linearLayout = null;
        }
        linearLayout.setVisibility(8);
        this$0.start();
    }

    private static final void setupProgressEvents$lambda-21(VisualReceiptFragment this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        if (it.booleanValue()) {
            WebView webView = this$0.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            VisualReceiptViewModel visualReceiptViewModel = this$0.viewModel;
            if (visualReceiptViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                visualReceiptViewModel = null;
            }
            webView.loadUrl(stringBuilder.append(visualReceiptViewModel.getUrl()).append(PROGRESS_URL).toString());
        } else {
            this$0.isBulk = true;
            this$0.startVisual();
            WebViewManager webViewManager = this$0.webViewManager;
            if (webViewManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webViewManager");
                webViewManager = null;
            }
            webViewManager.setClearHistory(true);
        }
    }

    private static final void setupProgressEvents$lambda-22(VisualReceiptFragment this$0, ProgressCount it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        WebView webView = this$0.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.loadUrl("javascript:window.onProgress(" + it.getNow() + ", " + it.getTotal() + ");");
    }

    private static final void setupProgressEvents$lambda-23(VisualReceiptFragment this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.startVisual();
    }

    @JvmStatic
    @NotNull
    public static final VisualReceiptFragment newInstance(@NotNull VisualIBKArg arg) {
        return Companion.newInstance(arg);
    }

    public static final /* synthetic */ WebView access$getWebView$p(VisualReceiptFragment $this) {
        return $this.webView;
    }

    public static final /* synthetic */ void access$hideAd(VisualReceiptFragment $this) {
        $this.hideAd();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/tenqube/ibkreceipt/VisualReceiptFragment$Companion;", "", "()V", "PROGRESS_URL", "", "REQ_CODE_NOTI_SETTINGS", "", "REQ_CODE_OVERLAY_PERMISSION", "URL", "VISUAL_IBK_ARG", "newInstance", "Lcom/tenqube/ibkreceipt/VisualReceiptFragment;", "arg", "Lcom/tenqube/ibkreceipt/VisualIBKArg;", "ibkreceipt_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final VisualReceiptFragment newInstance(@NotNull VisualIBKArg arg) {
            void $this$newInstance_u24lambda_u2d1_u24lambda_u2d0;
            Bundle bundle;
            VisualReceiptFragment visualReceiptFragment;
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            VisualReceiptFragment $this$newInstance_u24lambda_u2d1 = visualReceiptFragment = new VisualReceiptFragment();
            boolean bl = false;
            Bundle bundle2 = bundle = new Bundle();
            VisualReceiptFragment visualReceiptFragment2 = $this$newInstance_u24lambda_u2d1;
            boolean bl2 = false;
            $this$newInstance_u24lambda_u2d1_u24lambda_u2d0.putSerializable(VisualReceiptFragment.VISUAL_IBK_ARG, (Serializable)arg);
            visualReceiptFragment2.setArguments(bundle);
            return visualReceiptFragment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

