/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.ibkreceipt;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import com.tenqube.shared.util.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lcom/tenqube/ibkreceipt/PermissionUtil;", "", "()V", "hasNotiServicePermission", "", "context", "Landroid/content/Context;", "hasOverlayPermission", "shouldRequestOverlayPermission", "startOverlaySettings", "", "activity", "Landroid/app/Activity;", "code", "", "ibkreceipt_release"})
public final class PermissionUtil {
    @NotNull
    public static final PermissionUtil INSTANCE = new PermissionUtil();

    private PermissionUtil() {
    }

    public final boolean hasNotiServicePermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Utils.INSTANCE.isNotiEnabled(context);
    }

    public final boolean shouldRequestOverlayPermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT >= 29 && !Settings.canDrawOverlays((Context)context);
    }

    public final boolean hasOverlayPermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT >= 29 && Settings.canDrawOverlays((Context)context);
    }

    public final void startOverlaySettings(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + context.getPackageName())));
            intent.addFlags(262144);
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void startOverlaySettings(@NotNull Activity activity, int code) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        try {
            Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + activity.getPackageName())));
            intent.addFlags(262144);
            activity.startActivityForResult(intent, code);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

