/*
 * Decompiled with CFR 0.152.
 */
package com.tenginekit.face;

import com.tenginekit.KitCore;
import com.tenginekit.face.FaceAttributionInfo;
import com.tenginekit.face.FaceDetectInfo;
import com.tenginekit.face.FaceIrisInfo;
import com.tenginekit.face.FaceLandmark3dInfo;
import com.tenginekit.face.FaceLandmarkInfo;
import com.tenginekit.jni.FaceSchedule;
import com.tenginekit.model.TenginekitPoint;
import java.util.ArrayList;
import java.util.List;

public class Face {
    public static synchronized FaceDetect detect(byte[] imageData) {
        float[] faces = FaceSchedule.detect((byte[])imageData);
        return new FaceDetect(faces);
    }

    public static class FaceDetect {
        private static FaceDetect Last;
        private int faceCount = 0;
        private List<FaceDetectInfo> detectInfos;

        private FaceDetect(float[] faces) {
            if (faces == null) {
                this.faceCount = 0;
                this.detectInfos = null;
                return;
            }
            this.faceCount = faces.length / 4;
            this.detectInfos = new ArrayList<FaceDetectInfo>(this.faceCount);
            for (int i = 0; i < faces.length; i += 4) {
                FaceDetectInfo faceInfo1 = new FaceDetectInfo();
                faceInfo1.left = (int)faces[i];
                faceInfo1.top = (int)faces[i + 1];
                faceInfo1.right = (int)faces[i + 2];
                faceInfo1.bottom = (int)faces[i + 3];
                faceInfo1.width = faceInfo1.right - faceInfo1.left;
                faceInfo1.height = faceInfo1.bottom - faceInfo1.top;
                this.detectInfos.add(faceInfo1);
            }
            Last = this;
        }

        public synchronized boolean isVaild() {
            return this == Last;
        }

        public synchronized List<FaceDetectInfo> getDetectInfos() {
            return this.detectInfos;
        }

        public synchronized int getFaceCount() {
            return this.faceCount;
        }

        public synchronized List<FaceLandmarkInfo> landmark2d() {
            if (!KitCore.getInit()) {
                throw new RuntimeException("SDK not init");
            }
            if (!this.isVaild()) {
                throw new RuntimeException("Current obj is invaild");
            }
            if (this.faceCount == 0) {
                return null;
            }
            ArrayList<FaceLandmarkInfo> faceLandmarkInfos = new ArrayList<FaceLandmarkInfo>(this.faceCount);
            float[] landmarks = FaceSchedule.getLandmarks();
            int DataCount = landmarks.length / this.faceCount;
            int landmarkCount = (DataCount - 7) / 2;
            for (int i = 0; i < this.faceCount; ++i) {
                FaceLandmarkInfo cur_Face = new FaceLandmarkInfo();
                cur_Face.pitch = landmarks[DataCount * i + landmarkCount * 2];
                cur_Face.yaw = landmarks[DataCount * i + landmarkCount * 2 + 1];
                cur_Face.roll = landmarks[DataCount * i + landmarkCount * 2 + 2];
                cur_Face.leftEyeClose = landmarks[DataCount * i + landmarkCount * 2 + 3];
                cur_Face.rightEyeClose = landmarks[DataCount * i + landmarkCount * 2 + 4];
                cur_Face.mouseClose = landmarks[DataCount * i + landmarkCount * 2 + 5];
                cur_Face.mouseOpenBig = landmarks[DataCount * i + landmarkCount * 2 + 6];
                cur_Face.landmarks = new ArrayList<TenginekitPoint>();
                for (int j = 0; j < landmarkCount; ++j) {
                    TenginekitPoint l = new TenginekitPoint(landmarks[j * 2 + DataCount * i], landmarks[j * 2 + 1 + DataCount * i]);
                    cur_Face.landmarks.add(l);
                }
                faceLandmarkInfos.add(cur_Face);
            }
            return faceLandmarkInfos;
        }

        public synchronized List<FaceLandmark3dInfo> landmark3d() {
            if (!KitCore.getInit()) {
                throw new RuntimeException("SDK not init");
            }
            if (!this.isVaild()) {
                throw new RuntimeException("Current obj is invaild");
            }
            if (this.faceCount == 0) {
                return null;
            }
            ArrayList<FaceLandmark3dInfo> faceLandmarkInfos = new ArrayList<FaceLandmark3dInfo>(this.faceCount);
            float[] landmarks = FaceSchedule.getLandmark3d();
            int DataCount = landmarks.length / this.faceCount;
            int landmarkCount = DataCount / 2;
            for (int i = 0; i < this.faceCount; ++i) {
                FaceLandmark3dInfo cur_Face = new FaceLandmark3dInfo();
                cur_Face.landmarks = new ArrayList<TenginekitPoint>();
                for (int j = 0; j < landmarkCount; ++j) {
                    TenginekitPoint l = new TenginekitPoint(landmarks[j * 2 + DataCount * i], landmarks[j * 2 + 1 + DataCount * i]);
                    cur_Face.landmarks.add(l);
                }
                faceLandmarkInfos.add(cur_Face);
            }
            return faceLandmarkInfos;
        }

        public synchronized List<FaceAttributionInfo> attribution() {
            if (!KitCore.getInit()) {
                throw new RuntimeException("SDK not init");
            }
            if (!this.isVaild()) {
                throw new RuntimeException("Current obj is invaild");
            }
            if (this.faceCount == 0) {
                return null;
            }
            ArrayList<FaceAttributionInfo> faceAttributionInfos = new ArrayList<FaceAttributionInfo>(this.faceCount);
            float[] attributes = FaceSchedule.attritube();
            int size = attributes.length / 6;
            for (int i = 0; i < size; ++i) {
                FaceAttributionInfo ai = new FaceAttributionInfo();
                ai.age = (int)attributes[i * 6];
                ai.isMan = (int)attributes[i * 6 + 1] == 0;
                ai.smile = (int)attributes[i * 6 + 2];
                ai.glasses = (int)attributes[i * 6 + 3] > 0;
                ai.beatyOfManLook = (int)attributes[i * 6 + 4];
                ai.beautyOfWomanLook = (int)attributes[i * 6 + 5];
                faceAttributionInfos.add(ai);
            }
            return faceAttributionInfos;
        }

        public synchronized List<FaceIrisInfo> iris3d() {
            if (!KitCore.getInit()) {
                throw new RuntimeException("SDK not init");
            }
            if (!this.isVaild()) {
                throw new RuntimeException("Current obj is invaild");
            }
            if (this.faceCount == 0) {
                return null;
            }
            ArrayList<FaceIrisInfo> faceEyeInfos = new ArrayList<FaceIrisInfo>(this.faceCount);
            float[] iris = FaceSchedule.getEyeLandmark3d();
            int DataCount = 304;
            int size = iris.length / DataCount;
            for (int i = 0; i < size; ++i) {
                TenginekitPoint right;
                TenginekitPoint left;
                int j;
                FaceIrisInfo iri = new FaceIrisInfo();
                for (j = 0; j < 71; ++j) {
                    left = new TenginekitPoint(iris[j * 2 + DataCount * i], iris[j * 2 + 1 + DataCount * i]);
                    right = new TenginekitPoint(iris[j * 2 + DataCount / 2 + DataCount * i], iris[j * 2 + 1 + DataCount / 2 + DataCount * i]);
                    iri.leftEye.eyeLandmark.add(left);
                    iri.rightEye.eyeLandmark.add(right);
                }
                for (j = 0; j < 5; ++j) {
                    left = new TenginekitPoint(iris[j * 2 + 142 + DataCount * i], iris[j * 2 + 1 + 142 + DataCount * i]);
                    right = new TenginekitPoint(iris[j * 2 + DataCount / 2 + 142 + DataCount * i], iris[j * 2 + 1 + DataCount / 2 + 142 + DataCount * i]);
                    iri.leftEye.eyeIris.add(left);
                    iri.rightEye.eyeIris.add(right);
                }
                faceEyeInfos.add(iri);
            }
            return faceEyeInfos;
        }
    }
}

