package com.tenginekit.face;

import android.graphics.Rect;

import com.tenginekit.model.TenginekitPoint;

import java.util.List;

public class FaceLandmarkInfo {
    /**
     * Face key points
     */
    public List<TenginekitPoint> landmarks;
    /**
     * Pitch
     */
    public float pitch = 0;
    /**
     * Yaw
     */
    public float yaw = 0;
    /**
     * Roll
     */
    public float roll = 0;
    /**
     * Left eye closure confidence
     */
    public float leftEyeClose = 0;
    /**
     * Right eye closure confidence
     */
    public float rightEyeClose = 0;
    /**
     * Confidence of mouth closure
     */
    public float mouseClose = 0;
    /**
     * Open mouth confidence
     */
    public float mouseOpenBig = 0;

    public Rect getBoundingBox(){
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = 0;
        int bottom = 0;

        for(TenginekitPoint p : landmarks){
            if(p.X < left){
                left = (int)p.X;
            }
            if(p.X > right){
                right = (int)p.X;
            }
            if(p.Y < top){
                top = (int)p.Y;
            }
            if(p.Y > bottom){
                bottom = (int)p.Y;
            }
        }

        return new Rect(left, top, right, bottom);
    }
}
