package com.tenginekit.face;

import com.tenginekit.KitCore;
import com.tenginekit.jni.FaceSchedule;
import com.tenginekit.model.TenginekitPoint;

import java.util.ArrayList;
import java.util.List;

public class Face {
    public static class FaceDetect {
        private static FaceDetect Last;

        private int faceCount = 0;
        private List<FaceDetectInfo> detectInfos;

        private FaceDetect(float[] faces) {
            if (faces == null) {
                faceCount = 0;
                detectInfos = null;
                return;
            }
            faceCount = faces.length / 4;
            detectInfos = new ArrayList<>(faceCount);
            for (int i = 0; i < faces.length; i += 4) {
                FaceDetectInfo faceInfo1 = new FaceDetectInfo();
                faceInfo1.left = (int) faces[i];
                faceInfo1.top = (int) faces[i + 1];
                faceInfo1.right = (int) faces[i + 2];
                faceInfo1.bottom = (int) faces[i + 3];
                faceInfo1.width = faceInfo1.right - faceInfo1.left;
                faceInfo1.height = faceInfo1.bottom - faceInfo1.top;
                detectInfos.add(faceInfo1);
            }
            Last = this;
        }

        synchronized public boolean isVaild(){
            return this == Last;
        }

        synchronized public List<FaceDetectInfo> getDetectInfos() {
            return detectInfos;
        }

        synchronized public int getFaceCount() {
            return faceCount;
        }

        synchronized public List<FaceLandmarkInfo> landmark2d() {
            if (!KitCore.getInit()){
                throw new RuntimeException("SDK not init");
            }
            if (!isVaild()) {
                throw new RuntimeException("Current obj is invaild");
            }
            if (faceCount == 0) return null;
            List<FaceLandmarkInfo> faceLandmarkInfos = new ArrayList<>(faceCount);
            float[] landmarks = FaceSchedule.getLandmarks();
            int DataCount = landmarks.length / faceCount;
            int landmarkCount = (DataCount - 7) / 2;
            for (int i = 0; i < faceCount; i++) {
                FaceLandmarkInfo cur_Face = new FaceLandmarkInfo();
                cur_Face.pitch = landmarks[DataCount * i + landmarkCount * 2];
                cur_Face.yaw = landmarks[DataCount * i + landmarkCount * 2 + 1];
                cur_Face.roll = landmarks[DataCount * i + landmarkCount * 2 + 2];
                cur_Face.leftEyeClose = landmarks[DataCount * i + landmarkCount * 2 + 3];
                cur_Face.rightEyeClose = landmarks[DataCount * i + landmarkCount * 2 + 4];
                cur_Face.mouseClose = landmarks[DataCount * i + landmarkCount * 2 + 5];
                cur_Face.mouseOpenBig = landmarks[DataCount * i + landmarkCount * 2 + 6];
                cur_Face.landmarks = new ArrayList<>();
                for (int j = 0; j < landmarkCount; j++) {
                    TenginekitPoint l = new TenginekitPoint(landmarks[j * 2 + DataCount * i], landmarks[j * 2 + 1 + DataCount * i]);
                    cur_Face.landmarks.add(l);
                }
                faceLandmarkInfos.add(cur_Face);
            }
            return faceLandmarkInfos;
        }

        synchronized public List<FaceLandmark3dInfo> landmark3d() {
            if (!KitCore.getInit()){
                throw new RuntimeException("SDK not init");
            }
            if (!isVaild()) {
                throw new RuntimeException("Current obj is invaild");
            }
            if (faceCount == 0) return null;
            List<FaceLandmark3dInfo> faceLandmarkInfos = new ArrayList<>(faceCount);
            float[] landmarks = FaceSchedule.getLandmark3d();
            int DataCount = landmarks.length / faceCount;
            int landmarkCount = DataCount / 2;
            for (int i = 0; i < faceCount; i++) {
                FaceLandmark3dInfo cur_Face = new FaceLandmark3dInfo();

                cur_Face.landmarks = new ArrayList<>();
                for (int j = 0; j < landmarkCount; j++) {
                    TenginekitPoint l = new TenginekitPoint(landmarks[j * 2 + DataCount * i], landmarks[j * 2 + 1 + DataCount * i]);
                    cur_Face.landmarks.add(l);
                }
                faceLandmarkInfos.add(cur_Face);
            }
            return faceLandmarkInfos;
        }

        synchronized public List<FaceAttributionInfo> attribution() {
            if (!KitCore.getInit()){
                throw new RuntimeException("SDK not init");
            }
            if (!isVaild()) {
                throw new RuntimeException("Current obj is invaild");
            }
            if (faceCount == 0) return null;
            List<FaceAttributionInfo> faceAttributionInfos = new ArrayList<>(faceCount);
            float[] attributes = FaceSchedule.attritube();
            int size = attributes.length / 6;
            for (int i = 0; i < size; i++) {
                FaceAttributionInfo ai = new FaceAttributionInfo();
                ai.age = (int) attributes[i * 6];
                ai.isMan = (int) attributes[i * 6 + 1] == 0 ? true : false;
                ai.smile = (int) attributes[i * 6 + 2];
                ai.glasses = (int) attributes[i * 6 + 3] > 0 ? true : false;
                ai.beatyOfManLook = (int) attributes[i * 6 + 4];
                ai.beautyOfWomanLook = (int) attributes[i * 6 + 5];
                faceAttributionInfos.add(ai);
            }
            return faceAttributionInfos;
        }

        synchronized public List<FaceIrisInfo> iris3d() {
            if (!KitCore.getInit()){
                throw new RuntimeException("SDK not init");
            }
            if (!isVaild()) {
                throw new RuntimeException("Current obj is invaild");
            }
            if (faceCount == 0) return null;
            List<FaceIrisInfo> faceEyeInfos = new ArrayList<>(faceCount);
            float[] iris = FaceSchedule.getEyeLandmark3d();
            int DataCount = 2 * 2 * (71 + 5);
            int size = iris.length / DataCount;
            for (int i = 0; i < size; i++) {
                FaceIrisInfo iri = new FaceIrisInfo();
                for (int j = 0 ;j < 71; j++)
                {
                    TenginekitPoint left = new TenginekitPoint(iris[j * 2 + DataCount * i], iris[j * 2 + 1 + DataCount * i]);
                    TenginekitPoint right = new TenginekitPoint(iris[j * 2 + DataCount / 2 + DataCount * i], iris[j * 2 + 1 + DataCount / 2 + DataCount * i]);

                    iri.leftEye.eyeLandmark.add(left);
                    iri.rightEye.eyeLandmark.add(right);
                }
                for (int j = 0 ;j < 5; j++)
                {
                    TenginekitPoint left = new TenginekitPoint(iris[j * 2 + (71 * 2) + DataCount * i], iris[j * 2 + 1 + (71 * 2) + DataCount * i]);
                    TenginekitPoint right = new TenginekitPoint(iris[j * 2 + DataCount / 2 + (71 * 2) + DataCount * i], iris[j * 2 + 1 + DataCount / 2 + (71 * 2) + DataCount * i]);
                    iri.leftEye.eyeIris.add(left);
                    iri.rightEye.eyeIris.add(right);
                }
                faceEyeInfos.add(iri);
            }
            return faceEyeInfos;
        }
    }

    synchronized public static Face.FaceDetect detect(byte[] imageData) {
        float[] faces = FaceSchedule.detect(imageData);
        return new Face.FaceDetect(faces);
    }

}
